/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl.apache;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import org.apache.iceberg.shaded.org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.ContentType;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.HttpEntity;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.io.entity.HttpEntities;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.RequestContext;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.impl.BaseHttpRequest;
import org.projectnessie.client.http.impl.HttpHeaders;
import org.projectnessie.client.http.impl.apache.ApacheHttpClient;
import org.projectnessie.client.http.impl.apache.ApacheResponseContext;

final class ApacheRequest
extends BaseHttpRequest {
    private final ApacheHttpClient client;

    ApacheRequest(ApacheHttpClient apacheHttpClient, URI baseUri) {
        super(apacheHttpClient.config, baseUri);
        this.client = apacheHttpClient;
    }

    @Override
    protected ResponseContext sendAndReceive(URI uri, HttpClient.Method method, Object body, RequestContext requestContext) throws IOException {
        HttpUriRequestBase request = new HttpUriRequestBase(method.name(), uri);
        for (HttpHeaders.HttpHeader header : this.headers.allHeaders()) {
            for (String value : header.getValues()) {
                request.addHeader(header.getName(), value);
            }
        }
        request.addHeader("Accept", this.accept);
        if (requestContext.doesOutput()) {
            HttpEntity entity = HttpEntities.create(os -> this.writeToOutputStream(requestContext, (OutputStream)os), ContentType.parse(this.contentsType));
            request.setEntity(entity);
        }
        ClassicHttpResponse response = this.client.client.executeOpen(null, request, null);
        return new ApacheResponseContext(response, uri);
    }
}

