/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.CommitConsistency;
import org.projectnessie.model.ImmutableReferenceHistoryResponse;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferenceHistoryState;

@Schema(type=SchemaType.OBJECT, title="ReferenceHistoryResponse", description="Describes the consistency status of a named reference.\n\nPossible values of the `CommitConsistency` enum:\n- `NOT_CHECKED` means: Consistency was not checked.\n- `COMMIT_CONSISTENT` means: The commit object, its index information and all reachable content is present.\n- `COMMIT_CONTENT_INCONSISTENT` means: The commit object is present and its index is accessible, but some content reachable from the commit is not present.\n- `COMMIT_INCONSISTENT` means: The commit is inconsistent in a way that makes it impossible to access the commit, for example if the commit object itself or its index information is missing.")
@JsonSerialize(as=ImmutableReferenceHistoryResponse.class)
@JsonDeserialize(as=ImmutableReferenceHistoryResponse.class)
@Value.Immutable
public interface ReferenceHistoryResponse {
    public static ImmutableReferenceHistoryResponse.Builder builder() {
        return ImmutableReferenceHistoryResponse.builder();
    }

    @javax.validation.constraints.NotNull
    @NotNull
    public Reference getReference();

    @Schema(description="Consistency status of the current HEAD commit.")
    @javax.validation.constraints.NotNull
    @NotNull
    public ReferenceHistoryState current();

    @Schema(description="Consistency status of the recorded recent HEADs of the reference, including re-assign operations.")
    @javax.validation.constraints.NotNull
    @NotNull
    public List<ReferenceHistoryState> previous();

    @Schema(description="Combined consistency status of the commit-log of the reference, if requested by the client.")
    @javax.validation.constraints.NotNull
    @NotNull
    public CommitConsistency commitLogConsistency();
}

