/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.lang.reflect.Array;
import java.util.Comparator;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllItemsHelper;
import org.apache.datasketches.kll.KllItemsSketch;
import org.apache.datasketches.kll.KllMemoryValidate;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;

final class KllHeapItemsSketch<T>
extends KllItemsSketch<T> {
    private final int k;
    private final int m;
    private long n;
    private int minK;
    private boolean isLevelZeroSorted;
    private T minItem;
    private T maxItem;
    private Object[] itemsArr;

    KllHeapItemsSketch(int k, int m4, Comparator<? super T> comparator, ArrayOfItemsSerDe<T> serDe) {
        super(KllSketch.SketchStructure.UPDATABLE, comparator, serDe);
        KllHelper.checkM(m4);
        KllHelper.checkK(k, m4);
        this.levelsArr = new int[]{k, k};
        this.readOnly = false;
        this.k = k;
        this.m = m4;
        this.n = 0L;
        this.minK = k;
        this.isLevelZeroSorted = false;
        this.minItem = null;
        this.maxItem = null;
        this.itemsArr = new Object[k];
    }

    KllHeapItemsSketch(int k, int m4, T item, long weight, Comparator<? super T> comparator, ArrayOfItemsSerDe<T> serDe) {
        super(KllSketch.SketchStructure.UPDATABLE, comparator, serDe);
        KllHelper.checkM(m4);
        KllHelper.checkK(k, m4);
        this.levelsArr = KllHelper.createLevelsArray(weight);
        this.readOnly = false;
        this.k = k;
        this.m = m4;
        this.n = weight;
        this.minK = k;
        this.isLevelZeroSorted = false;
        this.minItem = item;
        this.maxItem = item;
        this.itemsArr = KllItemsHelper.createItemsArray(serDe.getClassOfT(), item, weight);
    }

    KllHeapItemsSketch(Memory srcMem, Comparator<? super T> comparator, ArrayOfItemsSerDe<T> serDe) {
        super(KllSketch.SketchStructure.UPDATABLE, comparator, serDe);
        KllMemoryValidate memVal = new KllMemoryValidate(srcMem, KllSketch.SketchType.ITEMS_SKETCH, serDe);
        this.k = memVal.k;
        this.m = memVal.m;
        this.levelsArr = memVal.levelsArr;
        this.readOnly = false;
        this.n = memVal.n;
        this.minK = memVal.minK;
        this.isLevelZeroSorted = memVal.level0SortedFlag;
        this.itemsArr = new Object[this.levelsArr[memVal.numLevels]];
        KllSketch.SketchStructure memStruct = memVal.sketchStructure;
        if (memStruct == KllSketch.SketchStructure.COMPACT_EMPTY) {
            this.minItem = null;
            this.maxItem = null;
            this.itemsArr = new Object[this.k];
        } else if (memStruct == KllSketch.SketchStructure.COMPACT_SINGLE) {
            int offset = 8;
            T item = serDe.deserializeFromMemory(srcMem, 8L, 1)[0];
            this.minItem = item;
            this.maxItem = item;
            this.itemsArr[this.k - 1] = item;
        } else if (memStruct == KllSketch.SketchStructure.COMPACT_FULL) {
            int offset = 20 + memVal.numLevels * 4;
            this.minItem = serDe.deserializeFromMemory(srcMem, offset, 1)[0];
            this.maxItem = serDe.deserializeFromMemory(srcMem, offset += serDe.sizeOf(this.minItem), 1)[0];
            int numRetained = this.levelsArr[memVal.numLevels] - this.levelsArr[0];
            T[] retItems = serDe.deserializeFromMemory(srcMem, offset += serDe.sizeOf(this.maxItem), numRetained);
            System.arraycopy(retItems, 0, this.itemsArr, this.levelsArr[0], numRetained);
        } else {
            throw new SketchesArgumentException("Unsupported operation for this Sketch Type. UPDATABLE");
        }
    }

    @Override
    String getItemAsString(int index) {
        if (this.isEmpty()) {
            return "Null";
        }
        return this.serDe.toString(this.itemsArr[index]);
    }

    @Override
    public int getK() {
        return this.k;
    }

    @Override
    public T getMaxItem() {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        return this.maxItem;
    }

    @Override
    String getMaxItemAsString() {
        if (this.isEmpty()) {
            return "Null";
        }
        return this.serDe.toString(this.maxItem);
    }

    @Override
    public T getMinItem() {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        return this.minItem;
    }

    @Override
    String getMinItemAsString() {
        if (this.isEmpty()) {
            return "Null";
        }
        return this.serDe.toString(this.minItem);
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    int getM() {
        return this.m;
    }

    @Override
    int getMinK() {
        return this.minK;
    }

    @Override
    byte[] getMinMaxByteArr() {
        byte[] minBytes = this.serDe.serializeToByteArray(this.minItem);
        byte[] maxBytes = this.serDe.serializeToByteArray(this.maxItem);
        byte[] minMaxBytes = new byte[minBytes.length + maxBytes.length];
        ByteArrayUtil.copyBytes(minBytes, 0, minMaxBytes, 0, minBytes.length);
        ByteArrayUtil.copyBytes(maxBytes, 0, minMaxBytes, minBytes.length, maxBytes.length);
        return minMaxBytes;
    }

    @Override
    int getMinMaxSizeBytes() {
        int minBytes = this.serDe.sizeOf(this.minItem);
        int maxBytes = this.serDe.sizeOf(this.maxItem);
        return minBytes + maxBytes;
    }

    @Override
    T[] getRetainedItemsArray() {
        int numRet = this.getNumRetained();
        Object[] outArr = (Object[])Array.newInstance(this.serDe.getClassOfT(), numRet);
        System.arraycopy(this.itemsArr, this.levelsArr[0], outArr, 0, numRet);
        return outArr;
    }

    @Override
    byte[] getRetainedItemsByteArr() {
        T[] retArr = this.getRetainedItemsArray();
        return this.serDe.serializeToByteArray(retArr);
    }

    @Override
    int getRetainedItemsSizeBytes() {
        return this.getRetainedItemsByteArr().length;
    }

    @Override
    T getSingleItem() {
        if (this.n != 1L) {
            throw new SketchesArgumentException("Sketch does not have just one item. ");
        }
        Object item = this.itemsArr[this.k - 1];
        return (T)item;
    }

    @Override
    byte[] getSingleItemByteArr() {
        return this.serDe.serializeToByteArray(this.getSingleItem());
    }

    @Override
    int getSingleItemSizeBytes() {
        return this.serDe.sizeOf(this.getSingleItem());
    }

    @Override
    T[] getTotalItemsArray() {
        if (this.n == 0L) {
            return (Object[])Array.newInstance(this.serDe.getClassOfT(), this.k);
        }
        Object[] outArr = (Object[])Array.newInstance(this.serDe.getClassOfT(), this.itemsArr.length);
        System.arraycopy(this.itemsArr, 0, outArr, 0, this.itemsArr.length);
        return outArr;
    }

    @Override
    WritableMemory getWritableMemory() {
        return null;
    }

    @Override
    void incN(int increment) {
        this.n += (long)increment;
    }

    @Override
    boolean isLevelZeroSorted() {
        return this.isLevelZeroSorted;
    }

    @Override
    void setLevelZeroSorted(boolean sorted) {
        this.isLevelZeroSorted = sorted;
    }

    @Override
    void setMinK(int minK) {
        this.minK = minK;
    }

    @Override
    void setN(long n) {
        this.n = n;
    }

    @Override
    void setItemsArray(Object[] itemsArr) {
        this.itemsArr = itemsArr;
    }

    @Override
    void setItemsArrayAt(int index, Object item) {
        this.itemsArr[index] = item;
    }

    @Override
    void setMaxItem(Object item) {
        this.maxItem = item;
    }

    @Override
    void setMinItem(Object item) {
        this.minItem = item;
    }
}

