/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.sampling;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;

final class EbppsItemsSample<T> {
    private double c_;
    private T partialItem_;
    private ArrayList<T> data_;
    private Random rand_;

    EbppsItemsSample(int reservedSize) {
        this.c_ = 0.0;
        this.data_ = new ArrayList(reservedSize);
        this.rand_ = ThreadLocalRandom.current();
    }

    EbppsItemsSample(EbppsItemsSample<T> other) {
        this.c_ = other.c_;
        this.partialItem_ = other.partialItem_;
        this.data_ = new ArrayList<T>(other.data_);
        this.rand_ = other.rand_;
    }

    EbppsItemsSample(ArrayList<T> data, T partialItem, double c) {
        if (c < 0.0 || Double.isNaN(c) || Double.isInfinite(c)) {
            throw new SketchesArgumentException("C must be nonnegative and finite. Found: " + c);
        }
        this.c_ = c;
        this.partialItem_ = partialItem;
        this.data_ = data;
        this.rand_ = ThreadLocalRandom.current();
    }

    void replaceContent(T item, double theta) {
        if (theta < 0.0 || theta > 1.0 || Double.isNaN(theta)) {
            throw new SketchesArgumentException("Theta must be in the range [0.0, 1.0]. Found: " + theta);
        }
        this.c_ = theta;
        if (theta == 1.0) {
            if (this.data_ != null && this.data_.size() == 1) {
                this.data_.set(0, item);
            } else {
                this.data_ = new ArrayList(1);
                this.data_.add(item);
            }
            this.partialItem_ = null;
        } else {
            this.data_ = null;
            this.partialItem_ = item;
        }
    }

    void reset() {
        this.c_ = 0.0;
        this.partialItem_ = null;
        this.data_.clear();
    }

    ArrayList<T> getSample() {
        boolean includePartial;
        double cFrac = this.c_ % 1.0;
        int resultSize = (this.data_ != null ? this.data_.size() : 0) + ((includePartial = this.partialItem_ != null && this.rand_.nextDouble() < cFrac) ? 1 : 0);
        if (resultSize == 0) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>(resultSize);
        if (this.data_ != null) {
            result.addAll(this.data_);
        }
        if (includePartial) {
            result.add(this.partialItem_);
        }
        return result;
    }

    T[] getAllSamples(Class<?> clazz) {
        Object[] itemsArray = (Object[])Array.newInstance(clazz, this.getNumRetainedItems());
        int i = 0;
        if (this.data_ != null) {
            for (T item : this.data_) {
                if (item == null) continue;
                itemsArray[i++] = item;
            }
        }
        if (this.partialItem_ != null) {
            itemsArray[i] = this.partialItem_;
        }
        return itemsArray;
    }

    ArrayList<T> getFullItems() {
        return this.data_;
    }

    T getPartialItem() {
        return this.partialItem_;
    }

    double getC() {
        return this.c_;
    }

    boolean hasPartialItem() {
        return this.partialItem_ != null;
    }

    void replaceRandom(Random r) {
        this.rand_ = r;
    }

    void downsample(double theta) {
        if (theta >= 1.0) {
            return;
        }
        double newC = theta * this.c_;
        double newCInt = Math.floor(newC);
        double newCFrac = newC % 1.0;
        double cInt = Math.floor(this.c_);
        double cFrac = this.c_ % 1.0;
        if (newCInt == 0.0) {
            if (this.rand_.nextDouble() > cFrac / this.c_) {
                this.swapWithPartialItem();
            }
            this.data_.clear();
        } else if (newCInt == cInt) {
            if (this.rand_.nextDouble() > (1.0 - theta * cFrac) / (1.0 - newCFrac)) {
                this.swapWithPartialItem();
            }
        } else if (this.rand_.nextDouble() < theta * cFrac) {
            this.subsample((int)newCInt);
            this.swapWithPartialItem();
        } else {
            this.subsample((int)newCInt + 1);
            this.moveOneToPartialItem();
        }
        if (newC == newCInt) {
            this.partialItem_ = null;
        }
        this.c_ = newC;
    }

    void merge(EbppsItemsSample<T> other) {
        double cFrac = this.c_ % 1.0;
        double otherCFrac = other.c_ % 1.0;
        this.c_ += other.c_;
        if (other.data_ != null) {
            this.data_.addAll(other.data_);
        }
        if (cFrac == 0.0 && otherCFrac == 0.0) {
            this.partialItem_ = null;
        } else if (cFrac + otherCFrac == 1.0 || this.c_ == Math.floor(this.c_)) {
            if (this.rand_.nextDouble() <= cFrac) {
                if (this.partialItem_ != null) {
                    this.data_.add(this.partialItem_);
                }
            } else if (other.partialItem_ != null) {
                this.data_.add(other.partialItem_);
            }
            this.partialItem_ = null;
        } else if (cFrac + otherCFrac < 1.0) {
            if (this.rand_.nextDouble() > cFrac / (cFrac + otherCFrac)) {
                this.partialItem_ = other.partialItem_;
            }
        } else if (this.rand_.nextDouble() <= (1.0 - cFrac) / (1.0 - cFrac + (1.0 - otherCFrac))) {
            this.data_.add(other.partialItem_);
        } else {
            this.data_.add(this.partialItem_);
            this.partialItem_ = other.partialItem_;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("  sample:").append(Util.LS);
        int idx = 0;
        for (T item : this.data_) {
            sb.append("\t").append(idx++).append(":\t").append(item.toString()).append(Util.LS);
        }
        sb.append("  partial: ");
        if (this.partialItem_ != null) {
            sb.append(this.partialItem_).append(Util.LS);
        } else {
            sb.append("NULL").append(Util.LS);
        }
        return sb.toString();
    }

    void subsample(int numSamples) {
        if (numSamples == this.data_.size()) {
            return;
        }
        int dataLen = this.data_.size();
        for (int i = 0; i < numSamples; ++i) {
            int j = i + this.rand_.nextInt(dataLen - i);
            T tmp = this.data_.get(i);
            this.data_.set(i, this.data_.get(j));
            this.data_.set(j, tmp);
        }
        this.data_.subList(numSamples, this.data_.size()).clear();
    }

    void swapWithPartialItem() {
        if (this.partialItem_ == null) {
            this.moveOneToPartialItem();
        } else {
            int idx = this.rand_.nextInt(this.data_.size());
            T tmp = this.partialItem_;
            this.partialItem_ = this.data_.get(idx);
            this.data_.set(idx, tmp);
        }
    }

    void moveOneToPartialItem() {
        int lastIdx;
        int idx = this.rand_.nextInt(this.data_.size());
        if (idx != (lastIdx = this.data_.size() - 1)) {
            T tmp = this.data_.get(idx);
            this.data_.set(idx, this.data_.get(lastIdx));
            this.partialItem_ = tmp;
        } else {
            this.partialItem_ = this.data_.get(lastIdx);
        }
        this.data_.remove(lastIdx);
    }

    int getNumRetainedItems() {
        return (this.data_ != null ? this.data_.size() : 0) + (this.partialItem_ != null ? 1 : 0);
    }
}

