/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tdigest;

import java.util.concurrent.ThreadLocalRandom;

public final class Sort {
    public static void stableSort(double[] keys, long[] values, int n) {
        Sort.stableLimitedQuickSort(keys, values, 0, n, 64);
        Sort.stableLimitedInsertionSort(keys, values, 0, n, 64);
    }

    private static void stableLimitedQuickSort(double[] keys, long[] values, int start, int end, int limit) {
        while (end - start > limit) {
            int pivotIndex = start + ThreadLocalRandom.current().nextInt(end - start);
            double pivotValue = keys[pivotIndex];
            Sort.swap(keys, start, pivotIndex);
            Sort.swap(values, start, pivotIndex);
            int low = start + 1;
            int high = end;
            int i = low;
            while (i < high) {
                double vi = keys[i];
                if (vi == pivotValue && i == pivotIndex) {
                    if (low != i) {
                        Sort.swap(keys, low, i);
                        Sort.swap(values, low, i);
                    } else {
                        ++i;
                    }
                    ++low;
                    continue;
                }
                if (vi > pivotValue || vi == pivotValue && i > pivotIndex) {
                    Sort.swap(keys, i, --high);
                    Sort.swap(values, i, high);
                    continue;
                }
                ++i;
            }
            int from = start;
            int to = high - 1;
            i = 0;
            while (from < low && to >= low) {
                Sort.swap(keys, from, to);
                Sort.swap(values, from++, to--);
                ++i;
            }
            if ((low = from == low ? to + 1 : from) - start < end - high) {
                Sort.stableLimitedQuickSort(keys, values, start, low, limit);
                start = high;
                continue;
            }
            Sort.stableLimitedQuickSort(keys, values, high, end, limit);
            end = low;
        }
    }

    private static void stableLimitedInsertionSort(double[] keys, long[] values, int start, int n, int limit) {
        block0: for (int i = start + 1; i < n; ++i) {
            double k = keys[i];
            long v = values[i];
            int m4 = Math.max(i - limit, start);
            for (int j = i; j >= m4; --j) {
                if (j != 0 && !(keys[j - 1] <= k)) continue;
                if (j >= i) continue block0;
                System.arraycopy(keys, j, keys, j + 1, i - j);
                System.arraycopy(values, j, values, j + 1, i - j);
                keys[j] = k;
                values[j] = v;
                continue block0;
            }
        }
    }

    private static void swap(double[] values, int i, int j) {
        double tmpValue = values[i];
        values[i] = values[j];
        values[j] = tmpValue;
    }

    private static void swap(long[] values, int i, int j) {
        long tmpValue = values[i];
        values[i] = values[j];
        values[j] = tmpValue;
    }

    public static void reverse(double[] values, int n) {
        for (int i = 0; i < n / 2; ++i) {
            Sort.swap(values, i, n - i - 1);
        }
    }

    public static void reverse(long[] values, int n) {
        for (int i = 0; i < n / 2; ++i) {
            Sort.swap(values, i, n - i - 1);
        }
    }
}

