/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.util.Arrays;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.DirectCompactSketch;
import org.apache.datasketches.theta.EmptyCompactSketch;
import org.apache.datasketches.theta.HeapCompactSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.SingleItemSketch;

final class CompactOperations {
    private CompactOperations() {
    }

    static CompactSketch componentsToCompact(long thetaLong, int curCount, short seedHash, boolean srcEmpty, boolean srcCompact, boolean srcOrdered, boolean dstOrdered, WritableMemory dstMem, long[] hashArr) {
        boolean dstOrderedOut;
        boolean direct = dstMem != null;
        boolean empty = srcEmpty || curCount == 0 && thetaLong == Long.MAX_VALUE;
        boolean single = curCount == 1 && thetaLong == Long.MAX_VALUE;
        long[] hashArrOut = !srcCompact ? CompactOperations.compactCache(hashArr, curCount, thetaLong, dstOrdered) : hashArr;
        if (!srcOrdered && dstOrdered && !empty && !single) {
            Arrays.sort(hashArrOut);
        }
        boolean bl = dstOrderedOut = empty || single ? true : dstOrdered;
        if (direct) {
            int preLongs = CompactOperations.computeCompactPreLongs(empty, curCount, thetaLong);
            int flags = 10;
            flags |= empty ? 4 : 0;
            flags |= dstOrderedOut ? 16 : 0;
            Memory mem = CompactOperations.loadCompactMemory(hashArrOut, seedHash, curCount, thetaLong, dstMem, (byte)(flags |= single ? 32 : 0), preLongs);
            return new DirectCompactSketch(mem);
        }
        if (empty) {
            return EmptyCompactSketch.getInstance();
        }
        if (single) {
            return new SingleItemSketch(hashArrOut[0], seedHash);
        }
        return new HeapCompactSketch(hashArrOut, empty, seedHash, curCount, thetaLong, dstOrderedOut);
    }

    static CompactSketch memoryToCompact(Memory srcMem, boolean dstOrdered, WritableMemory dstMem) {
        long[] hashArr;
        boolean dstOrderedOut;
        long thetaLong;
        boolean single;
        int srcPreLongs = PreambleUtil.extractPreLongs(srcMem);
        int srcSerVer = PreambleUtil.extractSerVer(srcMem);
        int srcFamId = PreambleUtil.extractFamilyID(srcMem);
        int srcLgArrLongs = PreambleUtil.extractLgArrLongs(srcMem);
        int srcFlags = PreambleUtil.extractFlags(srcMem);
        short srcSeedHash = (short)PreambleUtil.extractSeedHash(srcMem);
        boolean srcReadOnlyFlag = (srcFlags & 2) > 0;
        boolean srcEmptyFlag = (srcFlags & 4) > 0;
        boolean srcCompactFlag = (srcFlags & 8) > 0;
        boolean srcOrderedFlag = (srcFlags & 0x10) > 0;
        boolean srcSingleFlag = (srcFlags & 0x20) > 0;
        boolean bl = single = srcSingleFlag || SingleItemSketch.otherCheckForSingleItem(srcPreLongs, srcSerVer, srcFamId, srcFlags);
        int curCount = single ? 1 : (srcPreLongs > 1 ? PreambleUtil.extractCurCount(srcMem) : 0);
        long l = thetaLong = srcPreLongs > 2 ? PreambleUtil.extractThetaLong(srcMem) : Long.MAX_VALUE;
        if (srcEmptyFlag) assert (curCount == 0 && thetaLong == Long.MAX_VALUE);
        if (single) assert (curCount == 1 && thetaLong == Long.MAX_VALUE);
        CompactOperations.checkFamilyAndFlags(srcFamId, srcCompactFlag, srcReadOnlyFlag);
        boolean bl2 = dstOrderedOut = srcEmptyFlag || single ? true : dstOrdered;
        if (srcEmptyFlag) {
            if (dstMem != null) {
                dstMem.putByteArray(0L, EmptyCompactSketch.EMPTY_COMPACT_SKETCH_ARR, 0, 8);
                return new DirectCompactSketch(dstMem);
            }
            return EmptyCompactSketch.getInstance();
        }
        if (single) {
            long hash = srcMem.getLong(srcPreLongs << 3);
            SingleItemSketch sis = new SingleItemSketch(hash, srcSeedHash);
            if (dstMem != null) {
                dstMem.putByteArray(0L, sis.toByteArray(), 0, 16);
                return new DirectCompactSketch(dstMem);
            }
            return sis;
        }
        if (srcCompactFlag) {
            hashArr = new long[curCount];
            srcMem.getLongArray(srcPreLongs << 3, hashArr, 0, curCount);
        } else {
            int srcCacheLen = 1 << srcLgArrLongs;
            long[] tempHashArr = new long[srcCacheLen];
            srcMem.getLongArray(srcPreLongs << 3, tempHashArr, 0, srcCacheLen);
            hashArr = CompactOperations.compactCache(tempHashArr, curCount, thetaLong, dstOrderedOut);
        }
        int flagsOut = 0xA | (dstOrderedOut ? 16 : 0);
        if (dstMem != null) {
            Memory tgtMem = CompactOperations.loadCompactMemory(hashArr, srcSeedHash, curCount, thetaLong, dstMem, (byte)flagsOut, srcPreLongs);
            return new DirectCompactSketch(tgtMem);
        }
        return new HeapCompactSketch(hashArr, srcEmptyFlag, srcSeedHash, curCount, thetaLong, dstOrderedOut);
    }

    private static final void checkFamilyAndFlags(int srcFamId, boolean srcCompactFlag, boolean srcReadOnlyFlag) {
        Family srcFamily = Family.idToFamily(srcFamId);
        if (srcCompactFlag) {
            if (srcFamily == Family.COMPACT && srcReadOnlyFlag) {
                return;
            }
        } else {
            if (srcFamily == Family.ALPHA) {
                return;
            }
            if (srcFamily == Family.QUICKSELECT) {
                return;
            }
        }
        throw new SketchesArgumentException("Possible Corruption: Family does not match flags: Family: " + srcFamily.toString() + ", Compact Flag: " + srcCompactFlag + ", ReadOnly Flag: " + srcReadOnlyFlag);
    }

    static final Memory loadCompactMemory(long[] compactHashArr, short seedHash, int curCount, long thetaLong, WritableMemory dstMem, byte flags, int preLongs) {
        assert (dstMem != null && compactHashArr != null);
        int outLongs = preLongs + curCount;
        int outBytes = outLongs << 3;
        int dstBytes = (int)dstMem.getCapacity();
        if (outBytes > dstBytes) {
            throw new SketchesArgumentException("Insufficient Memory: " + dstBytes + ", Need: " + outBytes);
        }
        byte famID = (byte)Family.COMPACT.getID();
        PreambleUtil.insertPreLongs(dstMem, preLongs);
        PreambleUtil.insertSerVer(dstMem, 3);
        PreambleUtil.insertFamilyID(dstMem, famID);
        dstMem.putShort(3L, (short)0);
        PreambleUtil.insertFlags(dstMem, flags);
        PreambleUtil.insertSeedHash(dstMem, seedHash);
        if (preLongs == 1 && curCount == 1) {
            dstMem.putLong(8L, compactHashArr[0]);
            return dstMem;
        }
        if (preLongs > 1) {
            PreambleUtil.insertCurCount(dstMem, curCount);
            PreambleUtil.insertP(dstMem, 1.0f);
        }
        if (preLongs > 2) {
            PreambleUtil.insertThetaLong(dstMem, thetaLong);
        }
        if (curCount > 0) {
            dstMem.putLongArray(preLongs << 3, compactHashArr, 0, curCount);
        }
        return dstMem;
    }

    static final long[] compactCache(long[] srcCache, int curCount, long thetaLong, boolean dstOrdered) {
        if (curCount == 0) {
            return new long[0];
        }
        long[] cacheOut = new long[curCount];
        int len = srcCache.length;
        int j = 0;
        for (int i = 0; i < len; ++i) {
            long v = srcCache[i];
            if (v <= 0L || v >= thetaLong) continue;
            cacheOut[j++] = v;
        }
        if (j < curCount) {
            throw new SketchesStateException("Possible Corruption: curCount parameter is incorrect.");
        }
        if (dstOrdered && curCount > 1) {
            Arrays.sort(cacheOut);
        }
        return cacheOut;
    }

    static final long correctThetaOnCompact(boolean empty, int curCount, long thetaLong) {
        return empty && curCount == 0 ? Long.MAX_VALUE : thetaLong;
    }

    static final void checkIllegalCurCountAndEmpty(boolean empty, int curCount) {
        if (empty && curCount != 0) {
            throw new SketchesStateException("Illegal State: Empty=true and Current Count != 0.");
        }
    }

    static final int computeCompactPreLongs(boolean empty, int curCount, long thetaLong) {
        return thetaLong < Long.MAX_VALUE ? 3 : (empty ? 1 : (curCount > 1 ? 2 : 1));
    }

    static final boolean isSingleItem(boolean empty, int curCount, long thetaLong) {
        return !empty && curCount == 1 && thetaLong == Long.MAX_VALUE;
    }
}

