/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.sampling.ReservoirItemsSketch;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.EnumSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.iceberg.SortKey;
import org.apache.iceberg.flink.sink.shuffle.DataStatistics;
import org.apache.iceberg.flink.sink.shuffle.MapDataStatistics;
import org.apache.iceberg.flink.sink.shuffle.SketchDataStatistics;
import org.apache.iceberg.flink.sink.shuffle.SortKeySerializer;
import org.apache.iceberg.flink.sink.shuffle.SortKeySketchSerializer;
import org.apache.iceberg.flink.sink.shuffle.StatisticsType;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

@Internal
class DataStatisticsSerializer
extends TypeSerializer<DataStatistics> {
    private final TypeSerializer<SortKey> sortKeySerializer;
    private final EnumSerializer<StatisticsType> statisticsTypeSerializer;
    private final MapSerializer<SortKey, Long> mapSerializer;
    private final SortKeySketchSerializer sketchSerializer;

    DataStatisticsSerializer(TypeSerializer<SortKey> sortKeySerializer) {
        this.sortKeySerializer = sortKeySerializer;
        this.statisticsTypeSerializer = new EnumSerializer(StatisticsType.class);
        this.mapSerializer = new MapSerializer(sortKeySerializer, (TypeSerializer)LongSerializer.INSTANCE);
        this.sketchSerializer = new SortKeySketchSerializer(sortKeySerializer);
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<DataStatistics> duplicate() {
        TypeSerializer duplicateSortKeySerializer = this.sortKeySerializer.duplicate();
        return duplicateSortKeySerializer == this.sortKeySerializer ? this : new DataStatisticsSerializer((TypeSerializer<SortKey>)duplicateSortKeySerializer);
    }

    public DataStatistics createInstance() {
        return new MapDataStatistics();
    }

    public DataStatistics copy(DataStatistics obj) {
        StatisticsType statisticsType = obj.type();
        if (statisticsType == StatisticsType.Map) {
            MapDataStatistics from = (MapDataStatistics)obj;
            Map fromStats = (Map)from.result();
            HashMap<SortKey, Long> toStats = Maps.newHashMap(fromStats);
            return new MapDataStatistics(toStats);
        }
        if (statisticsType == StatisticsType.Sketch) {
            SketchDataStatistics from = (SketchDataStatistics)obj;
            ReservoirItemsSketch fromStats = (ReservoirItemsSketch)from.result();
            byte[] bytes = fromStats.toByteArray(this.sketchSerializer);
            Memory memory = Memory.wrap(bytes);
            ReservoirItemsSketch<SortKey> toStats = ReservoirItemsSketch.heapify(memory, this.sketchSerializer);
            return new SketchDataStatistics(toStats);
        }
        throw new IllegalArgumentException("Unsupported data statistics type: " + (Object)((Object)statisticsType));
    }

    public DataStatistics copy(DataStatistics from, DataStatistics reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(DataStatistics obj, DataOutputView target) throws IOException {
        StatisticsType statisticsType = obj.type();
        this.statisticsTypeSerializer.serialize((Enum)obj.type(), target);
        if (statisticsType == StatisticsType.Map) {
            Map mapStatistics = (Map)obj.result();
            this.mapSerializer.serialize(mapStatistics, target);
        } else if (statisticsType == StatisticsType.Sketch) {
            ReservoirItemsSketch sketch = (ReservoirItemsSketch)obj.result();
            byte[] sketchBytes = sketch.toByteArray(this.sketchSerializer);
            target.writeInt(sketchBytes.length);
            target.write(sketchBytes);
        } else {
            throw new IllegalArgumentException("Unsupported data statistics type: " + (Object)((Object)statisticsType));
        }
    }

    public DataStatistics deserialize(DataInputView source) throws IOException {
        StatisticsType statisticsType = (StatisticsType)this.statisticsTypeSerializer.deserialize(source);
        if (statisticsType == StatisticsType.Map) {
            Map mapStatistics = this.mapSerializer.deserialize(source);
            return new MapDataStatistics(mapStatistics);
        }
        if (statisticsType == StatisticsType.Sketch) {
            int numBytes = source.readInt();
            byte[] sketchBytes = new byte[numBytes];
            source.read(sketchBytes);
            Memory sketchMemory = Memory.wrap(sketchBytes);
            ReservoirItemsSketch<SortKey> sketch = ReservoirItemsSketch.heapify(sketchMemory, this.sketchSerializer);
            return new SketchDataStatistics(sketch);
        }
        throw new IllegalArgumentException("Unsupported data statistics type: " + (Object)((Object)statisticsType));
    }

    public DataStatistics deserialize(DataStatistics reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataStatisticsSerializer)) {
            return false;
        }
        DataStatisticsSerializer other = (DataStatisticsSerializer)((Object)obj);
        return Objects.equals(this.sortKeySerializer, other.sortKeySerializer);
    }

    public int hashCode() {
        return this.sortKeySerializer.hashCode();
    }

    public TypeSerializerSnapshot<DataStatistics> snapshotConfiguration() {
        return new DataStatisticsSerializerSnapshot(this);
    }

    public static class DataStatisticsSerializerSnapshot
    extends CompositeTypeSerializerSnapshot<DataStatistics, DataStatisticsSerializer> {
        private static final int CURRENT_VERSION = 1;

        public DataStatisticsSerializerSnapshot() {
        }

        public DataStatisticsSerializerSnapshot(DataStatisticsSerializer serializer) {
            super((TypeSerializer)serializer);
        }

        protected int getCurrentOuterSnapshotVersion() {
            return 1;
        }

        protected TypeSerializer<?>[] getNestedSerializers(DataStatisticsSerializer outerSerializer) {
            return new TypeSerializer[]{outerSerializer.sortKeySerializer};
        }

        protected DataStatisticsSerializer createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            SortKeySerializer sortKeySerializer = (SortKeySerializer)nestedSerializers[0];
            return new DataStatisticsSerializer(sortKeySerializer);
        }
    }
}

