/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.iceberg.flink.sink.shuffle.AggregatedStatistics;
import org.apache.iceberg.flink.sink.shuffle.DataStatistics;
import org.apache.iceberg.flink.sink.shuffle.StatisticsUtil;

@Internal
class StatisticsEvent
implements OperatorEvent {
    private static final long serialVersionUID = 1L;
    private final long checkpointId;
    private final byte[] statisticsBytes;

    private StatisticsEvent(long checkpointId, byte[] statisticsBytes) {
        this.checkpointId = checkpointId;
        this.statisticsBytes = statisticsBytes;
    }

    static StatisticsEvent createTaskStatisticsEvent(long checkpointId, DataStatistics statistics, TypeSerializer<DataStatistics> statisticsSerializer) {
        return new StatisticsEvent(checkpointId, StatisticsUtil.serializeDataStatistics(statistics, statisticsSerializer));
    }

    static StatisticsEvent createAggregatedStatisticsEvent(long checkpointId, AggregatedStatistics statistics, TypeSerializer<AggregatedStatistics> statisticsSerializer) {
        return new StatisticsEvent(checkpointId, StatisticsUtil.serializeAggregatedStatistics(statistics, statisticsSerializer));
    }

    long checkpointId() {
        return this.checkpointId;
    }

    byte[] statisticsBytes() {
        return this.statisticsBytes;
    }
}

