/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.iceberg.flink.sink.shuffle.AggregatedStatistics;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

@Internal
public class StatisticsOrRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private AggregatedStatistics statistics;
    private RowData record;

    private StatisticsOrRecord(AggregatedStatistics statistics, RowData record) {
        Preconditions.checkArgument(record != null ^ statistics != null, "DataStatistics or record, not neither or both");
        this.statistics = statistics;
        this.record = record;
    }

    static StatisticsOrRecord fromRecord(RowData record) {
        return new StatisticsOrRecord(null, record);
    }

    static StatisticsOrRecord fromStatistics(AggregatedStatistics statistics) {
        return new StatisticsOrRecord(statistics, null);
    }

    static StatisticsOrRecord reuseRecord(StatisticsOrRecord reuse, TypeSerializer<RowData> recordSerializer) {
        if (reuse.hasRecord()) {
            return reuse;
        }
        return StatisticsOrRecord.fromRecord((RowData)recordSerializer.createInstance());
    }

    static StatisticsOrRecord reuseStatistics(StatisticsOrRecord reuse, TypeSerializer<AggregatedStatistics> statisticsSerializer) {
        if (reuse.hasStatistics()) {
            return reuse;
        }
        return StatisticsOrRecord.fromStatistics((AggregatedStatistics)statisticsSerializer.createInstance());
    }

    boolean hasStatistics() {
        return this.statistics != null;
    }

    public boolean hasRecord() {
        return this.record != null;
    }

    AggregatedStatistics statistics() {
        return this.statistics;
    }

    void statistics(AggregatedStatistics newStatistics) {
        this.statistics = newStatistics;
    }

    public RowData record() {
        return this.record;
    }

    void record(RowData newRecord) {
        this.record = newRecord;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("statistics", this.statistics).add("record", this.record).toString();
    }
}

