/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.data.RowData;
import org.apache.iceberg.flink.sink.shuffle.AggregatedStatistics;
import org.apache.iceberg.flink.sink.shuffle.StatisticsOrRecord;

@Internal
class StatisticsOrRecordSerializer
extends TypeSerializer<StatisticsOrRecord> {
    private final TypeSerializer<AggregatedStatistics> statisticsSerializer;
    private final TypeSerializer<RowData> recordSerializer;

    StatisticsOrRecordSerializer(TypeSerializer<AggregatedStatistics> statisticsSerializer, TypeSerializer<RowData> recordSerializer) {
        this.statisticsSerializer = statisticsSerializer;
        this.recordSerializer = recordSerializer;
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<StatisticsOrRecord> duplicate() {
        TypeSerializer duplicateStatisticsSerializer = this.statisticsSerializer.duplicate();
        TypeSerializer duplicateRowDataSerializer = this.recordSerializer.duplicate();
        if (this.statisticsSerializer != duplicateStatisticsSerializer || this.recordSerializer != duplicateRowDataSerializer) {
            return new StatisticsOrRecordSerializer((TypeSerializer<AggregatedStatistics>)duplicateStatisticsSerializer, (TypeSerializer<RowData>)duplicateRowDataSerializer);
        }
        return this;
    }

    public StatisticsOrRecord createInstance() {
        return StatisticsOrRecord.fromRecord((RowData)this.recordSerializer.createInstance());
    }

    public StatisticsOrRecord copy(StatisticsOrRecord from) {
        if (from.hasRecord()) {
            return StatisticsOrRecord.fromRecord((RowData)this.recordSerializer.copy((Object)from.record()));
        }
        return StatisticsOrRecord.fromStatistics((AggregatedStatistics)this.statisticsSerializer.copy((Object)from.statistics()));
    }

    public StatisticsOrRecord copy(StatisticsOrRecord from, StatisticsOrRecord reuse) {
        StatisticsOrRecord to;
        if (from.hasRecord()) {
            to = StatisticsOrRecord.reuseRecord(reuse, this.recordSerializer);
            RowData record = (RowData)this.recordSerializer.copy((Object)from.record(), (Object)to.record());
            to.record(record);
        } else {
            to = StatisticsOrRecord.reuseStatistics(reuse, this.statisticsSerializer);
            AggregatedStatistics statistics = (AggregatedStatistics)this.statisticsSerializer.copy((Object)from.statistics(), (Object)to.statistics());
            to.statistics(statistics);
        }
        return to;
    }

    public int getLength() {
        return -1;
    }

    public void serialize(StatisticsOrRecord statisticsOrRecord, DataOutputView target) throws IOException {
        if (statisticsOrRecord.hasRecord()) {
            target.writeBoolean(true);
            this.recordSerializer.serialize((Object)statisticsOrRecord.record(), target);
        } else {
            target.writeBoolean(false);
            this.statisticsSerializer.serialize((Object)statisticsOrRecord.statistics(), target);
        }
    }

    public StatisticsOrRecord deserialize(DataInputView source) throws IOException {
        boolean isRecord = source.readBoolean();
        if (isRecord) {
            return StatisticsOrRecord.fromRecord((RowData)this.recordSerializer.deserialize(source));
        }
        return StatisticsOrRecord.fromStatistics((AggregatedStatistics)this.statisticsSerializer.deserialize(source));
    }

    public StatisticsOrRecord deserialize(StatisticsOrRecord reuse, DataInputView source) throws IOException {
        StatisticsOrRecord to;
        boolean isRecord = source.readBoolean();
        if (isRecord) {
            to = StatisticsOrRecord.reuseRecord(reuse, this.recordSerializer);
            RowData record = (RowData)this.recordSerializer.deserialize((Object)to.record(), source);
            to.record(record);
        } else {
            to = StatisticsOrRecord.reuseStatistics(reuse, this.statisticsSerializer);
            AggregatedStatistics statistics = (AggregatedStatistics)this.statisticsSerializer.deserialize((Object)to.statistics(), source);
            to.statistics(statistics);
        }
        return to;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        boolean hasRecord = source.readBoolean();
        target.writeBoolean(hasRecord);
        if (hasRecord) {
            this.recordSerializer.copy(source, target);
        } else {
            this.statisticsSerializer.copy(source, target);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StatisticsOrRecordSerializer)) {
            return false;
        }
        StatisticsOrRecordSerializer other = (StatisticsOrRecordSerializer)((Object)obj);
        return Objects.equals(this.statisticsSerializer, other.statisticsSerializer) && Objects.equals(this.recordSerializer, other.recordSerializer);
    }

    public int hashCode() {
        return Objects.hash(this.statisticsSerializer, this.recordSerializer);
    }

    public TypeSerializerSnapshot<StatisticsOrRecord> snapshotConfiguration() {
        return new StatisticsOrRecordSerializerSnapshot(this);
    }

    public static class StatisticsOrRecordSerializerSnapshot
    extends CompositeTypeSerializerSnapshot<StatisticsOrRecord, StatisticsOrRecordSerializer> {
        private static final int CURRENT_VERSION = 1;

        public StatisticsOrRecordSerializerSnapshot() {
        }

        public StatisticsOrRecordSerializerSnapshot(StatisticsOrRecordSerializer serializer) {
            super((TypeSerializer)serializer);
        }

        protected int getCurrentOuterSnapshotVersion() {
            return 1;
        }

        protected TypeSerializer<?>[] getNestedSerializers(StatisticsOrRecordSerializer outerSerializer) {
            return new TypeSerializer[]{outerSerializer.statisticsSerializer, outerSerializer.recordSerializer};
        }

        protected StatisticsOrRecordSerializer createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            TypeSerializer<?> statisticsSerializer = nestedSerializers[0];
            TypeSerializer<?> recordSerializer = nestedSerializers[1];
            return new StatisticsOrRecordSerializer(statisticsSerializer, recordSerializer);
        }
    }
}

