/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.io.IOException;
import java.io.UncheckedIOException;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.iceberg.flink.sink.shuffle.AggregatedStatistics;
import org.apache.iceberg.flink.sink.shuffle.DataStatistics;
import org.apache.iceberg.flink.sink.shuffle.MapDataStatistics;
import org.apache.iceberg.flink.sink.shuffle.SketchDataStatistics;
import org.apache.iceberg.flink.sink.shuffle.SketchUtil;
import org.apache.iceberg.flink.sink.shuffle.StatisticsType;

class StatisticsUtil {
    private StatisticsUtil() {
    }

    static DataStatistics createTaskStatistics(StatisticsType type, int operatorParallelism, int numPartitions) {
        if (type == StatisticsType.Map) {
            return new MapDataStatistics();
        }
        return new SketchDataStatistics(SketchUtil.determineOperatorReservoirSize(operatorParallelism, numPartitions));
    }

    static byte[] serializeDataStatistics(DataStatistics dataStatistics, TypeSerializer<DataStatistics> statisticsSerializer) {
        DataOutputSerializer out = new DataOutputSerializer(64);
        try {
            statisticsSerializer.serialize((Object)dataStatistics, (DataOutputView)out);
            return out.getCopyOfBuffer();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Fail to serialize data statistics", e);
        }
    }

    static DataStatistics deserializeDataStatistics(byte[] bytes, TypeSerializer<DataStatistics> statisticsSerializer) {
        DataInputDeserializer input = new DataInputDeserializer(bytes, 0, bytes.length);
        try {
            return (DataStatistics)statisticsSerializer.deserialize((DataInputView)input);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Fail to deserialize data statistics", e);
        }
    }

    static byte[] serializeAggregatedStatistics(AggregatedStatistics aggregatedStatistics, TypeSerializer<AggregatedStatistics> statisticsSerializer) {
        try {
            DataOutputSerializer out = new DataOutputSerializer(1024);
            statisticsSerializer.serialize((Object)aggregatedStatistics, (DataOutputView)out);
            return out.getCopyOfBuffer();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Fail to serialize aggregated statistics", e);
        }
    }

    static AggregatedStatistics deserializeAggregatedStatistics(byte[] bytes, TypeSerializer<AggregatedStatistics> statisticsSerializer) {
        try {
            DataInputDeserializer input = new DataInputDeserializer(bytes);
            return (AggregatedStatistics)statisticsSerializer.deserialize((DataInputView)input);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Fail to deserialize aggregated statistics", e);
        }
    }

    static StatisticsType collectType(StatisticsType config) {
        return config == StatisticsType.Sketch ? StatisticsType.Sketch : StatisticsType.Map;
    }

    static StatisticsType collectType(StatisticsType config, @Nullable AggregatedStatistics restoredStatistics) {
        if (restoredStatistics != null) {
            return restoredStatistics.type();
        }
        return StatisticsUtil.collectType(config);
    }
}

