/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.util.function.Supplier;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.iceberg.Table;
import org.apache.iceberg.flink.FlinkConfigOptions;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

class SourceUtil {
    private SourceUtil() {
    }

    static boolean isLocalityEnabled(Table table, ReadableConfig readableConfig, Boolean exposeLocality) {
        Boolean localityEnabled;
        Boolean bl = localityEnabled = exposeLocality != null ? exposeLocality : (Boolean)readableConfig.get(FlinkConfigOptions.TABLE_EXEC_ICEBERG_EXPOSE_SPLIT_LOCALITY_INFO);
        if (localityEnabled != null && !localityEnabled.booleanValue()) {
            return false;
        }
        return Util.mayHaveBlockLocations(table.io(), table.location());
    }

    static int inferParallelism(ReadableConfig readableConfig, long limitCount, Supplier<Integer> splitCountProvider) {
        int parallelism = (Integer)readableConfig.get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM);
        if (((Boolean)readableConfig.get(FlinkConfigOptions.TABLE_EXEC_ICEBERG_INFER_SOURCE_PARALLELISM)).booleanValue()) {
            int maxInferParallelism = (Integer)readableConfig.get(FlinkConfigOptions.TABLE_EXEC_ICEBERG_INFER_SOURCE_PARALLELISM_MAX);
            Preconditions.checkState(maxInferParallelism >= 1, FlinkConfigOptions.TABLE_EXEC_ICEBERG_INFER_SOURCE_PARALLELISM_MAX.key() + " cannot be less than 1");
            parallelism = Math.min(splitCountProvider.get(), maxInferParallelism);
        }
        if (limitCount > 0L) {
            int limit = limitCount >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)limitCount;
            parallelism = Math.min(parallelism, limit);
        }
        parallelism = Math.max(1, parallelism);
        return parallelism;
    }
}

