/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.iceberg.ClientPoolImpl;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.hive.RuntimeMetaException;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;

public class HiveClientPool
extends ClientPoolImpl<IMetaStoreClient, TException> {
    private static final DynMethods.StaticMethod GET_CLIENT = DynMethods.builder("getProxy").impl(RetryingMetaStoreClient.class, HiveConf.class, HiveMetaHookLoader.class, String.class).impl(RetryingMetaStoreClient.class, Configuration.class, HiveMetaHookLoader.class, String.class).buildStatic();
    private final HiveConf hiveConf;

    public HiveClientPool(int poolSize, Configuration conf) {
        super(poolSize, TTransportException.class, false);
        this.hiveConf = new HiveConf(conf, HiveClientPool.class);
        this.hiveConf.addResource(conf);
    }

    @Override
    protected IMetaStoreClient newClient() {
        try {
            try {
                return (IMetaStoreClient)GET_CLIENT.invoke(this.hiveConf, tbl -> null, HiveMetaStoreClient.class.getName());
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof MetaException) {
                    throw (MetaException)e.getCause();
                }
                throw e;
            }
        }
        catch (MetaException e) {
            throw new RuntimeMetaException(e, "Failed to connect to Hive Metastore", new Object[0]);
        }
        catch (Throwable t2) {
            if (t2.getMessage() != null && t2.getMessage().contains("Another instance of Derby may have already booted")) {
                throw new RuntimeMetaException(t2, "Failed to start an embedded metastore because embedded Derby supports only one client at a time. To fix this, use a metastore that supports multiple clients.", new Object[0]);
            }
            throw new RuntimeMetaException(t2, "Failed to connect to Hive Metastore", new Object[0]);
        }
    }

    @Override
    protected IMetaStoreClient reconnect(IMetaStoreClient client) {
        try {
            client.close();
            client.reconnect();
        }
        catch (MetaException e) {
            throw new RuntimeMetaException(e, "Failed to reconnect to Hive Metastore", new Object[0]);
        }
        return client;
    }

    @Override
    protected boolean isConnectionException(Exception e) {
        return super.isConnectionException(e) || e instanceof MetaException && e.getMessage().contains("Got exception: org.apache.thrift.transport.TTransportException");
    }

    @Override
    protected void close(IMetaStoreClient client) {
        client.close();
    }

    @VisibleForTesting
    HiveConf hiveConf() {
        return this.hiveConf;
    }
}

