/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.sampling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.sampling.EbppsItemsSample;
import org.apache.datasketches.sampling.PreambleUtil;

public final class EbppsItemsSketch<T> {
    private static final int MAX_K = 0x7FFFFFFD;
    private static final int EBPPS_C_DOUBLE = 40;
    private static final int EBPPS_ITEMS_START = 48;
    private int k_;
    private long n_;
    private double cumulativeWt_;
    private double wtMax_;
    private double rho_;
    private EbppsItemsSample<T> sample_;
    private final EbppsItemsSample<T> tmp_;

    public EbppsItemsSketch(int k) {
        EbppsItemsSketch.checkK(k);
        this.k_ = k;
        this.rho_ = 1.0;
        this.sample_ = new EbppsItemsSample(k);
        this.tmp_ = new EbppsItemsSample(1);
    }

    private EbppsItemsSketch(EbppsItemsSketch<T> other) {
        this.k_ = other.k_;
        this.n_ = other.n_;
        this.rho_ = other.rho_;
        this.cumulativeWt_ = other.cumulativeWt_;
        this.wtMax_ = other.wtMax_;
        this.sample_ = new EbppsItemsSample<T>(other.sample_);
        this.tmp_ = new EbppsItemsSample(1);
    }

    private EbppsItemsSketch(EbppsItemsSample<T> sample, int k, long n, double cumWt, double maxWt, double rho) {
        this.k_ = k;
        this.n_ = n;
        this.cumulativeWt_ = cumWt;
        this.wtMax_ = maxWt;
        this.rho_ = rho;
        this.sample_ = sample;
        this.tmp_ = new EbppsItemsSample(1);
    }

    public static <T> EbppsItemsSketch<T> heapify(Memory srcMem, ArrayOfItemsSerDe<T> serDe) {
        Object partialItem;
        ArrayList<T> data;
        boolean hasPartialItem;
        int numPreLongs = PreambleUtil.getAndCheckPreLongs(srcMem);
        int serVer = PreambleUtil.extractSerVer(srcMem);
        int familyId = PreambleUtil.extractFamilyID(srcMem);
        int flags = PreambleUtil.extractFlags(srcMem);
        boolean isEmpty = (flags & 4) != 0;
        boolean bl = hasPartialItem = (flags & 8) != 0;
        if (isEmpty) {
            if (numPreLongs != Family.EBPPS.getMinPreLongs()) {
                throw new SketchesArgumentException("Possible corruption: Must be " + Family.EBPPS.getMinPreLongs() + " for an empty sketch. Found: " + numPreLongs);
            }
        } else if (numPreLongs != Family.EBPPS.getMaxPreLongs()) {
            throw new SketchesArgumentException("Possible corruption: Must be " + Family.EBPPS.getMaxPreLongs() + " for a non-empty sketch. Found: " + numPreLongs);
        }
        if (serVer != 1) {
            throw new SketchesArgumentException("Possible Corruption: Ser Ver must be 1: " + serVer);
        }
        int reqFamilyId = Family.EBPPS.getID();
        if (familyId != reqFamilyId) {
            throw new SketchesArgumentException("Possible Corruption: FamilyID must be " + reqFamilyId + ": " + familyId);
        }
        int k = PreambleUtil.extractK(srcMem);
        if (k < 1 || k > 0x7FFFFFFD) {
            throw new SketchesArgumentException("Possible Corruption: k must be at least 1 and less than 2147483645. Found: " + k);
        }
        if (isEmpty) {
            return new EbppsItemsSketch<T>(k);
        }
        long n = PreambleUtil.extractN(srcMem);
        if (n < 0L) {
            throw new SketchesArgumentException("Possible Corruption: n cannot be negative: " + n);
        }
        double cumWt = PreambleUtil.extractEbppsCumulativeWeight(srcMem);
        if (cumWt < 0.0 || Double.isNaN(cumWt) || Double.isInfinite(cumWt)) {
            throw new SketchesArgumentException("Possible Corruption: cumWt must be nonnegative and finite: " + cumWt);
        }
        double maxWt = PreambleUtil.extractEbppsMaxWeight(srcMem);
        if (maxWt < 0.0 || Double.isNaN(maxWt) || Double.isInfinite(maxWt)) {
            throw new SketchesArgumentException("Possible Corruption: maxWt must be nonnegative and finite: " + maxWt);
        }
        double rho = PreambleUtil.extractEbppsRho(srcMem);
        if (rho < 0.0 || rho > 1.0 || Double.isNaN(rho) || Double.isInfinite(rho)) {
            throw new SketchesArgumentException("Possible Corruption: rho must be in [0.0, 1.0]: " + rho);
        }
        double c = srcMem.getDouble(40L);
        if (c < 0.0 || c >= (double)(k + 1) || Double.isNaN(c) || Double.isInfinite(c)) {
            throw new SketchesArgumentException("Possible Corruption: c must be between 0 and k: " + c);
        }
        int numTotalItems = (int)Math.ceil(c);
        int numFullItems = (int)Math.floor(c);
        int offsetBytes = 48;
        T[] rawItems = serDe.deserializeFromMemory(srcMem.region(48L, srcMem.getCapacity() - 48L), 0L, numTotalItems);
        List<T> itemsList = Arrays.asList(rawItems);
        if (hasPartialItem) {
            if (numFullItems >= numTotalItems) {
                throw new SketchesArgumentException("Possible Corruption: Expected partial item but none found");
            }
            data = new ArrayList<T>(itemsList.subList(0, numFullItems));
            partialItem = itemsList.get(numFullItems);
        } else {
            data = new ArrayList<T>(itemsList);
            partialItem = null;
        }
        EbppsItemsSample<Object> sample = new EbppsItemsSample<Object>((ArrayList<Object>)data, partialItem, c);
        return new EbppsItemsSketch<Object>(sample, k, n, cumWt, maxWt, rho);
    }

    public void update(T item) {
        this.update(item, 1.0);
    }

    public void update(T item, double weight) {
        if (weight < 0.0 || Double.isNaN(weight) || Double.isInfinite(weight)) {
            throw new SketchesArgumentException("Item weights must be nonnegative and finite. Found: " + weight);
        }
        if (weight == 0.0) {
            return;
        }
        double newCumWt = this.cumulativeWt_ + weight;
        double newWtMax = Math.max(this.wtMax_, weight);
        double newRho = Math.min(1.0 / newWtMax, (double)this.k_ / newCumWt);
        if (this.cumulativeWt_ > 0.0) {
            this.sample_.downsample(newRho / this.rho_);
        }
        this.tmp_.replaceContent(item, newRho * weight);
        this.sample_.merge(this.tmp_);
        this.cumulativeWt_ = newCumWt;
        this.wtMax_ = newWtMax;
        this.rho_ = newRho;
        ++this.n_;
    }

    public void merge(EbppsItemsSketch<T> other) {
        if (other.getCumulativeWeight() == 0.0) {
            return;
        }
        if (other.getCumulativeWeight() > this.cumulativeWt_) {
            EbppsItemsSketch<T> copy = new EbppsItemsSketch<T>(other);
            super.internalMerge(this);
            this.k_ = copy.k_;
            this.n_ = copy.n_;
            this.cumulativeWt_ = copy.cumulativeWt_;
            this.wtMax_ = copy.wtMax_;
            this.rho_ = copy.rho_;
            this.sample_ = copy.sample_;
        } else {
            this.internalMerge(other);
        }
    }

    private void internalMerge(EbppsItemsSketch<T> other) {
        double newRho;
        double newCumWt;
        double finalCumWt = this.cumulativeWt_ + other.cumulativeWt_;
        double newWtMax = Math.max(this.wtMax_, other.wtMax_);
        this.k_ = Math.min(this.k_, other.k_);
        long newN = this.n_ + other.n_;
        double avgWt = other.cumulativeWt_ / other.getC();
        ArrayList<T> items = other.sample_.getFullItems();
        if (items != null) {
            for (T item : items) {
                newCumWt = this.cumulativeWt_ + avgWt;
                newRho = Math.min(1.0 / newWtMax, (double)this.k_ / newCumWt);
                if (this.cumulativeWt_ > 0.0) {
                    this.sample_.downsample(newRho / this.rho_);
                }
                this.tmp_.replaceContent(item, newRho * avgWt);
                this.sample_.merge(this.tmp_);
                this.cumulativeWt_ = newCumWt;
                this.rho_ = newRho;
            }
        }
        if (other.sample_.hasPartialItem()) {
            double otherCFrac = other.getC() % 1.0;
            newCumWt = this.cumulativeWt_ + otherCFrac * avgWt;
            newRho = Math.min(1.0 / newWtMax, (double)this.k_ / newCumWt);
            if (this.cumulativeWt_ > 0.0) {
                this.sample_.downsample(newRho / this.rho_);
            }
            this.tmp_.replaceContent(other.sample_.getPartialItem(), newRho * otherCFrac * avgWt);
            this.sample_.merge(this.tmp_);
            this.rho_ = newRho;
        }
        this.cumulativeWt_ = finalCumWt;
        this.n_ = newN;
    }

    public ArrayList<T> getResult() {
        return this.sample_.getSample();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Util.LS);
        String thisSimpleName = this.getClass().getSimpleName();
        sb.append("### ").append(thisSimpleName).append(" SUMMARY: ").append(Util.LS);
        sb.append("   k            : ").append(this.k_).append(Util.LS);
        sb.append("   n            : ").append(this.n_).append(Util.LS);
        sb.append("   Cum. weight  : ").append(this.cumulativeWt_).append(Util.LS);
        sb.append("   wtMax        : ").append(this.wtMax_).append(Util.LS);
        sb.append("   rho          : ").append(this.rho_).append(Util.LS);
        sb.append("   C            : ").append(this.sample_.getC()).append(Util.LS);
        sb.append("### END SKETCH SUMMARY").append(Util.LS);
        return sb.toString();
    }

    public int getK() {
        return this.k_;
    }

    public long getN() {
        return this.n_;
    }

    public double getCumulativeWeight() {
        return this.cumulativeWt_;
    }

    public double getC() {
        return this.sample_.getC();
    }

    public boolean isEmpty() {
        return this.n_ == 0L;
    }

    public void reset() {
        this.n_ = 0L;
        this.cumulativeWt_ = 0.0;
        this.wtMax_ = 0.0;
        this.rho_ = 1.0;
        this.sample_ = new EbppsItemsSample(this.k_);
    }

    public int getSerializedSizeBytes(ArrayOfItemsSerDe<? super T> serDe) {
        if (this.isEmpty()) {
            return Family.EBPPS.getMinPreLongs() << 3;
        }
        if (this.sample_.getC() < 1.0) {
            return this.getSerializedSizeBytes(serDe, this.sample_.getPartialItem().getClass());
        }
        return this.getSerializedSizeBytes(serDe, this.sample_.getSample().get(0).getClass());
    }

    public int getSerializedSizeBytes(ArrayOfItemsSerDe<? super T> serDe, Class<?> clazz) {
        if (this.n_ == 0L) {
            return Family.EBPPS.getMinPreLongs() << 3;
        }
        int preLongs = Family.EBPPS.getMaxPreLongs();
        byte[] itemBytes = serDe.serializeToByteArray(this.sample_.getAllSamples(clazz));
        return (preLongs << 3) + 8 + itemBytes.length;
    }

    public byte[] toByteArray(ArrayOfItemsSerDe<? super T> serDe) {
        if (this.n_ == 0L) {
            return this.toByteArray(serDe, null);
        }
        if (this.sample_.getC() < 1.0) {
            return this.toByteArray(serDe, this.sample_.getPartialItem().getClass());
        }
        return this.toByteArray(serDe, this.sample_.getSample().get(0).getClass());
    }

    public byte[] toByteArray(ArrayOfItemsSerDe<? super T> serDe, Class<?> clazz) {
        int outBytes;
        int preLongs;
        boolean empty = this.n_ == 0L;
        byte[] itemBytes = null;
        if (empty) {
            preLongs = 1;
            outBytes = 8;
        } else {
            preLongs = Family.EBPPS.getMaxPreLongs();
            itemBytes = serDe.serializeToByteArray(this.sample_.getAllSamples(clazz));
            outBytes = (preLongs << 3) + 8 + itemBytes.length;
        }
        byte[] outArr = new byte[outBytes];
        WritableMemory mem = WritableMemory.writableWrap(outArr);
        PreambleUtil.insertPreLongs(mem, preLongs);
        PreambleUtil.insertSerVer(mem, 1);
        PreambleUtil.insertFamilyID(mem, Family.EBPPS.getID());
        if (empty) {
            PreambleUtil.insertFlags(mem, 4);
        } else {
            PreambleUtil.insertFlags(mem, this.sample_.hasPartialItem() ? 8 : 0);
        }
        PreambleUtil.insertK(mem, this.k_);
        if (!empty) {
            PreambleUtil.insertN(mem, this.n_);
            PreambleUtil.insertEbppsCumulativeWeight(mem, this.cumulativeWt_);
            PreambleUtil.insertEbppsMaxWeight(mem, this.wtMax_);
            PreambleUtil.insertEbppsRho(mem, this.rho_);
            mem.putDouble(40L, this.sample_.getC());
            mem.putByteArray(48L, itemBytes, 0, itemBytes.length);
        }
        return outArr;
    }

    private static void checkK(int k) {
        if (k <= 0 || k > 0x7FFFFFFD) {
            throw new SketchesArgumentException("k must be strictly positive and less than 2147483645");
        }
    }
}

