/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesReadOnlyException;
import org.apache.datasketches.common.SuppressFBWarnings;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactOperations;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.MemoryHashIterator;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.UpdateReturnState;
import org.apache.datasketches.theta.UpdateSketch;

class DirectQuickSelectSketchR
extends UpdateSketch {
    static final double DQS_RESIZE_THRESHOLD = 0.9375;
    final long seed_;
    int hashTableThreshold_;
    WritableMemory wmem_;

    DirectQuickSelectSketchR(long seed, WritableMemory wmem) {
        this.seed_ = seed;
        this.wmem_ = wmem;
    }

    static DirectQuickSelectSketchR readOnlyWrap(Memory srcMem, long seed) {
        int preambleLongs = PreambleUtil.extractPreLongs(srcMem);
        int lgNomLongs = PreambleUtil.extractLgNomLongs(srcMem);
        int lgArrLongs = PreambleUtil.extractLgArrLongs(srcMem);
        UpdateSketch.checkUnionQuickSelectFamily(srcMem, preambleLongs, lgNomLongs);
        DirectQuickSelectSketchR.checkMemIntegrity(srcMem, seed, preambleLongs, lgNomLongs, lgArrLongs);
        DirectQuickSelectSketchR dqssr = new DirectQuickSelectSketchR(seed, (WritableMemory)srcMem);
        dqssr.hashTableThreshold_ = DirectQuickSelectSketchR.getOffHeapHashTableThreshold(lgNomLongs, lgArrLongs);
        return dqssr;
    }

    static DirectQuickSelectSketchR fastReadOnlyWrap(Memory srcMem, long seed) {
        int lgNomLongs = srcMem.getByte(3L) & 0xFF;
        int lgArrLongs = srcMem.getByte(4L) & 0xFF;
        DirectQuickSelectSketchR dqss = new DirectQuickSelectSketchR(seed, (WritableMemory)srcMem);
        dqss.hashTableThreshold_ = DirectQuickSelectSketchR.getOffHeapHashTableThreshold(lgNomLongs, lgArrLongs);
        return dqss;
    }

    @Override
    public int getCurrentBytes() {
        byte lgArrLongs = this.wmem_.getByte(4L);
        int preLongs = this.wmem_.getByte(0L) & 0x3F;
        int lengthBytes = preLongs + (1 << lgArrLongs) << 3;
        return lengthBytes;
    }

    @Override
    public double getEstimate() {
        int curCount = PreambleUtil.extractCurCount(this.wmem_);
        long thetaLong = PreambleUtil.extractThetaLong(this.wmem_);
        return Sketch.estimate(thetaLong, curCount);
    }

    @Override
    public Family getFamily() {
        int familyID = this.wmem_.getByte(2L) & 0xFF;
        return Family.idToFamily(familyID);
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        return this.wmem_.getInt(8L);
    }

    @Override
    public long getThetaLong() {
        return this.isEmpty() ? Long.MAX_VALUE : this.wmem_.getLong(16L);
    }

    @Override
    public boolean hasMemory() {
        return this.wmem_ != null;
    }

    @Override
    public boolean isDirect() {
        return this.hasMemory() ? this.wmem_.isDirect() : false;
    }

    @Override
    public boolean isEmpty() {
        return PreambleUtil.isEmptyFlag(this.wmem_);
    }

    @Override
    public boolean isSameResource(Memory that) {
        return this.hasMemory() ? this.wmem_.isSameResource(that) : false;
    }

    @Override
    public HashIterator iterator() {
        return new MemoryHashIterator(this.wmem_, 1 << this.getLgArrLongs(), this.getThetaLong());
    }

    @Override
    public byte[] toByteArray() {
        CompactOperations.checkIllegalCurCountAndEmpty(this.isEmpty(), PreambleUtil.extractCurCount(this.wmem_));
        int lengthBytes = this.getCurrentBytes();
        byte[] byteArray = new byte[lengthBytes];
        WritableMemory mem = WritableMemory.writableWrap(byteArray);
        this.wmem_.copyTo(0L, mem, 0L, lengthBytes);
        long thetaLong = CompactOperations.correctThetaOnCompact(this.isEmpty(), PreambleUtil.extractCurCount(this.wmem_), PreambleUtil.extractThetaLong(this.wmem_));
        PreambleUtil.insertThetaLong(this.wmem_, thetaLong);
        return byteArray;
    }

    @Override
    public final int getLgNomLongs() {
        return PreambleUtil.extractLgNomLongs(this.wmem_);
    }

    @Override
    float getP() {
        return this.wmem_.getFloat(12L);
    }

    @Override
    public ResizeFactor getResizeFactor() {
        return ResizeFactor.getRF(this.getLgRF());
    }

    @Override
    long getSeed() {
        return this.seed_;
    }

    @Override
    public UpdateSketch rebuild() {
        throw new SketchesReadOnlyException();
    }

    @Override
    public void reset() {
        throw new SketchesReadOnlyException();
    }

    @Override
    long[] getCache() {
        long lgArrLongs = this.wmem_.getByte(4L) & 0xFF;
        int preambleLongs = this.wmem_.getByte(0L) & 0x3F;
        long[] cacheArr = new long[1 << (int)lgArrLongs];
        WritableMemory mem = WritableMemory.writableWrap(cacheArr);
        this.wmem_.copyTo(preambleLongs << 3, mem, 0L, 8 << (int)lgArrLongs);
        return cacheArr;
    }

    @Override
    int getCompactPreambleLongs() {
        return CompactOperations.computeCompactPreLongs(this.isEmpty(), this.getRetainedEntries(true), this.getThetaLong());
    }

    @Override
    int getCurrentPreambleLongs() {
        return PreambleUtil.extractPreLongs(this.wmem_);
    }

    @Override
    WritableMemory getMemory() {
        return this.wmem_;
    }

    @Override
    short getSeedHash() {
        return (short)PreambleUtil.extractSeedHash(this.wmem_);
    }

    @Override
    boolean isDirty() {
        return false;
    }

    @Override
    boolean isOutOfSpace(int numEntries) {
        return numEntries > this.hashTableThreshold_;
    }

    @Override
    int getLgArrLongs() {
        return this.wmem_.getByte(4L) & 0xFF;
    }

    int getLgRF() {
        return this.wmem_.getByte(0L) >>> 6 & 3;
    }

    @Override
    UpdateReturnState hashUpdate(long hash) {
        throw new SketchesReadOnlyException();
    }

    @SuppressFBWarnings(value={"DB_DUPLICATE_BRANCHES"}, justification="False Positive, see the code comments")
    protected static final int getOffHeapHashTableThreshold(int lgNomLongs, int lgArrLongs) {
        double fraction = lgArrLongs <= lgNomLongs ? 0.9375 : 0.9375;
        return (int)(fraction * (double)(1 << lgArrLongs));
    }
}

