/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.BaseOverwriteFiles;
import org.apache.iceberg.BaseReplacePartitions;
import org.apache.iceberg.BaseReplaceSortOrder;
import org.apache.iceberg.BaseRewriteFiles;
import org.apache.iceberg.BaseRewriteManifests;
import org.apache.iceberg.BaseRowDelta;
import org.apache.iceberg.BaseUpdatePartitionSpec;
import org.apache.iceberg.CherryPickOperation;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.ExpireSnapshots;
import org.apache.iceberg.FastAppend;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.ManageSnapshots;
import org.apache.iceberg.MergeAppend;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionStatisticsFile;
import org.apache.iceberg.PendingUpdate;
import org.apache.iceberg.PropertiesUpdate;
import org.apache.iceberg.RemoveSnapshots;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.RewriteManifests;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaUpdate;
import org.apache.iceberg.SerializableTable;
import org.apache.iceberg.SetLocation;
import org.apache.iceberg.SetPartitionStatistics;
import org.apache.iceberg.SetSnapshotOperation;
import org.apache.iceberg.SetStatistics;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotManager;
import org.apache.iceberg.SnapshotProducer;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.SnapshotUpdate;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.StreamingDelete;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdateLocation;
import org.apache.iceberg.UpdatePartitionSpec;
import org.apache.iceberg.UpdatePartitionStatistics;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.UpdateSnapshotReferencesOperation;
import org.apache.iceberg.UpdateStatistics;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.exceptions.CleanableFailure;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.io.BulkDeletionFailureException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.io.SupportsBulkOperations;
import org.apache.iceberg.metrics.LoggingMetricsReporter;
import org.apache.iceberg.metrics.MetricsReporter;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseTransaction
implements Transaction {
    private static final Logger LOG = LoggerFactory.getLogger(BaseTransaction.class);
    private final String tableName;
    private final TableOperations ops;
    private final TransactionTable transactionTable;
    private final TableOperations transactionOps;
    private final List<PendingUpdate> updates;
    private final Set<String> deletedFiles = Sets.newHashSet();
    private final Consumer<String> enqueueDelete = this.deletedFiles::add;
    private final TransactionType type;
    private TableMetadata base;
    private TableMetadata current;
    private boolean hasLastOpCommitted;
    private final MetricsReporter reporter;

    BaseTransaction(String tableName, TableOperations ops, TransactionType type, TableMetadata start) {
        this(tableName, ops, type, start, LoggingMetricsReporter.instance());
    }

    BaseTransaction(String tableName, TableOperations ops, TransactionType type, TableMetadata start, MetricsReporter reporter) {
        this.tableName = tableName;
        this.ops = ops;
        this.transactionTable = new TransactionTable();
        this.current = start;
        this.transactionOps = new TransactionTableOperations();
        this.updates = Lists.newArrayList();
        this.base = ops.current();
        this.type = type;
        this.hasLastOpCommitted = true;
        this.reporter = reporter;
    }

    @Override
    public Table table() {
        return this.transactionTable;
    }

    public String tableName() {
        return this.tableName;
    }

    public TableMetadata startMetadata() {
        return this.base;
    }

    public TableMetadata currentMetadata() {
        return this.current;
    }

    public TableOperations underlyingOps() {
        return this.ops;
    }

    protected final <T extends PendingUpdate> T appendUpdate(T update) {
        this.checkLastOperationCommitted(update.getClass());
        if (update instanceof SnapshotUpdate) {
            ((SnapshotUpdate)update).deleteWith(this.enqueueDelete);
        }
        if (update instanceof SnapshotProducer) {
            ((SnapshotProducer)update).reportWith(this.reporter);
        }
        this.updates.add(update);
        return update;
    }

    private void checkLastOperationCommitted(Class<? extends PendingUpdate> clazz) {
        String operation = clazz.getInterfaces().length > 0 ? clazz.getInterfaces()[0].getSimpleName() : clazz.getSimpleName();
        Preconditions.checkState(this.hasLastOpCommitted, "Cannot create new %s: last operation has not committed", (Object)operation);
        if (SnapshotManager.class != clazz) {
            this.hasLastOpCommitted = false;
        }
    }

    @Override
    public UpdateSchema updateSchema() {
        return this.appendUpdate(new SchemaUpdate(this.transactionOps));
    }

    @Override
    public UpdatePartitionSpec updateSpec() {
        return this.appendUpdate(new BaseUpdatePartitionSpec(this.transactionOps));
    }

    @Override
    public UpdateProperties updateProperties() {
        return this.appendUpdate(new PropertiesUpdate(this.transactionOps));
    }

    @Override
    public ReplaceSortOrder replaceSortOrder() {
        return this.appendUpdate(new BaseReplaceSortOrder(this.transactionOps));
    }

    @Override
    public UpdateLocation updateLocation() {
        return this.appendUpdate(new SetLocation(this.transactionOps));
    }

    @Override
    public AppendFiles newAppend() {
        return this.appendUpdate(new MergeAppend(this.tableName, this.transactionOps));
    }

    @Override
    public AppendFiles newFastAppend() {
        return this.appendUpdate(new FastAppend(this.tableName, this.transactionOps));
    }

    @Override
    public RewriteFiles newRewrite() {
        return this.appendUpdate(new BaseRewriteFiles(this.tableName, this.transactionOps));
    }

    @Override
    public RewriteManifests rewriteManifests() {
        return this.appendUpdate(new BaseRewriteManifests(this.tableName, this.transactionOps));
    }

    @Override
    public OverwriteFiles newOverwrite() {
        return this.appendUpdate(new BaseOverwriteFiles(this.tableName, this.transactionOps));
    }

    @Override
    public RowDelta newRowDelta() {
        return this.appendUpdate(new BaseRowDelta(this.tableName, this.transactionOps));
    }

    @Override
    public ReplacePartitions newReplacePartitions() {
        return this.appendUpdate(new BaseReplacePartitions(this.tableName, this.transactionOps));
    }

    @Override
    public DeleteFiles newDelete() {
        return this.appendUpdate(new StreamingDelete(this.tableName, this.transactionOps));
    }

    @Override
    public UpdateStatistics updateStatistics() {
        return this.appendUpdate(new SetStatistics(this.transactionOps));
    }

    @Override
    public UpdatePartitionStatistics updatePartitionStatistics() {
        return this.appendUpdate(new SetPartitionStatistics(this.transactionOps));
    }

    @Override
    public ExpireSnapshots expireSnapshots() {
        return this.appendUpdate(new RemoveSnapshots(this.transactionOps));
    }

    @Override
    public ManageSnapshots manageSnapshots() {
        return this.appendUpdate(new SnapshotManager(this));
    }

    CherryPickOperation cherryPick() {
        return this.appendUpdate(new CherryPickOperation(this.tableName, this.transactionOps));
    }

    SetSnapshotOperation setBranchSnapshot() {
        return this.appendUpdate(new SetSnapshotOperation(this.transactionOps));
    }

    UpdateSnapshotReferencesOperation updateSnapshotReferencesOperation() {
        return this.appendUpdate(new UpdateSnapshotReferencesOperation(this.transactionOps));
    }

    @Override
    public void commitTransaction() {
        Preconditions.checkState(this.hasLastOpCommitted, "Cannot commit transaction: last operation has not committed");
        switch (this.type) {
            case CREATE_TABLE: {
                this.commitCreateTransaction();
                break;
            }
            case REPLACE_TABLE: {
                this.commitReplaceTransaction(false);
                break;
            }
            case CREATE_OR_REPLACE_TABLE: {
                this.commitReplaceTransaction(true);
                break;
            }
            case SIMPLE: {
                this.commitSimpleTransaction();
            }
        }
    }

    private void commitCreateTransaction() {
        try {
            this.ops.commit(null, this.current);
        }
        catch (CommitStateUnknownException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (!this.ops.requireStrictCleanup() || e instanceof CleanableFailure) {
                this.cleanAllUpdates();
            }
            throw e;
        }
        finally {
            this.deleteUncommittedFiles(this.deletedFiles);
        }
    }

    private void commitReplaceTransaction(boolean orCreate) {
        Map<String, String> props = this.base != null ? this.base.properties() : this.current.properties();
        try {
            Tasks.foreach(this.ops).retry(PropertyUtil.propertyAsInt(props, "commit.retry.num-retries", 4)).exponentialBackoff(PropertyUtil.propertyAsInt(props, "commit.retry.min-wait-ms", 100), PropertyUtil.propertyAsInt(props, "commit.retry.max-wait-ms", 60000), PropertyUtil.propertyAsInt(props, "commit.retry.total-timeout-ms", 1800000), 2.0).onlyRetryOn((Class<Exception>)CommitFailedException.class).run(underlyingOps -> {
                block3: {
                    try {
                        underlyingOps.refresh();
                    }
                    catch (NoSuchTableException e) {
                        if (orCreate) break block3;
                        throw e;
                    }
                }
                if (this.base != underlyingOps.current()) {
                    this.base = underlyingOps.current();
                }
                underlyingOps.commit(this.base, this.current);
            });
        }
        catch (CommitStateUnknownException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (!this.ops.requireStrictCleanup() || e instanceof CleanableFailure) {
                this.cleanAllUpdates();
            }
            throw e;
        }
        finally {
            this.deleteUncommittedFiles(this.deletedFiles);
        }
    }

    private void commitSimpleTransaction() {
        if (this.base == this.current) {
            return;
        }
        Set startingSnapshots = this.base.snapshots().stream().map(Snapshot::snapshotId).collect(Collectors.toSet());
        try {
            Tasks.foreach(this.ops).retry(this.base.propertyAsInt("commit.retry.num-retries", 4)).exponentialBackoff(this.base.propertyAsInt("commit.retry.min-wait-ms", 100), this.base.propertyAsInt("commit.retry.max-wait-ms", 60000), this.base.propertyAsInt("commit.retry.total-timeout-ms", 1800000), 2.0).onlyRetryOn((Class<Exception>)CommitFailedException.class).run(underlyingOps -> {
                this.applyUpdates((TableOperations)underlyingOps);
                underlyingOps.commit(this.base, this.current);
            });
        }
        catch (CommitStateUnknownException e) {
            throw e;
        }
        catch (PendingUpdateFailedException e) {
            this.cleanUpOnCommitFailure();
            throw e.wrapped();
        }
        catch (RuntimeException e) {
            if (!this.ops.requireStrictCleanup() || e instanceof CleanableFailure) {
                this.cleanUpOnCommitFailure();
            }
            throw e;
        }
        try {
            HashSet<Long> newSnapshots = Sets.newHashSet();
            for (Snapshot snapshot : this.current.snapshots()) {
                if (startingSnapshots.contains(snapshot.snapshotId())) continue;
                newSnapshots.add(snapshot.snapshotId());
            }
            Set<String> committedFiles = BaseTransaction.committedFiles(this.ops, newSnapshots);
            if (committedFiles != null) {
                Set<String> uncommittedFiles = this.deletedFiles.stream().filter(f -> !committedFiles.contains(f)).collect(Collectors.toSet());
                this.deleteUncommittedFiles(uncommittedFiles);
            } else {
                LOG.warn("Failed to load metadata for a committed snapshot, skipping clean-up");
            }
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to load committed metadata, skipping clean-up", (Throwable)e);
        }
    }

    private void cleanUpOnCommitFailure() {
        this.cleanAllUpdates();
        this.deleteUncommittedFiles(this.deletedFiles);
    }

    private void cleanAllUpdates() {
        Tasks.foreach(this.updates).suppressFailureWhenFinished().run(update -> {
            if (update instanceof SnapshotProducer) {
                ((SnapshotProducer)update).cleanAll();
            }
        });
    }

    private void deleteUncommittedFiles(Iterable<String> paths) {
        if (this.ops.io() instanceof SupportsBulkOperations) {
            try {
                ((SupportsBulkOperations)this.ops.io()).deleteFiles(paths);
            }
            catch (BulkDeletionFailureException e) {
                LOG.warn("Failed to delete {} uncommitted files using bulk deletes", (Object)e.numberFailedObjects(), (Object)e);
            }
            catch (RuntimeException e) {
                LOG.warn("Failed to delete uncommitted files using bulk deletes", (Throwable)e);
            }
        } else {
            Tasks.foreach(paths).executeWith(ThreadPools.getWorkerPool()).suppressFailureWhenFinished().onFailure((file, exc) -> LOG.warn("Failed to delete uncommitted file: {}", file, (Object)exc)).run(this.ops.io()::deleteFile);
        }
    }

    private void applyUpdates(TableOperations underlyingOps) {
        if (this.base != underlyingOps.refresh()) {
            this.base = underlyingOps.current();
            this.current = underlyingOps.current();
            for (PendingUpdate update : this.updates) {
                try {
                    update.commit();
                }
                catch (CommitFailedException e) {
                    throw new PendingUpdateFailedException(e);
                }
            }
        }
    }

    private static Set<String> committedFiles(TableOperations ops, Set<Long> snapshotIds) {
        if (snapshotIds.isEmpty()) {
            return ImmutableSet.of();
        }
        HashSet<String> committedFiles = Sets.newHashSet();
        for (long snapshotId : snapshotIds) {
            Snapshot snap = ops.current().snapshot(snapshotId);
            if (snap != null) {
                committedFiles.add(snap.manifestListLocation());
                snap.allManifests(ops.io()).forEach(manifest -> committedFiles.add(manifest.path()));
                continue;
            }
            return null;
        }
        return committedFiles;
    }

    @VisibleForTesting
    TableOperations ops() {
        return this.ops;
    }

    @VisibleForTesting
    Set<String> deletedFiles() {
        return this.deletedFiles;
    }

    static enum TransactionType {
        CREATE_TABLE,
        REPLACE_TABLE,
        CREATE_OR_REPLACE_TABLE,
        SIMPLE;

    }

    public class TransactionTable
    implements Table,
    HasTableOperations,
    Serializable {
        @Override
        public TableOperations operations() {
            return BaseTransaction.this.transactionOps;
        }

        @Override
        public String name() {
            return BaseTransaction.this.tableName;
        }

        @Override
        public void refresh() {
        }

        @Override
        public TableScan newScan() {
            throw new UnsupportedOperationException("Transaction tables do not support scans");
        }

        @Override
        public Schema schema() {
            return BaseTransaction.this.current.schema();
        }

        @Override
        public Map<Integer, Schema> schemas() {
            return BaseTransaction.this.current.schemasById();
        }

        @Override
        public PartitionSpec spec() {
            return BaseTransaction.this.current.spec();
        }

        @Override
        public Map<Integer, PartitionSpec> specs() {
            return BaseTransaction.this.current.specsById();
        }

        @Override
        public SortOrder sortOrder() {
            return BaseTransaction.this.current.sortOrder();
        }

        @Override
        public Map<Integer, SortOrder> sortOrders() {
            return BaseTransaction.this.current.sortOrdersById();
        }

        @Override
        public Map<String, String> properties() {
            return BaseTransaction.this.current.properties();
        }

        @Override
        public String location() {
            return BaseTransaction.this.current.location();
        }

        @Override
        public Snapshot currentSnapshot() {
            return BaseTransaction.this.current.currentSnapshot();
        }

        @Override
        public Snapshot snapshot(long snapshotId) {
            return BaseTransaction.this.current.snapshot(snapshotId);
        }

        @Override
        public Iterable<Snapshot> snapshots() {
            return BaseTransaction.this.current.snapshots();
        }

        @Override
        public List<HistoryEntry> history() {
            return BaseTransaction.this.current.snapshotLog();
        }

        @Override
        public UpdateSchema updateSchema() {
            return BaseTransaction.this.updateSchema();
        }

        @Override
        public UpdatePartitionSpec updateSpec() {
            return BaseTransaction.this.updateSpec();
        }

        @Override
        public UpdateProperties updateProperties() {
            return BaseTransaction.this.updateProperties();
        }

        @Override
        public ReplaceSortOrder replaceSortOrder() {
            return BaseTransaction.this.replaceSortOrder();
        }

        @Override
        public UpdateLocation updateLocation() {
            return BaseTransaction.this.updateLocation();
        }

        @Override
        public AppendFiles newAppend() {
            return BaseTransaction.this.newAppend();
        }

        @Override
        public AppendFiles newFastAppend() {
            return BaseTransaction.this.newFastAppend();
        }

        @Override
        public RewriteFiles newRewrite() {
            return BaseTransaction.this.newRewrite();
        }

        @Override
        public RewriteManifests rewriteManifests() {
            return BaseTransaction.this.rewriteManifests();
        }

        @Override
        public OverwriteFiles newOverwrite() {
            return BaseTransaction.this.newOverwrite();
        }

        @Override
        public RowDelta newRowDelta() {
            return BaseTransaction.this.newRowDelta();
        }

        @Override
        public ReplacePartitions newReplacePartitions() {
            return BaseTransaction.this.newReplacePartitions();
        }

        @Override
        public DeleteFiles newDelete() {
            return BaseTransaction.this.newDelete();
        }

        @Override
        public UpdateStatistics updateStatistics() {
            return BaseTransaction.this.updateStatistics();
        }

        @Override
        public UpdatePartitionStatistics updatePartitionStatistics() {
            return BaseTransaction.this.updatePartitionStatistics();
        }

        @Override
        public ExpireSnapshots expireSnapshots() {
            return BaseTransaction.this.expireSnapshots();
        }

        @Override
        public ManageSnapshots manageSnapshots() {
            throw new UnsupportedOperationException("Transaction tables do not support managing snapshots");
        }

        @Override
        public Transaction newTransaction() {
            throw new UnsupportedOperationException("Cannot create a transaction within a transaction");
        }

        @Override
        public FileIO io() {
            return BaseTransaction.this.transactionOps.io();
        }

        @Override
        public EncryptionManager encryption() {
            return BaseTransaction.this.transactionOps.encryption();
        }

        @Override
        public LocationProvider locationProvider() {
            return BaseTransaction.this.transactionOps.locationProvider();
        }

        @Override
        public List<StatisticsFile> statisticsFiles() {
            return BaseTransaction.this.current.statisticsFiles();
        }

        @Override
        public List<PartitionStatisticsFile> partitionStatisticsFiles() {
            return BaseTransaction.this.current.partitionStatisticsFiles();
        }

        @Override
        public Map<String, SnapshotRef> refs() {
            return BaseTransaction.this.current.refs();
        }

        @Override
        public UUID uuid() {
            return UUID.fromString(BaseTransaction.this.current.uuid());
        }

        public String toString() {
            return this.name();
        }

        Object writeReplace() {
            return SerializableTable.copyOf(this);
        }
    }

    public class TransactionTableOperations
    implements TableOperations {
        private TableOperations tempOps;

        public TransactionTableOperations() {
            this.tempOps = BaseTransaction.this.ops.temp(BaseTransaction.this.current);
        }

        @Override
        public TableMetadata current() {
            return BaseTransaction.this.current;
        }

        @Override
        public TableMetadata refresh() {
            return BaseTransaction.this.current;
        }

        @Override
        public void commit(TableMetadata underlyingBase, TableMetadata metadata) {
            if (underlyingBase != BaseTransaction.this.current) {
                throw new CommitFailedException("Table metadata refresh is required", new Object[0]);
            }
            BaseTransaction.this.current = metadata;
            this.tempOps = BaseTransaction.this.ops.temp(metadata);
            BaseTransaction.this.hasLastOpCommitted = true;
        }

        @Override
        public FileIO io() {
            return this.tempOps.io();
        }

        @Override
        public EncryptionManager encryption() {
            return this.tempOps.encryption();
        }

        @Override
        public String metadataFileLocation(String fileName) {
            return this.tempOps.metadataFileLocation(fileName);
        }

        @Override
        public LocationProvider locationProvider() {
            return this.tempOps.locationProvider();
        }

        @Override
        public long newSnapshotId() {
            return this.tempOps.newSnapshotId();
        }
    }

    private static class PendingUpdateFailedException
    extends RuntimeException {
        private final CommitFailedException wrapped;

        private PendingUpdateFailedException(CommitFailedException cause) {
            super(cause);
            this.wrapped = cause;
        }

        public CommitFailedException wrapped() {
            return this.wrapped;
        }
    }
}

