/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.concurrent.Immutable;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.MetricsModes;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.SerializableMap;
import org.apache.iceberg.util.SortOrderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class MetricsConfig
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsConfig.class);
    private static final Joiner DOT = Joiner.on('.');
    private static final MetricsModes.MetricsMode DEFAULT_MODE = MetricsModes.fromString("truncate(16)");
    private static final MetricsConfig DEFAULT = new MetricsConfig(ImmutableMap.of(), DEFAULT_MODE);
    private final Map<String, MetricsModes.MetricsMode> columnModes;
    private final MetricsModes.MetricsMode defaultMode;

    private MetricsConfig(Map<String, MetricsModes.MetricsMode> columnModes, MetricsModes.MetricsMode defaultMode) {
        this.columnModes = SerializableMap.copyOf(columnModes).immutableMap();
        this.defaultMode = defaultMode;
    }

    public static MetricsConfig getDefault() {
        return DEFAULT;
    }

    @Deprecated
    public static MetricsConfig fromProperties(Map<String, String> props) {
        return MetricsConfig.from(props, null, null);
    }

    public static MetricsConfig forTable(Table table) {
        return MetricsConfig.from(table.properties(), table.schema(), table.sortOrder());
    }

    public static MetricsConfig forPositionDelete(Table table) {
        ImmutableMap.Builder<String, MetricsModes.Full> columnModes = ImmutableMap.builder();
        columnModes.put(MetadataColumns.DELETE_FILE_PATH.name(), MetricsModes.Full.get());
        columnModes.put(MetadataColumns.DELETE_FILE_POS.name(), MetricsModes.Full.get());
        MetricsConfig tableConfig = MetricsConfig.forTable(table);
        MetricsModes.MetricsMode defaultMode = tableConfig.defaultMode;
        tableConfig.columnModes.forEach((columnAlias, mode) -> {
            String positionDeleteColumnAlias = DOT.join("row", columnAlias, new Object[0]);
            columnModes.put(positionDeleteColumnAlias, (MetricsModes.Full)mode);
        });
        return new MetricsConfig(columnModes.build(), defaultMode);
    }

    static Set<Integer> limitFieldIds(Schema schema, final int limit) {
        return TypeUtil.visit(schema, new TypeUtil.CustomOrderSchemaVisitor<Set<Integer>>(){
            private final Set<Integer> idSet = Sets.newHashSet();

            private boolean shouldContinue() {
                return this.idSet.size() < limit;
            }

            private boolean metricsEligible(Type type) {
                return type.isPrimitiveType() || type.isVariantType();
            }

            @Override
            public Set<Integer> schema(Schema schema, Supplier<Set<Integer>> structResult) {
                structResult.get();
                return this.idSet;
            }

            @Override
            public Set<Integer> struct(Types.StructType struct, Iterable<Set<Integer>> fieldResults) {
                Iterator<Types.NestedField> fields = struct.fields().iterator();
                while (this.shouldContinue() && fields.hasNext()) {
                    Types.NestedField field = fields.next();
                    if (!this.metricsEligible(field.type())) continue;
                    this.idSet.add(field.fieldId());
                }
                Iterator<Set<Integer>> iter = fieldResults.iterator();
                while (this.shouldContinue() && iter.hasNext()) {
                    iter.next();
                }
                return null;
            }

            @Override
            public Set<Integer> field(Types.NestedField field, Supplier<Set<Integer>> fieldResult) {
                fieldResult.get();
                return null;
            }

            @Override
            public Set<Integer> variant(Types.VariantType variant) {
                return null;
            }

            @Override
            public Set<Integer> list(Types.ListType list, Supplier<Set<Integer>> elementResult) {
                if (this.shouldContinue() && this.metricsEligible(list.elementType())) {
                    this.idSet.add(list.elementId());
                }
                elementResult.get();
                return null;
            }

            @Override
            public Set<Integer> map(Types.MapType map, Supplier<Set<Integer>> keyResult, Supplier<Set<Integer>> valueResult) {
                if (this.shouldContinue() && this.metricsEligible(map.keyType())) {
                    this.idSet.add(map.keyId());
                }
                if (this.shouldContinue() && this.metricsEligible(map.valueType())) {
                    this.idSet.add(map.valueId());
                }
                keyResult.get();
                valueResult.get();
                return null;
            }
        });
    }

    private static MetricsConfig from(Map<String, String> props, Schema schema, SortOrder order) {
        MetricsModes.MetricsMode defaultMode;
        int maxInferredDefaultColumns = MetricsConfig.maxInferredColumnDefaults(props);
        HashMap<String, MetricsModes.MetricsMode> columnModes = Maps.newHashMap();
        String configuredDefault = props.get("write.metadata.metrics.default");
        if (configuredDefault != null) {
            defaultMode = MetricsConfig.parseMode(configuredDefault, DEFAULT_MODE, "default");
        } else if (schema == null) {
            defaultMode = DEFAULT_MODE;
        } else if (TypeUtil.getProjectedIds(schema).size() <= maxInferredDefaultColumns) {
            defaultMode = DEFAULT_MODE;
        } else {
            for (Integer id : MetricsConfig.limitFieldIds(schema, maxInferredDefaultColumns)) {
                columnModes.put(schema.findColumnName(id), DEFAULT_MODE);
            }
            defaultMode = MetricsModes.None.get();
        }
        MetricsModes.MetricsMode sortedColDefaultMode = MetricsConfig.sortedColumnDefaultMode(defaultMode);
        Set<String> sortedCols = SortOrderUtil.orderPreservingSortedColumns(order);
        sortedCols.forEach(sc -> columnModes.put((String)sc, sortedColDefaultMode));
        for (String key : props.keySet()) {
            if (!key.startsWith("write.metadata.metrics.column.")) continue;
            String columnAlias = key.replaceFirst("write.metadata.metrics.column.", "");
            MetricsModes.MetricsMode mode = MetricsConfig.parseMode(props.get(key), defaultMode, "column " + columnAlias);
            columnModes.put(columnAlias, mode);
        }
        return new MetricsConfig(columnModes, defaultMode);
    }

    private static MetricsModes.MetricsMode sortedColumnDefaultMode(MetricsModes.MetricsMode defaultMode) {
        if (defaultMode == MetricsModes.None.get() || defaultMode == MetricsModes.Counts.get()) {
            return MetricsModes.Truncate.withLength(16);
        }
        return defaultMode;
    }

    private static int maxInferredColumnDefaults(Map<String, String> properties) {
        int maxInferredDefaultColumns = PropertyUtil.propertyAsInt(properties, "write.metadata.metrics.max-inferred-column-defaults", 100);
        if (maxInferredDefaultColumns < 0) {
            LOG.warn("Invalid value for {} (negative): {}, falling back to {}", new Object[]{"write.metadata.metrics.max-inferred-column-defaults", maxInferredDefaultColumns, 100});
            return 100;
        }
        return maxInferredDefaultColumns;
    }

    private static MetricsModes.MetricsMode parseMode(String modeString, MetricsModes.MetricsMode fallback, String context) {
        try {
            return MetricsModes.fromString(modeString);
        }
        catch (IllegalArgumentException err) {
            LOG.warn("Ignoring invalid metrics mode ({}): {}", new Object[]{context, modeString, err});
            return fallback;
        }
    }

    public void validateReferencedColumns(Schema schema) {
        for (String column : this.columnModes.keySet()) {
            ValidationException.check(schema.findField(column) != null, "Invalid metrics config, could not find column %s from table prop %s in schema %s", column, "write.metadata.metrics.column." + column, schema);
        }
    }

    public MetricsModes.MetricsMode columnMode(String columnAlias) {
        return this.columnModes.getOrDefault(columnAlias, this.defaultMode);
    }
}

