/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.mapping.MappingUtil;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Multimap;
import org.apache.iceberg.relocated.com.google.common.collect.Multimaps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.schema.UnionByNameVisitor;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchemaUpdate
implements UpdateSchema {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaUpdate.class);
    private static final int TABLE_ROOT_ID = -1;
    private final TableOperations ops;
    private final TableMetadata base;
    private final Schema schema;
    private final Map<Integer, Integer> idToParent;
    private final List<Integer> deletes = Lists.newArrayList();
    private final Map<Integer, Types.NestedField> updates = Maps.newHashMap();
    private final Multimap<Integer, Integer> parentToAddedIds = Multimaps.newListMultimap(Maps.newHashMap(), Lists::newArrayList);
    private final Map<String, Integer> addedNameToId = Maps.newHashMap();
    private final Multimap<Integer, Move> moves = Multimaps.newListMultimap(Maps.newHashMap(), Lists::newArrayList);
    private int lastColumnId;
    private boolean allowIncompatibleChanges = false;
    private Set<String> identifierFieldNames;
    private boolean caseSensitive = true;

    SchemaUpdate(TableOperations ops) {
        this(ops, ops.current());
    }

    SchemaUpdate(Schema schema, int lastColumnId) {
        this(null, null, schema, lastColumnId);
    }

    private SchemaUpdate(TableOperations ops, TableMetadata base) {
        this(ops, base, base.schema(), base.lastColumnId());
    }

    private SchemaUpdate(TableOperations ops, TableMetadata base, Schema schema, int lastColumnId) {
        this.ops = ops;
        this.base = base;
        this.schema = schema;
        this.lastColumnId = lastColumnId;
        this.idToParent = Maps.newHashMap(TypeUtil.indexParents(schema.asStruct()));
        this.identifierFieldNames = schema.identifierFieldNames();
    }

    @Override
    public SchemaUpdate allowIncompatibleChanges() {
        this.allowIncompatibleChanges = true;
        return this;
    }

    @Override
    public UpdateSchema addColumn(String parent, String name, Type type, String doc, Literal<?> defaultValue) {
        this.internalAddColumn(parent, name, true, type, doc, defaultValue);
        return this;
    }

    @Override
    public UpdateSchema addRequiredColumn(String parent, String name, Type type, String doc, Literal<?> defaultValue) {
        this.internalAddColumn(parent, name, false, type, doc, defaultValue);
        return this;
    }

    private void internalAddColumn(String parent, String name, boolean isOptional, Type type, String doc, Literal<?> defaultValue) {
        Object fullName;
        int parentId = -1;
        if (parent != null) {
            Types.NestedField parentField = this.findField(parent);
            Preconditions.checkArgument(parentField != null, "Cannot find parent struct: %s", (Object)parent);
            Type parentType = parentField.type();
            if (parentType.isNestedType()) {
                Type.NestedType nested = parentType.asNestedType();
                if (nested.isMapType()) {
                    parentField = nested.asMapType().fields().get(1);
                } else if (nested.isListType()) {
                    parentField = nested.asListType().fields().get(0);
                }
            }
            Preconditions.checkArgument(parentField.type().isNestedType() && parentField.type().asNestedType().isStructType(), "Cannot add to non-struct column: %s: %s", (Object)parent, (Object)parentField.type());
            parentId = parentField.fieldId();
            Types.NestedField currentField = this.findField(parent + "." + name);
            Preconditions.checkArgument(!this.deletes.contains(parentId), "Cannot add to a column that will be deleted: %s", (Object)parent);
            Preconditions.checkArgument(currentField == null || this.deletes.contains(currentField.fieldId()), "Cannot add column, name already exists: %s.%s", (Object)parent, (Object)name);
            fullName = this.schema.findColumnName(parentId) + "." + name;
        } else {
            Types.NestedField currentField = this.findField(name);
            Preconditions.checkArgument(currentField == null || this.deletes.contains(currentField.fieldId()), "Cannot add column, name already exists: %s", (Object)name);
            fullName = name;
        }
        Preconditions.checkArgument(defaultValue != null || isOptional || this.allowIncompatibleChanges, "Incompatible change: cannot add required column without a default value: %s", fullName);
        int newId = this.assignNewColumnId();
        this.addedNameToId.put((String)fullName, newId);
        if (parentId != -1) {
            this.idToParent.put(newId, parentId);
        }
        Types.NestedField newField = Types.NestedField.builder().withName(name).isOptional(isOptional).withId(newId).ofType(TypeUtil.assignFreshIds(type, this::assignNewColumnId)).withDoc(doc).withInitialDefault(defaultValue).withWriteDefault(defaultValue).build();
        this.updates.put(newId, newField);
        this.parentToAddedIds.put(parentId, newId);
    }

    @Override
    public UpdateSchema deleteColumn(String name) {
        Types.NestedField field = this.findField(name);
        Preconditions.checkArgument(field != null, "Cannot delete missing column: %s", (Object)name);
        Preconditions.checkArgument(!this.parentToAddedIds.containsKey(field.fieldId()), "Cannot delete a column that has additions: %s", (Object)name);
        Preconditions.checkArgument(!this.updates.containsKey(field.fieldId()), "Cannot delete a column that has updates: %s", (Object)name);
        this.deletes.add(field.fieldId());
        return this;
    }

    @Override
    public UpdateSchema renameColumn(String name, String newName) {
        Types.NestedField field = this.findField(name);
        Preconditions.checkArgument(field != null, "Cannot rename missing column: %s", (Object)name);
        Preconditions.checkArgument(newName != null, "Cannot rename a column to null");
        Preconditions.checkArgument(!this.deletes.contains(field.fieldId()), "Cannot rename a column that will be deleted: %s", (Object)field.name());
        int fieldId = field.fieldId();
        Types.NestedField update = this.updates.get(fieldId);
        Types.NestedField newField = Types.NestedField.from(update != null ? update : field).withName(newName).build();
        this.updates.put(fieldId, newField);
        if (this.identifierFieldNames.contains(name)) {
            this.identifierFieldNames.remove(name);
            this.identifierFieldNames.add(newName);
        }
        return this;
    }

    @Override
    public UpdateSchema requireColumn(String name) {
        this.internalUpdateColumnRequirement(name, false);
        return this;
    }

    @Override
    public UpdateSchema makeColumnOptional(String name) {
        this.internalUpdateColumnRequirement(name, true);
        return this;
    }

    private void internalUpdateColumnRequirement(String name, boolean isOptional) {
        Types.NestedField field = this.findForUpdate(name);
        Preconditions.checkArgument(field != null, "Cannot update missing column: %s", (Object)name);
        if (!isOptional && field.isRequired() || isOptional && field.isOptional()) {
            return;
        }
        boolean isDefaultedAdd = this.isAdded(name) && field.initialDefault() != null;
        Preconditions.checkArgument(isOptional || isDefaultedAdd || this.allowIncompatibleChanges, "Cannot change column nullability: %s: optional -> required", (Object)name);
        Preconditions.checkArgument(!this.deletes.contains(field.fieldId()), "Cannot update a column that will be deleted: %s", (Object)field.name());
        int fieldId = field.fieldId();
        Types.NestedField.Builder builder = Types.NestedField.from(field);
        if (isOptional) {
            builder.asOptional();
        } else {
            builder.asRequired();
        }
        this.updates.put(fieldId, builder.build());
    }

    @Override
    public UpdateSchema updateColumn(String name, Type.PrimitiveType newType) {
        Types.NestedField field = this.findForUpdate(name);
        Preconditions.checkArgument(field != null, "Cannot update missing column: %s", (Object)name);
        Preconditions.checkArgument(!this.deletes.contains(field.fieldId()), "Cannot update a column that will be deleted: %s", (Object)field.name());
        if (field.type().equals(newType)) {
            return this;
        }
        Preconditions.checkArgument(TypeUtil.isPromotionAllowed(field.type(), newType), "Cannot change column type: %s: %s -> %s", (Object)name, (Object)field.type(), (Object)newType);
        int fieldId = field.fieldId();
        Types.NestedField newField = Types.NestedField.from(field).ofType(newType).build();
        this.updates.put(fieldId, newField);
        return this;
    }

    @Override
    public UpdateSchema updateColumnDoc(String name, String doc) {
        Types.NestedField field = this.findForUpdate(name);
        Preconditions.checkArgument(field != null, "Cannot update missing column: %s", (Object)name);
        Preconditions.checkArgument(!this.deletes.contains(field.fieldId()), "Cannot update a column that will be deleted: %s", (Object)field.name());
        if (Objects.equals(field.doc(), doc)) {
            return this;
        }
        int fieldId = field.fieldId();
        Types.NestedField newField = Types.NestedField.from(field).withDoc(doc).build();
        this.updates.put(fieldId, newField);
        return this;
    }

    @Override
    public UpdateSchema updateColumnDefault(String name, Literal<?> newDefault) {
        Literal converted;
        Types.NestedField field = this.findForUpdate(name);
        Preconditions.checkArgument(field != null, "Cannot update missing column: %s", (Object)name);
        Preconditions.checkArgument(!this.deletes.contains(field.fieldId()), "Cannot update a column that will be deleted: %s", (Object)field.name());
        Literal literal = converted = newDefault != null ? newDefault.to(field.type()) : null;
        if (converted != null && Objects.equals(field.writeDefault(), converted.value())) {
            return this;
        }
        int fieldId = field.fieldId();
        Types.NestedField newField = Types.NestedField.from(field).withWriteDefault(newDefault).build();
        this.updates.put(fieldId, newField);
        return this;
    }

    @Override
    public UpdateSchema moveFirst(String name) {
        Integer fieldId = this.findForMove(name);
        Preconditions.checkArgument(fieldId != null, "Cannot move missing column: %s", (Object)name);
        this.internalMove(name, Move.first(fieldId));
        return this;
    }

    @Override
    public UpdateSchema moveBefore(String name, String beforeName) {
        Integer fieldId = this.findForMove(name);
        Preconditions.checkArgument(fieldId != null, "Cannot move missing column: %s", (Object)name);
        Integer beforeId = this.findForMove(beforeName);
        Preconditions.checkArgument(beforeId != null, "Cannot move %s before missing column: %s", (Object)name, (Object)beforeName);
        Preconditions.checkArgument(!fieldId.equals(beforeId), "Cannot move %s before itself", (Object)name);
        this.internalMove(name, Move.before(fieldId, beforeId));
        return this;
    }

    @Override
    public UpdateSchema moveAfter(String name, String afterName) {
        Integer fieldId = this.findForMove(name);
        Preconditions.checkArgument(fieldId != null, "Cannot move missing column: %s", (Object)name);
        Integer afterId = this.findForMove(afterName);
        Preconditions.checkArgument(afterId != null, "Cannot move %s after missing column: %s", (Object)name, (Object)afterName);
        Preconditions.checkArgument(!fieldId.equals(afterId), "Cannot move %s after itself", (Object)name);
        this.internalMove(name, Move.after(fieldId, afterId));
        return this;
    }

    @Override
    public UpdateSchema unionByNameWith(Schema newSchema) {
        UnionByNameVisitor.visit(this, this.schema, newSchema, this.caseSensitive);
        return this;
    }

    @Override
    public UpdateSchema setIdentifierFields(Collection<String> names) {
        this.identifierFieldNames = Sets.newHashSet(names);
        return this;
    }

    @Override
    public UpdateSchema caseSensitive(boolean caseSensitivity) {
        this.caseSensitive = caseSensitivity;
        return this;
    }

    private boolean isAdded(String name) {
        return this.addedNameToId.containsKey(name);
    }

    private Types.NestedField findForUpdate(String name) {
        Types.NestedField existing = this.findField(name);
        if (existing != null) {
            Types.NestedField pendingUpdate = this.updates.get(existing.fieldId());
            if (pendingUpdate != null) {
                return pendingUpdate;
            }
            return existing;
        }
        Integer addedId = this.addedNameToId.get(name);
        if (addedId != null) {
            return this.updates.get(addedId);
        }
        return null;
    }

    private Integer findForMove(String name) {
        Integer addedId = this.addedNameToId.get(name);
        if (addedId != null) {
            return addedId;
        }
        Types.NestedField field = this.findField(name);
        if (field != null) {
            return field.fieldId();
        }
        return null;
    }

    private void internalMove(String name, Move move) {
        Integer parentId = this.idToParent.get(move.fieldId());
        if (parentId != null) {
            Types.NestedField parent = this.schema.findField(parentId);
            Preconditions.checkArgument(parent.type().isStructType(), "Cannot move fields in non-struct type: %s", (Object)parent.type());
            if (move.type() == Move.MoveType.AFTER || move.type() == Move.MoveType.BEFORE) {
                Preconditions.checkArgument(parentId.equals(this.idToParent.get(move.referenceFieldId())), "Cannot move field %s to a different struct", (Object)name);
            }
            this.moves.put(parentId, move);
        } else {
            if (move.type() == Move.MoveType.AFTER || move.type() == Move.MoveType.BEFORE) {
                Preconditions.checkArgument(this.idToParent.get(move.referenceFieldId()) == null, "Cannot move field %s to a different struct", (Object)name);
            }
            this.moves.put(-1, move);
        }
    }

    @Override
    public Schema apply() {
        return SchemaUpdate.applyChanges(this.schema, this.deletes, this.updates, this.parentToAddedIds, this.moves, this.identifierFieldNames, this.caseSensitive);
    }

    @Override
    public void commit() {
        TableMetadata update = this.applyChangesToMetadata(this.base.updateSchema(this.apply()));
        this.ops.commit(this.base, update);
    }

    private int assignNewColumnId() {
        int next;
        this.lastColumnId = next = this.lastColumnId + 1;
        return next;
    }

    private TableMetadata applyChangesToMetadata(TableMetadata metadata) {
        String mappingJson = metadata.property("schema.name-mapping.default", null);
        TableMetadata newMetadata = metadata;
        if (mappingJson != null) {
            try {
                NameMapping mapping = NameMappingParser.fromJson(mappingJson);
                NameMapping updated = MappingUtil.update(mapping, this.updates, this.parentToAddedIds);
                HashMap<String, String> updatedProperties = Maps.newHashMap();
                updatedProperties.putAll(metadata.properties());
                updatedProperties.put("schema.name-mapping.default", NameMappingParser.toJson(updated));
                newMetadata = metadata.replaceProperties(updatedProperties);
            }
            catch (RuntimeException e) {
                LOG.warn("Failed to update external schema mapping: {}", (Object)mappingJson, (Object)e);
            }
        }
        if (this.base != null && this.base.properties() != null) {
            Schema newSchema = newMetadata.schema();
            List<String> deletedColumns = this.deletes.stream().map(this.schema::findColumnName).collect(Collectors.toList());
            Map<String, String> renamedColumns = this.updates.keySet().stream().filter(id -> !this.addedNameToId.containsValue(id)).filter(id -> !this.schema.findColumnName((int)id).equals(newSchema.findColumnName((int)id))).collect(Collectors.toMap(this.schema::findColumnName, newSchema::findColumnName));
            if (!deletedColumns.isEmpty() || !renamedColumns.isEmpty()) {
                ImmutableSet<String> columnProperties = ImmutableSet.of("write.metadata.metrics.column.", "write.parquet.bloom-filter-enabled.column.", "write.parquet.stats-enabled.column.");
                Map<String, String> updatedProperties = PropertyUtil.applySchemaChanges(newMetadata.properties(), deletedColumns, renamedColumns, columnProperties);
                newMetadata = newMetadata.replaceProperties(updatedProperties);
            }
        }
        return newMetadata;
    }

    private static Schema applyChanges(Schema schema, List<Integer> deletes, Map<Integer, Types.NestedField> updates, Multimap<Integer, Integer> parentToAddedIds, Multimap<Integer, Move> moves, Set<String> identifierFieldNames, boolean caseSensitive) {
        Map<Integer, Integer> idToParent = TypeUtil.indexParents(schema.asStruct());
        for (String name : identifierFieldNames) {
            Types.NestedField field = caseSensitive ? schema.findField(name) : schema.caseInsensitiveFindField(name);
            if (field == null) continue;
            Preconditions.checkArgument(!deletes.contains(field.fieldId()), "Cannot delete identifier field %s. To force deletion, also call setIdentifierFields to update identifier fields.", (Object)field);
            Object parentId = idToParent.get(field.fieldId());
            while (parentId != null) {
                Preconditions.checkArgument(!deletes.contains(parentId), "Cannot delete field %s as it will delete nested identifier field %s", (Object)schema.findField((Integer)parentId), (Object)field);
                parentId = idToParent.get(parentId);
            }
        }
        Types.StructType struct = TypeUtil.visit(schema, new ApplyChanges(deletes, updates, parentToAddedIds, moves)).asNestedType().asStructType();
        Map<String, Integer> nameToId = caseSensitive ? TypeUtil.indexByName(struct) : TypeUtil.indexByLowerCaseName(struct);
        HashSet<Integer> freshIdentifierFieldIds = Sets.newHashSet();
        for (String name : identifierFieldNames) {
            Preconditions.checkArgument(nameToId.containsKey(name), "Cannot add field %s as an identifier field: not found in current schema or added columns", (Object)name);
            freshIdentifierFieldIds.add(nameToId.get(name));
        }
        Map<Integer, Types.NestedField> idToField = TypeUtil.indexById(struct);
        freshIdentifierFieldIds.forEach(id -> Schema.validateIdentifierField(id, idToField, idToParent));
        return new Schema(struct.fields(), freshIdentifierFieldIds);
    }

    private static List<Types.NestedField> addAndMoveFields(List<Types.NestedField> fields, Collection<Types.NestedField> adds, Collection<Move> moves) {
        if (adds != null && !adds.isEmpty()) {
            if (moves != null && !moves.isEmpty()) {
                return SchemaUpdate.moveFields(SchemaUpdate.addFields(fields, adds), moves);
            }
            return SchemaUpdate.addFields(fields, adds);
        }
        if (moves != null && !moves.isEmpty()) {
            return SchemaUpdate.moveFields(fields, moves);
        }
        return null;
    }

    private static List<Types.NestedField> addFields(List<Types.NestedField> fields, Collection<Types.NestedField> adds) {
        ArrayList<Types.NestedField> newFields = Lists.newArrayList(fields);
        newFields.addAll(adds);
        return newFields;
    }

    private static List<Types.NestedField> moveFields(List<Types.NestedField> fields, Collection<Move> moves) {
        LinkedList<Types.NestedField> reordered = Lists.newLinkedList(fields);
        block5: for (Move move : moves) {
            Types.NestedField toMove = Iterables.find(reordered, field -> field.fieldId() == move.fieldId());
            reordered.remove(toMove);
            switch (move.type()) {
                case FIRST: {
                    reordered.addFirst(toMove);
                    continue block5;
                }
                case BEFORE: {
                    Types.NestedField before = Iterables.find(reordered, field -> field.fieldId() == move.referenceFieldId());
                    int beforeIndex = reordered.indexOf(before);
                    reordered.add(beforeIndex, toMove);
                    continue block5;
                }
                case AFTER: {
                    Types.NestedField after = Iterables.find(reordered, field -> field.fieldId() == move.referenceFieldId());
                    int afterIndex = reordered.indexOf(after);
                    reordered.add(afterIndex + 1, toMove);
                    continue block5;
                }
            }
            throw new UnsupportedOperationException("Unknown move type: " + String.valueOf((Object)move.type()));
        }
        return reordered;
    }

    private Types.NestedField findField(String fieldName) {
        return this.caseSensitive ? this.schema.findField(fieldName) : this.schema.caseInsensitiveFindField(fieldName);
    }

    private static class Move {
        private final int fieldId;
        private final int referenceFieldId;
        private final MoveType type;

        public String toString() {
            Object suffix = "";
            if (this.type != MoveType.FIRST) {
                suffix = " field " + this.referenceFieldId;
            }
            return "Move column " + this.fieldId + " " + this.type.toString() + (String)suffix;
        }

        static Move first(int fieldId) {
            return new Move(fieldId, -1, MoveType.FIRST);
        }

        static Move before(int fieldId, int referenceFieldId) {
            return new Move(fieldId, referenceFieldId, MoveType.BEFORE);
        }

        static Move after(int fieldId, int referenceFieldId) {
            return new Move(fieldId, referenceFieldId, MoveType.AFTER);
        }

        private Move(int fieldId, int referenceFieldId, MoveType type) {
            this.fieldId = fieldId;
            this.referenceFieldId = referenceFieldId;
            this.type = type;
        }

        public int fieldId() {
            return this.fieldId;
        }

        public int referenceFieldId() {
            return this.referenceFieldId;
        }

        public MoveType type() {
            return this.type;
        }

        private static enum MoveType {
            FIRST,
            BEFORE,
            AFTER;

        }
    }

    private static class ApplyChanges
    extends TypeUtil.SchemaVisitor<Type> {
        private final List<Integer> deletes;
        private final Map<Integer, Types.NestedField> updates;
        private final Multimap<Integer, Integer> parentToAddedIds;
        private final Multimap<Integer, Move> moves;

        private ApplyChanges(List<Integer> deletes, Map<Integer, Types.NestedField> updates, Multimap<Integer, Integer> parentToAddedIds, Multimap<Integer, Move> moves) {
            this.deletes = deletes;
            this.updates = updates;
            this.parentToAddedIds = parentToAddedIds;
            this.moves = moves;
        }

        @Override
        public Type schema(Schema schema, Type structResult) {
            List<Types.NestedField> addedFields = this.parentToAddedIds.get(-1).stream().map(this.updates::get).collect(Collectors.toList());
            List<Types.NestedField> fields = SchemaUpdate.addAndMoveFields(structResult.asStructType().fields(), addedFields, this.moves.get(-1));
            if (fields != null) {
                return Types.StructType.of(fields);
            }
            return structResult;
        }

        @Override
        public Type struct(Types.StructType struct, List<Type> fieldResults) {
            boolean hasChange = false;
            ArrayList<Types.NestedField> newFields = Lists.newArrayListWithExpectedSize(fieldResults.size());
            for (int i = 0; i < fieldResults.size(); ++i) {
                Types.NestedField field;
                Type resultType = fieldResults.get(i);
                if (resultType == null) {
                    hasChange = true;
                    continue;
                }
                Types.NestedField update = this.updates.get((field = struct.fields().get(i)).fieldId());
                Types.NestedField updated = Types.NestedField.from(update != null ? update : field).ofType(resultType).build();
                if (field.equals(updated)) {
                    newFields.add(field);
                    continue;
                }
                hasChange = true;
                newFields.add(updated);
            }
            if (hasChange) {
                return Types.StructType.of(newFields);
            }
            return struct;
        }

        @Override
        public Type field(Types.NestedField field, Type fieldResult) {
            List<Types.NestedField> fields;
            int fieldId = field.fieldId();
            if (this.deletes.contains(fieldId)) {
                return null;
            }
            Types.NestedField update = this.updates.get(field.fieldId());
            if (update != null && update.type() != field.type()) {
                return update.type();
            }
            Collection newFields = this.parentToAddedIds.get(fieldId).stream().map(this.updates::get).collect(Collectors.toList());
            Collection<Move> columnsToMove = this.moves.get(fieldId);
            if (!(newFields.isEmpty() && columnsToMove.isEmpty() || (fields = SchemaUpdate.addAndMoveFields(fieldResult.asStructType().fields(), newFields, columnsToMove)) == null)) {
                return Types.StructType.of(fields);
            }
            return fieldResult;
        }

        @Override
        public Type list(Types.ListType list, Type elementResult) {
            boolean isElementOptional;
            Types.NestedField elementField = list.fields().get(0);
            Type elementType = this.field(elementField, elementResult);
            if (elementType == null) {
                throw new IllegalArgumentException("Cannot delete element type from list: " + String.valueOf(list));
            }
            Types.NestedField elementUpdate = this.updates.get(elementField.fieldId());
            boolean bl = isElementOptional = elementUpdate != null ? elementUpdate.isOptional() : list.isElementOptional();
            if (isElementOptional == elementField.isOptional() && list.elementType() == elementType) {
                return list;
            }
            if (isElementOptional) {
                return Types.ListType.ofOptional(list.elementId(), elementType);
            }
            return Types.ListType.ofRequired(list.elementId(), elementType);
        }

        @Override
        public Type map(Types.MapType map, Type kResult, Type valueResult) {
            boolean isValueOptional;
            int keyId = map.fields().get(0).fieldId();
            if (this.deletes.contains(keyId)) {
                throw new IllegalArgumentException("Cannot delete map keys: " + String.valueOf(map));
            }
            if (this.updates.containsKey(keyId)) {
                throw new IllegalArgumentException("Cannot update map keys: " + String.valueOf(map));
            }
            if (this.parentToAddedIds.containsKey(keyId)) {
                throw new IllegalArgumentException("Cannot add fields to map keys: " + String.valueOf(map));
            }
            if (!map.keyType().equals(kResult)) {
                throw new IllegalArgumentException("Cannot alter map keys: " + String.valueOf(map));
            }
            Types.NestedField valueField = map.fields().get(1);
            Type valueType = this.field(valueField, valueResult);
            if (valueType == null) {
                throw new IllegalArgumentException("Cannot delete value type from map: " + String.valueOf(map));
            }
            Types.NestedField valueUpdate = this.updates.get(valueField.fieldId());
            boolean bl = isValueOptional = valueUpdate != null ? valueUpdate.isOptional() : map.isValueOptional();
            if (isValueOptional == map.isValueOptional() && map.valueType() == valueType) {
                return map;
            }
            if (isValueOptional) {
                return Types.MapType.ofOptional(map.keyId(), map.valueId(), map.keyType(), valueType);
            }
            return Types.MapType.ofRequired(map.keyId(), map.valueId(), map.keyType(), valueType);
        }

        @Override
        public Type variant(Types.VariantType variant) {
            return variant;
        }

        @Override
        public Type primitive(Type.PrimitiveType primitive) {
            return primitive;
        }
    }
}

