/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.RewriteJobOrder;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.actions.FileRewritePlan;
import org.apache.iceberg.actions.ImmutableRewriteDataFiles;
import org.apache.iceberg.actions.RewriteDataFiles;
import org.apache.iceberg.actions.RewriteFileGroup;
import org.apache.iceberg.actions.SizeBasedFileRewritePlanner;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ContentFileUtil;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.StructLikeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinPackRewriteFilePlanner
extends SizeBasedFileRewritePlanner<RewriteDataFiles.FileGroupInfo, FileScanTask, DataFile, RewriteFileGroup> {
    public static final String DELETE_FILE_THRESHOLD = "delete-file-threshold";
    public static final int DELETE_FILE_THRESHOLD_DEFAULT = Integer.MAX_VALUE;
    public static final String DELETE_RATIO_THRESHOLD = "delete-ratio-threshold";
    public static final double DELETE_RATIO_THRESHOLD_DEFAULT = 0.3;
    public static final String MAX_FILES_TO_REWRITE = "max-files-to-rewrite";
    private static final Logger LOG = LoggerFactory.getLogger(BinPackRewriteFilePlanner.class);
    private final Expression filter;
    private final Long snapshotId;
    private final boolean caseSensitive;
    private int deleteFileThreshold;
    private double deleteRatioThreshold;
    private RewriteJobOrder rewriteJobOrder;
    private Integer maxFilesToRewrite;

    public BinPackRewriteFilePlanner(Table table) {
        this(table, Expressions.alwaysTrue());
    }

    public BinPackRewriteFilePlanner(Table table, Expression filter) {
        this(table, filter, table.currentSnapshot() != null ? Long.valueOf(table.currentSnapshot().snapshotId()) : null, false);
    }

    public BinPackRewriteFilePlanner(Table table, Expression filter, Long snapshotId, boolean caseSensitive) {
        super(table);
        this.filter = filter;
        this.snapshotId = snapshotId;
        this.caseSensitive = caseSensitive;
    }

    @Override
    public Set<String> validOptions() {
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(super.validOptions())).add(DELETE_FILE_THRESHOLD)).add(DELETE_RATIO_THRESHOLD)).add("rewrite-job-order")).add(MAX_FILES_TO_REWRITE)).build();
    }

    @Override
    public void init(Map<String, String> options) {
        super.init(options);
        this.deleteFileThreshold = this.deleteFileThreshold(options);
        this.deleteRatioThreshold = this.deleteRatioThreshold(options);
        this.rewriteJobOrder = RewriteJobOrder.fromName(PropertyUtil.propertyAsString(options, "rewrite-job-order", RewriteDataFiles.REWRITE_JOB_ORDER_DEFAULT));
        this.maxFilesToRewrite = this.maxFilesToRewrite(options);
    }

    private int deleteFileThreshold(Map<String, String> options) {
        int value = PropertyUtil.propertyAsInt(options, DELETE_FILE_THRESHOLD, Integer.MAX_VALUE);
        Preconditions.checkArgument(value >= 0, "'%s' is set to %s but must be >= 0", (Object)DELETE_FILE_THRESHOLD, value);
        return value;
    }

    private double deleteRatioThreshold(Map<String, String> options) {
        double value = PropertyUtil.propertyAsDouble(options, DELETE_RATIO_THRESHOLD, 0.3);
        Preconditions.checkArgument(value > 0.0, "'%s' is set to %s but must be > 0", (Object)DELETE_RATIO_THRESHOLD, (Object)value);
        Preconditions.checkArgument(value <= 1.0, "'%s' is set to %s but must be <= 1", (Object)DELETE_RATIO_THRESHOLD, (Object)value);
        return value;
    }

    private Integer maxFilesToRewrite(Map<String, String> options) {
        Integer value = PropertyUtil.propertyAsNullableInt(options, MAX_FILES_TO_REWRITE);
        Preconditions.checkArgument(value == null || value > 0, "Cannot set %s to %s, the value must be positive integer.", (Object)MAX_FILES_TO_REWRITE, (Object)value);
        return value;
    }

    @Override
    protected Iterable<FileScanTask> filterFiles(Iterable<FileScanTask> tasks) {
        return Iterables.filter(tasks, task -> this.outsideDesiredFileSizeRange(task) || this.tooManyDeletes((FileScanTask)task) || this.tooHighDeleteRatio((FileScanTask)task));
    }

    @Override
    protected Iterable<List<FileScanTask>> filterFileGroups(List<List<FileScanTask>> groups) {
        return Iterables.filter(groups, group -> this.enoughInputFiles(group) || this.enoughContent(group) || this.tooMuchContent(group) || group.stream().anyMatch(this::tooManyDeletes) || group.stream().anyMatch(this::tooHighDeleteRatio));
    }

    @Override
    protected long defaultTargetFileSize() {
        return PropertyUtil.propertyAsLong(this.table().properties(), "write.target-file-size-bytes", 0x20000000L);
    }

    @Override
    public FileRewritePlan<RewriteDataFiles.FileGroupInfo, FileScanTask, DataFile, RewriteFileGroup> plan() {
        StructLikeMap<List<List<FileScanTask>>> plan = this.planFileGroups();
        SizeBasedFileRewritePlanner.RewriteExecutionContext ctx = new SizeBasedFileRewritePlanner.RewriteExecutionContext();
        ArrayList selectedFileGroups = Lists.newArrayList();
        AtomicInteger fileCountRunner = new AtomicInteger();
        plan.entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty()).forEach(entry -> {
            StructLike partition = (StructLike)entry.getKey();
            ((List)entry.getValue()).forEach(fileScanTasks -> {
                long inputSize = this.inputSize(fileScanTasks);
                if (this.maxFilesToRewrite == null) {
                    selectedFileGroups.add(this.newRewriteGroup(ctx, partition, (List<FileScanTask>)fileScanTasks, this.inputSplitSize(inputSize), this.expectedOutputFiles(inputSize)));
                } else if (fileCountRunner.get() < this.maxFilesToRewrite) {
                    int remainingSize = this.maxFilesToRewrite - fileCountRunner.get();
                    int scanTasksToRewrite = Math.min(fileScanTasks.size(), remainingSize);
                    selectedFileGroups.add(this.newRewriteGroup(ctx, partition, fileScanTasks.subList(0, scanTasksToRewrite), this.inputSplitSize(inputSize), this.expectedOutputFiles(inputSize)));
                    fileCountRunner.getAndAdd(scanTasksToRewrite);
                }
            });
        });
        StructLikeMap<Integer> groupsInPartition = plan.transformValues(List::size);
        int totalGroupCount = groupsInPartition.values().stream().reduce(Integer::sum).orElse(0);
        return new FileRewritePlan<RewriteDataFiles.FileGroupInfo, FileScanTask, DataFile, RewriteFileGroup>(CloseableIterable.of(selectedFileGroups.stream().sorted(RewriteFileGroup.comparator(this.rewriteJobOrder)).collect(Collectors.toList())), totalGroupCount, groupsInPartition);
    }

    private boolean tooManyDeletes(FileScanTask task) {
        return task.deletes() != null && task.deletes().size() >= this.deleteFileThreshold;
    }

    private boolean tooHighDeleteRatio(FileScanTask task) {
        if (task.deletes() == null || task.deletes().isEmpty()) {
            return false;
        }
        long knownDeletedRecordCount = task.deletes().stream().filter(ContentFileUtil::isFileScoped).mapToLong(ContentFile::recordCount).sum();
        double deletedRecords = Math.min(knownDeletedRecordCount, ((DataFile)task.file()).recordCount());
        double deleteRatio = deletedRecords / (double)((DataFile)task.file()).recordCount();
        return deleteRatio >= this.deleteRatioThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StructLikeMap<List<List<FileScanTask>>> planFileGroups() {
        TableScan scan = (TableScan)((TableScan)((TableScan)this.table().newScan().filter(this.filter)).caseSensitive(this.caseSensitive)).ignoreResiduals();
        if (this.snapshotId != null) {
            scan = scan.useSnapshot(this.snapshotId);
        }
        CloseableIterable<FileScanTask> fileScanTasks = scan.planFiles();
        try {
            Types.StructType partitionType = this.table().spec().partitionType();
            StructLikeMap<List<FileScanTask>> filesByPartition = this.groupByPartition(this.table(), partitionType, fileScanTasks);
            StructLikeMap<List<List<FileScanTask>>> structLikeMap = filesByPartition.transformValues(tasks -> ImmutableList.copyOf(this.planFileGroups(tasks)));
            return structLikeMap;
        }
        finally {
            try {
                fileScanTasks.close();
            }
            catch (IOException io) {
                LOG.error("Cannot properly close file iterable while planning for rewrite", (Throwable)io);
            }
        }
    }

    private StructLikeMap<List<FileScanTask>> groupByPartition(Table table, Types.StructType partitionType, Iterable<FileScanTask> tasks) {
        StructLikeMap<List<FileScanTask>> filesByPartition = StructLikeMap.create(partitionType);
        GenericRecord emptyStruct = GenericRecord.create(partitionType);
        for (FileScanTask task : tasks) {
            GenericRecord taskPartition = ((DataFile)task.file()).specId() == table.spec().specId() ? ((DataFile)task.file()).partition() : emptyStruct;
            filesByPartition.computeIfAbsent(taskPartition, unused -> Lists.newArrayList()).add(task);
        }
        return filesByPartition;
    }

    private RewriteFileGroup newRewriteGroup(SizeBasedFileRewritePlanner.RewriteExecutionContext ctx, StructLike partition, List<FileScanTask> tasks, long inputSplitSize, int expectedOutputFiles) {
        ImmutableRewriteDataFiles.FileGroupInfo info = ImmutableRewriteDataFiles.FileGroupInfo.builder().globalIndex(ctx.currentGlobalIndex()).partitionIndex(ctx.currentPartitionIndex(partition)).partition(partition).build();
        return new RewriteFileGroup(info, Lists.newArrayList(tasks), this.outputSpecId(), this.writeMaxFileSize(), inputSplitSize, expectedOutputFiles);
    }
}

