/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.actions.BaseDeleteReachableFiles;
import org.apache.iceberg.actions.DeleteReachableFiles;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="BaseDeleteReachableFiles", generator="Immutables")
public final class ImmutableDeleteReachableFiles {
    private ImmutableDeleteReachableFiles() {
    }

    @CheckReturnValue
    @Generated(from="BaseDeleteReachableFiles.Result", generator="Immutables")
    @Immutable
    public static final class Result
    implements BaseDeleteReachableFiles.Result {
        private final long deletedDataFilesCount;
        private final long deletedEqualityDeleteFilesCount;
        private final long deletedPositionDeleteFilesCount;
        private final long deletedManifestsCount;
        private final long deletedManifestListsCount;
        private final long deletedOtherFilesCount;

        private Result(long deletedDataFilesCount, long deletedEqualityDeleteFilesCount, long deletedPositionDeleteFilesCount, long deletedManifestsCount, long deletedManifestListsCount, long deletedOtherFilesCount) {
            this.deletedDataFilesCount = deletedDataFilesCount;
            this.deletedEqualityDeleteFilesCount = deletedEqualityDeleteFilesCount;
            this.deletedPositionDeleteFilesCount = deletedPositionDeleteFilesCount;
            this.deletedManifestsCount = deletedManifestsCount;
            this.deletedManifestListsCount = deletedManifestListsCount;
            this.deletedOtherFilesCount = deletedOtherFilesCount;
        }

        @Override
        public long deletedDataFilesCount() {
            return this.deletedDataFilesCount;
        }

        @Override
        public long deletedEqualityDeleteFilesCount() {
            return this.deletedEqualityDeleteFilesCount;
        }

        @Override
        public long deletedPositionDeleteFilesCount() {
            return this.deletedPositionDeleteFilesCount;
        }

        @Override
        public long deletedManifestsCount() {
            return this.deletedManifestsCount;
        }

        @Override
        public long deletedManifestListsCount() {
            return this.deletedManifestListsCount;
        }

        @Override
        public long deletedOtherFilesCount() {
            return this.deletedOtherFilesCount;
        }

        public final Result withDeletedDataFilesCount(long value) {
            if (this.deletedDataFilesCount == value) {
                return this;
            }
            return new Result(value, this.deletedEqualityDeleteFilesCount, this.deletedPositionDeleteFilesCount, this.deletedManifestsCount, this.deletedManifestListsCount, this.deletedOtherFilesCount);
        }

        public final Result withDeletedEqualityDeleteFilesCount(long value) {
            if (this.deletedEqualityDeleteFilesCount == value) {
                return this;
            }
            return new Result(this.deletedDataFilesCount, value, this.deletedPositionDeleteFilesCount, this.deletedManifestsCount, this.deletedManifestListsCount, this.deletedOtherFilesCount);
        }

        public final Result withDeletedPositionDeleteFilesCount(long value) {
            if (this.deletedPositionDeleteFilesCount == value) {
                return this;
            }
            return new Result(this.deletedDataFilesCount, this.deletedEqualityDeleteFilesCount, value, this.deletedManifestsCount, this.deletedManifestListsCount, this.deletedOtherFilesCount);
        }

        public final Result withDeletedManifestsCount(long value) {
            if (this.deletedManifestsCount == value) {
                return this;
            }
            return new Result(this.deletedDataFilesCount, this.deletedEqualityDeleteFilesCount, this.deletedPositionDeleteFilesCount, value, this.deletedManifestListsCount, this.deletedOtherFilesCount);
        }

        public final Result withDeletedManifestListsCount(long value) {
            if (this.deletedManifestListsCount == value) {
                return this;
            }
            return new Result(this.deletedDataFilesCount, this.deletedEqualityDeleteFilesCount, this.deletedPositionDeleteFilesCount, this.deletedManifestsCount, value, this.deletedOtherFilesCount);
        }

        public final Result withDeletedOtherFilesCount(long value) {
            if (this.deletedOtherFilesCount == value) {
                return this;
            }
            return new Result(this.deletedDataFilesCount, this.deletedEqualityDeleteFilesCount, this.deletedPositionDeleteFilesCount, this.deletedManifestsCount, this.deletedManifestListsCount, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Result && this.equalsByValue((Result)another);
        }

        private boolean equalsByValue(Result another) {
            return this.deletedDataFilesCount == another.deletedDataFilesCount && this.deletedEqualityDeleteFilesCount == another.deletedEqualityDeleteFilesCount && this.deletedPositionDeleteFilesCount == another.deletedPositionDeleteFilesCount && this.deletedManifestsCount == another.deletedManifestsCount && this.deletedManifestListsCount == another.deletedManifestListsCount && this.deletedOtherFilesCount == another.deletedOtherFilesCount;
        }

        public int hashCode() {
            int h2 = 5381;
            h2 += (h2 << 5) + Long.hashCode(this.deletedDataFilesCount);
            h2 += (h2 << 5) + Long.hashCode(this.deletedEqualityDeleteFilesCount);
            h2 += (h2 << 5) + Long.hashCode(this.deletedPositionDeleteFilesCount);
            h2 += (h2 << 5) + Long.hashCode(this.deletedManifestsCount);
            h2 += (h2 << 5) + Long.hashCode(this.deletedManifestListsCount);
            h2 += (h2 << 5) + Long.hashCode(this.deletedOtherFilesCount);
            return h2;
        }

        public String toString() {
            return "Result{deletedDataFilesCount=" + this.deletedDataFilesCount + ", deletedEqualityDeleteFilesCount=" + this.deletedEqualityDeleteFilesCount + ", deletedPositionDeleteFilesCount=" + this.deletedPositionDeleteFilesCount + ", deletedManifestsCount=" + this.deletedManifestsCount + ", deletedManifestListsCount=" + this.deletedManifestListsCount + ", deletedOtherFilesCount=" + this.deletedOtherFilesCount + "}";
        }

        public static Result copyOf(BaseDeleteReachableFiles.Result instance) {
            if (instance instanceof Result) {
                return (Result)instance;
            }
            return Result.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="BaseDeleteReachableFiles.Result", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_DELETED_DATA_FILES_COUNT = 1L;
            private static final long INIT_BIT_DELETED_EQUALITY_DELETE_FILES_COUNT = 2L;
            private static final long INIT_BIT_DELETED_POSITION_DELETE_FILES_COUNT = 4L;
            private static final long INIT_BIT_DELETED_MANIFESTS_COUNT = 8L;
            private static final long INIT_BIT_DELETED_MANIFEST_LISTS_COUNT = 16L;
            private static final long INIT_BIT_DELETED_OTHER_FILES_COUNT = 32L;
            private long initBits = 63L;
            private long deletedDataFilesCount;
            private long deletedEqualityDeleteFilesCount;
            private long deletedPositionDeleteFilesCount;
            private long deletedManifestsCount;
            private long deletedManifestListsCount;
            private long deletedOtherFilesCount;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(BaseDeleteReachableFiles.Result instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(DeleteReachableFiles.Result instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                DeleteReachableFiles.Result instance;
                long bits = 0L;
                if (object instanceof BaseDeleteReachableFiles.Result) {
                    instance = (BaseDeleteReachableFiles.Result)object;
                    if ((bits & 8L) == 0L) {
                        this.deletedPositionDeleteFilesCount(instance.deletedPositionDeleteFilesCount());
                        bits |= 8L;
                    }
                    if ((bits & 0x10L) == 0L) {
                        this.deletedManifestsCount(instance.deletedManifestsCount());
                        bits |= 0x10L;
                    }
                    if ((bits & 0x20L) == 0L) {
                        this.deletedEqualityDeleteFilesCount(instance.deletedEqualityDeleteFilesCount());
                        bits |= 0x20L;
                    }
                    if ((bits & 1L) == 0L) {
                        this.deletedManifestListsCount(instance.deletedManifestListsCount());
                        bits |= 1L;
                    }
                    if ((bits & 4L) == 0L) {
                        this.deletedDataFilesCount(instance.deletedDataFilesCount());
                        bits |= 4L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.deletedOtherFilesCount(instance.deletedOtherFilesCount());
                        bits |= 2L;
                    }
                }
                if (object instanceof DeleteReachableFiles.Result) {
                    instance = (DeleteReachableFiles.Result)object;
                    if ((bits & 8L) == 0L) {
                        this.deletedPositionDeleteFilesCount(instance.deletedPositionDeleteFilesCount());
                        bits |= 8L;
                    }
                    if ((bits & 0x10L) == 0L) {
                        this.deletedManifestsCount(instance.deletedManifestsCount());
                        bits |= 0x10L;
                    }
                    if ((bits & 0x20L) == 0L) {
                        this.deletedEqualityDeleteFilesCount(instance.deletedEqualityDeleteFilesCount());
                        bits |= 0x20L;
                    }
                    if ((bits & 1L) == 0L) {
                        this.deletedManifestListsCount(instance.deletedManifestListsCount());
                        bits |= 1L;
                    }
                    if ((bits & 4L) == 0L) {
                        this.deletedDataFilesCount(instance.deletedDataFilesCount());
                        bits |= 4L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.deletedOtherFilesCount(instance.deletedOtherFilesCount());
                        bits |= 2L;
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder deletedDataFilesCount(long deletedDataFilesCount) {
                this.deletedDataFilesCount = deletedDataFilesCount;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder deletedEqualityDeleteFilesCount(long deletedEqualityDeleteFilesCount) {
                this.deletedEqualityDeleteFilesCount = deletedEqualityDeleteFilesCount;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder deletedPositionDeleteFilesCount(long deletedPositionDeleteFilesCount) {
                this.deletedPositionDeleteFilesCount = deletedPositionDeleteFilesCount;
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder deletedManifestsCount(long deletedManifestsCount) {
                this.deletedManifestsCount = deletedManifestsCount;
                this.initBits &= 0xFFFFFFFFFFFFFFF7L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder deletedManifestListsCount(long deletedManifestListsCount) {
                this.deletedManifestListsCount = deletedManifestListsCount;
                this.initBits &= 0xFFFFFFFFFFFFFFEFL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder deletedOtherFilesCount(long deletedOtherFilesCount) {
                this.deletedOtherFilesCount = deletedOtherFilesCount;
                this.initBits &= 0xFFFFFFFFFFFFFFDFL;
                return this;
            }

            public Result build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Result(this.deletedDataFilesCount, this.deletedEqualityDeleteFilesCount, this.deletedPositionDeleteFilesCount, this.deletedManifestsCount, this.deletedManifestListsCount, this.deletedOtherFilesCount);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("deletedDataFilesCount");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("deletedEqualityDeleteFilesCount");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("deletedPositionDeleteFilesCount");
                }
                if ((this.initBits & 8L) != 0L) {
                    attributes.add("deletedManifestsCount");
                }
                if ((this.initBits & 0x10L) != 0L) {
                    attributes.add("deletedManifestListsCount");
                }
                if ((this.initBits & 0x20L) != 0L) {
                    attributes.add("deletedOtherFilesCount");
                }
                return "Cannot build Result, some of required attributes are not set " + String.valueOf(attributes);
            }
        }
    }
}

