/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws;

import java.io.Serializable;
import java.util.Map;
import org.apache.iceberg.aws.s3.VendedCredentialsProvider;
import org.apache.iceberg.common.DynClasses;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Strings;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.SerializableMap;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.LegacyMd5Plugin;
import software.amazon.awssdk.services.s3.S3CrtAsyncClientBuilder;

public class AwsClientProperties
implements Serializable {
    public static final String CLIENT_CREDENTIALS_PROVIDER = "client.credentials-provider";
    protected static final String CLIENT_CREDENTIAL_PROVIDER_PREFIX = "client.credentials-provider.";
    public static final String CLIENT_REGION = "client.region";
    public static final String REFRESH_CREDENTIALS_ENDPOINT = "client.refresh-credentials-endpoint";
    public static final String REFRESH_CREDENTIALS_ENABLED = "client.refresh-credentials-enabled";
    public static final String LEGACY_MD5_PLUGIN_ENABLED = "client.legacy-md5-plugin-enabled";
    private String clientRegion;
    private final String clientCredentialsProvider;
    private final Map<String, String> clientCredentialsProviderProperties;
    private final String refreshCredentialsEndpoint;
    private final boolean refreshCredentialsEnabled;
    private final boolean legacyMd5pluginEnabled;
    private final Map<String, String> allProperties;

    public AwsClientProperties() {
        this.clientRegion = null;
        this.clientCredentialsProvider = null;
        this.clientCredentialsProviderProperties = null;
        this.refreshCredentialsEndpoint = null;
        this.refreshCredentialsEnabled = true;
        this.legacyMd5pluginEnabled = false;
        this.allProperties = null;
    }

    public AwsClientProperties(Map<String, String> properties) {
        this.allProperties = SerializableMap.copyOf(properties);
        this.clientRegion = properties.get(CLIENT_REGION);
        this.clientCredentialsProvider = properties.get(CLIENT_CREDENTIALS_PROVIDER);
        this.clientCredentialsProviderProperties = PropertyUtil.propertiesWithPrefix(properties, CLIENT_CREDENTIAL_PROVIDER_PREFIX);
        this.refreshCredentialsEndpoint = RESTUtil.resolveEndpoint(properties.get("uri"), properties.get(REFRESH_CREDENTIALS_ENDPOINT));
        this.refreshCredentialsEnabled = PropertyUtil.propertyAsBoolean(properties, REFRESH_CREDENTIALS_ENABLED, true);
        this.legacyMd5pluginEnabled = PropertyUtil.propertyAsBoolean(properties, LEGACY_MD5_PLUGIN_ENABLED, false);
    }

    public String clientRegion() {
        return this.clientRegion;
    }

    public void setClientRegion(String clientRegion) {
        this.clientRegion = clientRegion;
    }

    public <BuilderT extends AwsClientBuilder<BuilderT, ClientT>, ClientT> void applyClientRegionConfiguration(BuilderT builder) {
        if (this.clientRegion != null) {
            builder.region(Region.of((String)this.clientRegion));
        }
    }

    public <T extends S3CrtAsyncClientBuilder> void applyClientRegionConfiguration(T builder) {
        if (this.clientRegion != null) {
            builder.region(Region.of((String)this.clientRegion));
        }
    }

    public <BuilderT extends AwsClientBuilder<BuilderT, ClientT>, ClientT> void applyClientCredentialConfigurations(BuilderT builder) {
        if (!Strings.isNullOrEmpty(this.clientCredentialsProvider)) {
            builder.credentialsProvider(this.credentialsProvider(this.clientCredentialsProvider));
        }
    }

    public <T extends S3CrtAsyncClientBuilder> void applyClientCredentialConfigurations(T builder) {
        if (!Strings.isNullOrEmpty(this.clientCredentialsProvider)) {
            builder.credentialsProvider(this.credentialsProvider(this.clientCredentialsProvider));
        }
    }

    public AwsCredentialsProvider credentialsProvider(String accessKeyId, String secretAccessKey, String sessionToken) {
        if (this.refreshCredentialsEnabled && !Strings.isNullOrEmpty(this.refreshCredentialsEndpoint)) {
            this.clientCredentialsProviderProperties.putAll(this.allProperties);
            this.clientCredentialsProviderProperties.put("credentials.uri", this.refreshCredentialsEndpoint);
            return this.credentialsProvider(VendedCredentialsProvider.class.getName());
        }
        if (!Strings.isNullOrEmpty(accessKeyId) && !Strings.isNullOrEmpty(secretAccessKey)) {
            if (Strings.isNullOrEmpty(sessionToken)) {
                return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKeyId, (String)secretAccessKey));
            }
            return StaticCredentialsProvider.create((AwsCredentials)AwsSessionCredentials.create((String)accessKeyId, (String)secretAccessKey, (String)sessionToken));
        }
        if (!Strings.isNullOrEmpty(this.clientCredentialsProvider)) {
            return this.credentialsProvider(this.clientCredentialsProvider);
        }
        return DefaultCredentialsProvider.builder().build();
    }

    public <BuilderT extends AwsClientBuilder<BuilderT, ClientT>, ClientT> void applyRetryConfigurations(BuilderT builder) {
        ClientOverrideConfiguration.Builder configBuilder = null != builder.overrideConfiguration() ? builder.overrideConfiguration().toBuilder() : ClientOverrideConfiguration.builder();
        builder.overrideConfiguration((ClientOverrideConfiguration)configBuilder.retryStrategy(RetryMode.ADAPTIVE_V2).build());
    }

    public <BuilderT extends AwsClientBuilder<BuilderT, ClientT>, ClientT> void applyLegacyMd5Plugin(BuilderT builder) {
        if (this.legacyMd5pluginEnabled) {
            builder.addPlugin(LegacyMd5Plugin.create());
        }
    }

    private AwsCredentialsProvider credentialsProvider(String credentialsProviderClass) {
        Class providerClass;
        try {
            providerClass = DynClasses.builder().impl(credentialsProviderClass).buildChecked();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Cannot load class %s, it does not exist in the classpath", credentialsProviderClass), e);
        }
        Preconditions.checkArgument(AwsCredentialsProvider.class.isAssignableFrom(providerClass), String.format("Cannot initialize %s, it does not implement %s.", credentialsProviderClass, AwsCredentialsProvider.class.getName()));
        try {
            return this.createCredentialsProvider(providerClass);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Cannot create an instance of %s, it does not contain a static 'create' or 'create(Map<String, String>)' method", credentialsProviderClass), e);
        }
    }

    private AwsCredentialsProvider createCredentialsProvider(Class<?> providerClass) throws NoSuchMethodException {
        AwsCredentialsProvider provider;
        try {
            provider = (AwsCredentialsProvider)DynMethods.builder("create").hiddenImpl(providerClass, Map.class).buildStaticChecked().invoke(this.clientCredentialsProviderProperties);
        }
        catch (NoSuchMethodException e) {
            provider = (AwsCredentialsProvider)DynMethods.builder("create").hiddenImpl(providerClass, new Class[0]).buildStaticChecked().invoke(new Object[0]);
        }
        return provider;
    }
}

