/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.iceberg.aws.AwsClientFactories;
import org.apache.iceberg.aws.AwsClientFactory;
import org.apache.iceberg.aws.AwsProperties;
import org.apache.iceberg.encryption.KeyManagementClient;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.model.DataKeySpec;
import software.amazon.awssdk.services.kms.model.DecryptRequest;
import software.amazon.awssdk.services.kms.model.DecryptResponse;
import software.amazon.awssdk.services.kms.model.EncryptRequest;
import software.amazon.awssdk.services.kms.model.EncryptResponse;
import software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpec;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyRequest;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyResponse;

public class AwsKeyManagementClient
implements KeyManagementClient {
    private KmsClient kmsClient;
    private EncryptionAlgorithmSpec encryptionAlgorithmSpec;
    private DataKeySpec dataKeySpec;

    @Override
    public void initialize(Map<String, String> properties) {
        AwsClientFactory clientFactory = AwsClientFactories.from(properties);
        this.kmsClient = clientFactory.kms();
        AwsProperties awsProperties = new AwsProperties(properties);
        this.encryptionAlgorithmSpec = awsProperties.kmsEncryptionAlgorithmSpec();
        this.dataKeySpec = awsProperties.kmsDataKeySpec();
    }

    @Override
    public ByteBuffer wrapKey(ByteBuffer key, String wrappingKeyId) {
        EncryptRequest request = (EncryptRequest)EncryptRequest.builder().keyId(wrappingKeyId).encryptionAlgorithm(this.encryptionAlgorithmSpec).plaintext(SdkBytes.fromByteBuffer((ByteBuffer)key)).build();
        EncryptResponse result = this.kmsClient.encrypt(request);
        return result.ciphertextBlob().asByteBuffer();
    }

    @Override
    public boolean supportsKeyGeneration() {
        return true;
    }

    @Override
    public KeyManagementClient.KeyGenerationResult generateKey(String wrappingKeyId) {
        GenerateDataKeyRequest request = (GenerateDataKeyRequest)GenerateDataKeyRequest.builder().keyId(wrappingKeyId).keySpec(this.dataKeySpec).build();
        GenerateDataKeyResponse response = this.kmsClient.generateDataKey(request);
        KeyManagementClient.KeyGenerationResult result = new KeyManagementClient.KeyGenerationResult(response.plaintext().asByteBuffer(), response.ciphertextBlob().asByteBuffer());
        return result;
    }

    @Override
    public ByteBuffer unwrapKey(ByteBuffer wrappedKey, String wrappingKeyId) {
        DecryptRequest request = (DecryptRequest)DecryptRequest.builder().keyId(wrappingKeyId).encryptionAlgorithm(this.encryptionAlgorithmSpec).ciphertextBlob(SdkBytes.fromByteBuffer((ByteBuffer)wrappedKey)).build();
        DecryptResponse result = this.kmsClient.decrypt(request);
        return result.plaintext().asByteBuffer();
    }

    @Override
    public void close() {
        if (this.kmsClient != null) {
            this.kmsClient.close();
        }
    }
}

