/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Strings;
import org.apache.iceberg.rest.ErrorHandlers;
import org.apache.iceberg.rest.HTTPClient;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.auth.AuthManager;
import org.apache.iceberg.rest.auth.AuthManagers;
import org.apache.iceberg.rest.auth.AuthSession;
import org.apache.iceberg.rest.credentials.Credential;
import org.apache.iceberg.rest.responses.LoadCredentialsResponse;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.cache.CachedSupplier;
import software.amazon.awssdk.utils.cache.RefreshResult;

public class VendedCredentialsProvider
implements AwsCredentialsProvider,
SdkAutoCloseable {
    public static final String URI = "credentials.uri";
    private volatile HTTPClient client;
    private final Map<String, String> properties;
    private final CachedSupplier<AwsCredentials> credentialCache;
    private final String catalogEndpoint;
    private final String credentialsEndpoint;
    private AuthManager authManager;
    private AuthSession authSession;

    private VendedCredentialsProvider(Map<String, String> properties) {
        Preconditions.checkArgument(null != properties, "Invalid properties: null");
        Preconditions.checkArgument(null != properties.get(URI), "Invalid credentials endpoint: null");
        Preconditions.checkArgument(null != properties.get("uri"), "Invalid catalog endpoint: null");
        this.properties = properties;
        this.credentialCache = CachedSupplier.builder(() -> this.credentialFromProperties().orElseGet(this::refreshCredential)).cachedValueName(VendedCredentialsProvider.class.getName()).build();
        this.catalogEndpoint = properties.get("uri");
        this.credentialsEndpoint = properties.get(URI);
    }

    public AwsCredentials resolveCredentials() {
        return (AwsCredentials)this.credentialCache.get();
    }

    public void close() {
        IoUtils.closeQuietlyV2((AutoCloseable)this.authSession, null);
        IoUtils.closeQuietlyV2((AutoCloseable)this.authManager, null);
        IoUtils.closeQuietlyV2((AutoCloseable)this.client, null);
        IoUtils.closeQuietlyV2(this.credentialCache, null);
    }

    public static VendedCredentialsProvider create(Map<String, String> properties) {
        return new VendedCredentialsProvider(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RESTClient httpClient() {
        if (null == this.client) {
            VendedCredentialsProvider vendedCredentialsProvider = this;
            synchronized (vendedCredentialsProvider) {
                if (null == this.client) {
                    this.authManager = AuthManagers.loadAuthManager("s3-credentials-refresh", this.properties);
                    HTTPClient httpClient = HTTPClient.builder(this.properties).uri(this.catalogEndpoint).build();
                    this.authSession = this.authManager.catalogSession(httpClient, this.properties);
                    this.client = httpClient.withAuthSession(this.authSession);
                }
            }
        }
        return this.client;
    }

    private LoadCredentialsResponse fetchCredentials() {
        return this.httpClient().get(this.credentialsEndpoint, null, LoadCredentialsResponse.class, Map.of(), ErrorHandlers.defaultErrorHandler());
    }

    private Optional<RefreshResult<AwsCredentials>> credentialFromProperties() {
        String accessKeyId = this.properties.get("s3.access-key-id");
        String secretAccessKey = this.properties.get("s3.secret-access-key");
        String sessionToken = this.properties.get("s3.session-token");
        String tokenExpiresAtMillis = this.properties.get("s3.session-token-expires-at-ms");
        if (Strings.isNullOrEmpty(accessKeyId) || Strings.isNullOrEmpty(secretAccessKey) || Strings.isNullOrEmpty(sessionToken) || Strings.isNullOrEmpty(tokenExpiresAtMillis)) {
            return Optional.empty();
        }
        Instant expiresAt = Instant.ofEpochMilli(Long.parseLong(tokenExpiresAtMillis));
        Instant prefetchAt = expiresAt.minus(5L, ChronoUnit.MINUTES);
        if (Instant.now().isAfter(prefetchAt)) {
            return Optional.empty();
        }
        return Optional.of(RefreshResult.builder((Object)AwsSessionCredentials.builder().accessKeyId(accessKeyId).secretAccessKey(secretAccessKey).sessionToken(sessionToken).expirationTime(expiresAt).build()).staleTime(expiresAt).prefetchTime(prefetchAt).build());
    }

    private RefreshResult<AwsCredentials> refreshCredential() {
        LoadCredentialsResponse response = this.fetchCredentials();
        List s3Credentials = response.credentials().stream().filter(c -> c.prefix().startsWith("s3")).collect(Collectors.toList());
        Preconditions.checkState(!s3Credentials.isEmpty(), "Invalid S3 Credentials: empty");
        Preconditions.checkState(s3Credentials.size() == 1, "Invalid S3 Credentials: only one S3 credential should exist");
        Credential s3Credential = (Credential)s3Credentials.get(0);
        this.checkCredential(s3Credential, "s3.access-key-id");
        this.checkCredential(s3Credential, "s3.secret-access-key");
        this.checkCredential(s3Credential, "s3.session-token");
        this.checkCredential(s3Credential, "s3.session-token-expires-at-ms");
        String accessKeyId = s3Credential.config().get("s3.access-key-id");
        String secretAccessKey = s3Credential.config().get("s3.secret-access-key");
        String sessionToken = s3Credential.config().get("s3.session-token");
        String tokenExpiresAtMillis = s3Credential.config().get("s3.session-token-expires-at-ms");
        Instant expiresAt = Instant.ofEpochMilli(Long.parseLong(tokenExpiresAtMillis));
        Instant prefetchAt = expiresAt.minus(5L, ChronoUnit.MINUTES);
        return RefreshResult.builder((Object)AwsSessionCredentials.builder().accessKeyId(accessKeyId).secretAccessKey(secretAccessKey).sessionToken(sessionToken).expirationTime(expiresAt).build()).staleTime(expiresAt).prefetchTime(prefetchAt).build();
    }

    private void checkCredential(Credential credential, String property) {
        Preconditions.checkState(credential.config().containsKey(property), "Invalid S3 Credentials: %s not set", (Object)property);
    }
}

