/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.runtime.util.HadoopUtils;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.factories.CatalogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.flink.CatalogLoader;
import org.apache.iceberg.flink.FlinkCatalog;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Strings;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.PropertyUtil;

public class FlinkCatalogFactory
implements CatalogFactory {
    public static final String ICEBERG_CATALOG_TYPE = "catalog-type";
    public static final String ICEBERG_CATALOG_TYPE_HADOOP = "hadoop";
    public static final String ICEBERG_CATALOG_TYPE_HIVE = "hive";
    public static final String ICEBERG_CATALOG_TYPE_REST = "rest";
    public static final String HIVE_CONF_DIR = "hive-conf-dir";
    public static final String HADOOP_CONF_DIR = "hadoop-conf-dir";
    public static final String DEFAULT_DATABASE = "default-database";
    public static final String DEFAULT_DATABASE_NAME = "default";
    public static final String DEFAULT_CATALOG_NAME = "default_catalog";
    public static final String BASE_NAMESPACE = "base-namespace";
    public static final String TYPE = "type";
    public static final String PROPERTY_VERSION = "property-version";

    static CatalogLoader createCatalogLoader(String name, Map<String, String> properties, org.apache.hadoop.conf.Configuration hadoopConf) {
        String catalogImpl = properties.get("catalog-impl");
        if (catalogImpl != null) {
            String catalogType = properties.get(ICEBERG_CATALOG_TYPE);
            Preconditions.checkArgument(catalogType == null, "Cannot create catalog %s, both catalog-type and catalog-impl are set: catalog-type=%s, catalog-impl=%s", (Object)name, (Object)catalogType, (Object)catalogImpl);
            return CatalogLoader.custom(name, properties, hadoopConf, catalogImpl);
        }
        String catalogType = properties.getOrDefault(ICEBERG_CATALOG_TYPE, ICEBERG_CATALOG_TYPE_HIVE);
        switch (catalogType.toLowerCase(Locale.ENGLISH)) {
            case "hive": {
                String hiveConfDir = properties.get(HIVE_CONF_DIR);
                String hadoopConfDir = properties.get(HADOOP_CONF_DIR);
                org.apache.hadoop.conf.Configuration newHadoopConf = FlinkCatalogFactory.mergeHiveConf(hadoopConf, hiveConfDir, hadoopConfDir);
                return CatalogLoader.hive(name, newHadoopConf, properties);
            }
            case "hadoop": {
                return CatalogLoader.hadoop(name, hadoopConf, properties);
            }
            case "rest": {
                return CatalogLoader.rest(name, hadoopConf, properties);
            }
        }
        throw new UnsupportedOperationException("Unknown catalog-type: " + catalogType + " (Must be 'hive', 'hadoop' or 'rest')");
    }

    public Map<String, String> requiredContext() {
        HashMap<String, String> context = Maps.newHashMap();
        context.put(TYPE, "iceberg");
        context.put(PROPERTY_VERSION, "1");
        return context;
    }

    public List<String> supportedProperties() {
        return ImmutableList.of("*");
    }

    public Catalog createCatalog(String name, Map<String, String> properties) {
        return this.createCatalog(name, properties, FlinkCatalogFactory.clusterHadoopConf());
    }

    protected Catalog createCatalog(String name, Map<String, String> properties, org.apache.hadoop.conf.Configuration hadoopConf) {
        CatalogLoader catalogLoader = FlinkCatalogFactory.createCatalogLoader(name, properties, hadoopConf);
        String defaultDatabase = properties.getOrDefault(DEFAULT_DATABASE, DEFAULT_DATABASE_NAME);
        Namespace baseNamespace = Namespace.empty();
        if (properties.containsKey(BASE_NAMESPACE)) {
            baseNamespace = Namespace.of(properties.get(BASE_NAMESPACE).split("\\."));
        }
        boolean cacheEnabled = PropertyUtil.propertyAsBoolean(properties, "cache-enabled", true);
        long cacheExpirationIntervalMs = PropertyUtil.propertyAsLong(properties, "cache.expiration-interval-ms", -1L);
        Preconditions.checkArgument(cacheExpirationIntervalMs != 0L, "%s is not allowed to be 0.", (Object)"cache.expiration-interval-ms");
        return new FlinkCatalog(name, defaultDatabase, baseNamespace, catalogLoader, properties, cacheEnabled, cacheExpirationIntervalMs);
    }

    private static org.apache.hadoop.conf.Configuration mergeHiveConf(org.apache.hadoop.conf.Configuration hadoopConf, String hiveConfDir, String hadoopConfDir) {
        org.apache.hadoop.conf.Configuration newConf = new org.apache.hadoop.conf.Configuration(hadoopConf);
        if (!Strings.isNullOrEmpty(hiveConfDir)) {
            Preconditions.checkState(Files.exists(Paths.get(hiveConfDir, "hive-site.xml"), new LinkOption[0]), "There should be a hive-site.xml file under the directory %s", (Object)hiveConfDir);
            newConf.addResource(new Path(hiveConfDir, "hive-site.xml"));
        } else {
            URL configFile = CatalogLoader.class.getClassLoader().getResource("hive-site.xml");
            if (configFile != null) {
                newConf.addResource(configFile);
            }
        }
        if (!Strings.isNullOrEmpty(hadoopConfDir)) {
            Preconditions.checkState(Files.exists(Paths.get(hadoopConfDir, "hdfs-site.xml"), new LinkOption[0]), "Failed to load Hadoop configuration: missing %s", (Object)Paths.get(hadoopConfDir, "hdfs-site.xml"));
            newConf.addResource(new Path(hadoopConfDir, "hdfs-site.xml"));
            Preconditions.checkState(Files.exists(Paths.get(hadoopConfDir, "core-site.xml"), new LinkOption[0]), "Failed to load Hadoop configuration: missing %s", (Object)Paths.get(hadoopConfDir, "core-site.xml"));
            newConf.addResource(new Path(hadoopConfDir, "core-site.xml"));
        }
        return newConf;
    }

    public static org.apache.hadoop.conf.Configuration clusterHadoopConf() {
        return HadoopUtils.getHadoopConfiguration((Configuration)GlobalConfiguration.loadConfiguration());
    }
}

