/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.util.TimeUtils;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

@Internal
public class FlinkConfParser {
    private final Map<String, String> tableProperties;
    private final Map<String, String> options;
    private final ReadableConfig readableConfig;

    public FlinkConfParser(Table table, Map<String, String> options, ReadableConfig readableConfig) {
        this.tableProperties = table.properties();
        this.options = options;
        this.readableConfig = readableConfig;
    }

    FlinkConfParser(Map<String, String> options, ReadableConfig readableConfig) {
        this.tableProperties = ImmutableMap.of();
        this.options = options;
        this.readableConfig = readableConfig;
    }

    public BooleanConfParser booleanConf() {
        return new BooleanConfParser();
    }

    public IntConfParser intConf() {
        return new IntConfParser();
    }

    public LongConfParser longConf() {
        return new LongConfParser();
    }

    public DoubleConfParser doubleConf() {
        return new DoubleConfParser();
    }

    public <E extends Enum<E>> EnumConfParser<E> enumConfParser(Class<E> enumClass) {
        return new EnumConfParser<E>(enumClass);
    }

    public StringConfParser stringConf() {
        return new StringConfParser();
    }

    public DurationConfParser durationConf() {
        return new DurationConfParser();
    }

    public class BooleanConfParser
    extends ConfParser<BooleanConfParser, Boolean> {
        private Boolean defaultValue;

        @Override
        protected BooleanConfParser self() {
            return this;
        }

        public BooleanConfParser defaultValue(boolean value) {
            this.defaultValue = value;
            return this.self();
        }

        public BooleanConfParser defaultValue(String value) {
            this.defaultValue = Boolean.parseBoolean(value);
            return this.self();
        }

        public boolean parse() {
            Preconditions.checkArgument(this.defaultValue != null, "Default value cannot be null");
            return this.parse(Boolean::parseBoolean, this.defaultValue);
        }
    }

    public class IntConfParser
    extends ConfParser<IntConfParser, Integer> {
        private Integer defaultValue;

        @Override
        protected IntConfParser self() {
            return this;
        }

        public IntConfParser defaultValue(int value) {
            this.defaultValue = value;
            return this.self();
        }

        public int parse() {
            Preconditions.checkArgument(this.defaultValue != null, "Default value cannot be null");
            return this.parse(Integer::parseInt, this.defaultValue);
        }

        public Integer parseOptional() {
            return this.parse(Integer::parseInt, null);
        }
    }

    public class LongConfParser
    extends ConfParser<LongConfParser, Long> {
        private Long defaultValue;

        @Override
        protected LongConfParser self() {
            return this;
        }

        public LongConfParser defaultValue(long value) {
            this.defaultValue = value;
            return this.self();
        }

        public long parse() {
            Preconditions.checkArgument(this.defaultValue != null, "Default value cannot be null");
            return this.parse(Long::parseLong, this.defaultValue);
        }

        public Long parseOptional() {
            return this.parse(Long::parseLong, null);
        }
    }

    public class DoubleConfParser
    extends ConfParser<DoubleConfParser, Double> {
        private Double defaultValue;

        @Override
        protected DoubleConfParser self() {
            return this;
        }

        public DoubleConfParser defaultValue(double value) {
            this.defaultValue = value;
            return this.self();
        }

        public double parse() {
            Preconditions.checkArgument(this.defaultValue != null, "Default value cannot be null");
            return this.parse(Double::parseDouble, this.defaultValue);
        }

        public Double parseOptional() {
            return this.parse(Double::parseDouble, null);
        }
    }

    public class EnumConfParser<E extends Enum<E>>
    extends ConfParser<EnumConfParser<E>, E> {
        private E defaultValue;
        private final Class<E> enumClass;

        EnumConfParser(Class<E> enumClass) {
            this.enumClass = enumClass;
        }

        @Override
        protected EnumConfParser<E> self() {
            return this;
        }

        public EnumConfParser<E> defaultValue(E value) {
            this.defaultValue = value;
            return this.self();
        }

        public E parse() {
            Preconditions.checkArgument(this.defaultValue != null, "Default value cannot be null");
            return (E)this.parse(s2 -> Enum.valueOf(this.enumClass, s2), this.defaultValue);
        }

        public E parseOptional() {
            return (E)((Enum)this.parse(s2 -> Enum.valueOf(this.enumClass, s2), null));
        }
    }

    public class StringConfParser
    extends ConfParser<StringConfParser, String> {
        private String defaultValue;

        @Override
        protected StringConfParser self() {
            return this;
        }

        public StringConfParser defaultValue(String value) {
            this.defaultValue = value;
            return this.self();
        }

        public String parse() {
            Preconditions.checkArgument(this.defaultValue != null, "Default value cannot be null");
            return this.parse(Function.identity(), this.defaultValue);
        }

        public String parseOptional() {
            return this.parse(Function.identity(), null);
        }
    }

    public class DurationConfParser
    extends ConfParser<DurationConfParser, Duration> {
        private Duration defaultValue;

        @Override
        protected DurationConfParser self() {
            return this;
        }

        public DurationConfParser defaultValue(Duration value) {
            this.defaultValue = value;
            return this.self();
        }

        public Duration parse() {
            Preconditions.checkArgument(this.defaultValue != null, "Default value cannot be null");
            return this.parse(TimeUtils::parseDuration, this.defaultValue);
        }

        public Duration parseOptional() {
            return this.parse(TimeUtils::parseDuration, null);
        }
    }

    public abstract class ConfParser<ThisT, T> {
        private final List<String> optionNames = Lists.newArrayList();
        private String tablePropertyName;
        private ConfigOption<T> configOption;

        protected abstract ThisT self();

        public ThisT option(String name) {
            this.optionNames.add(name);
            return this.self();
        }

        public ThisT flinkConfig(ConfigOption<T> newConfigOption) {
            this.configOption = newConfigOption;
            return this.self();
        }

        public ThisT tableProperty(String name) {
            this.tablePropertyName = name;
            return this.self();
        }

        protected T parse(Function<String, T> conversion, T defaultValue) {
            Object propertyValue;
            if (!this.optionNames.isEmpty()) {
                for (String optionName : this.optionNames) {
                    String optionValue = FlinkConfParser.this.options.get(optionName);
                    if (optionValue == null) continue;
                    return conversion.apply(optionValue);
                }
            }
            if (this.configOption != null && (propertyValue = FlinkConfParser.this.readableConfig.get(this.configOption)) != null) {
                return (T)propertyValue;
            }
            if (this.tablePropertyName != null && (propertyValue = FlinkConfParser.this.tableProperties.get(this.tablePropertyName)) != null) {
                return conversion.apply((String)propertyValue);
            }
            return defaultValue;
        }
    }
}

