/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.iceberg.Schema;
import org.apache.iceberg.flink.FlinkFixupTypes;
import org.apache.iceberg.flink.FlinkTypeToType;
import org.apache.iceberg.flink.TypeToFlinkType;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class FlinkSchemaUtil {
    private FlinkSchemaUtil() {
    }

    @Deprecated
    public static Schema convert(TableSchema schema) {
        LogicalType schemaType = schema.toRowDataType().getLogicalType();
        Preconditions.checkArgument(schemaType instanceof RowType, "Schema logical type should be row type.");
        RowType root = (RowType)schemaType;
        Type converted = (Type)root.accept((LogicalTypeVisitor)new FlinkTypeToType(root));
        Schema icebergSchema = new Schema(converted.asStructType().fields());
        if (schema.getPrimaryKey().isPresent()) {
            return FlinkSchemaUtil.freshIdentifierFieldIds(icebergSchema, ((org.apache.flink.table.api.constraints.UniqueConstraint)schema.getPrimaryKey().get()).getColumns());
        }
        return icebergSchema;
    }

    public static Schema convert(ResolvedSchema flinkSchema) {
        List tableColumns = flinkSchema.getColumns();
        DataTypes.Field[] fields = (DataTypes.Field[])tableColumns.stream().map(column -> {
            if (column.getComment().isPresent()) {
                return DataTypes.FIELD((String)column.getName(), (DataType)column.getDataType(), (String)((String)column.getComment().get()));
            }
            return DataTypes.FIELD((String)column.getName(), (DataType)column.getDataType());
        }).toArray(DataTypes.Field[]::new);
        LogicalType schemaType = ((DataType)DataTypes.ROW((DataTypes.Field[])fields).notNull()).getLogicalType();
        Preconditions.checkArgument(schemaType instanceof RowType, "Schema logical type should be row type.");
        RowType root = (RowType)schemaType;
        Type converted = (Type)root.accept((LogicalTypeVisitor)new FlinkTypeToType(root));
        Schema icebergSchema = new Schema(converted.asStructType().fields());
        return flinkSchema.getPrimaryKey().map(pk -> FlinkSchemaUtil.freshIdentifierFieldIds(icebergSchema, pk.getColumns())).orElse(icebergSchema);
    }

    private static Schema freshIdentifierFieldIds(Schema icebergSchema, List<String> primaryKeys) {
        HashSet<Integer> identifierFieldIds = Sets.newHashSet();
        for (String primaryKey : primaryKeys) {
            Types.NestedField field = icebergSchema.findField(primaryKey);
            Preconditions.checkNotNull(field, "Cannot find field ID for the primary key column %s in schema %s", (Object)primaryKey, (Object)icebergSchema);
            identifierFieldIds.add(field.fieldId());
        }
        return new Schema(icebergSchema.schemaId(), icebergSchema.asStruct().fields(), identifierFieldIds);
    }

    @Deprecated
    public static Schema convert(Schema baseSchema, TableSchema flinkSchema) {
        Types.StructType struct = FlinkSchemaUtil.convert(flinkSchema).asStruct();
        Schema schema = TypeUtil.reassignIds(new Schema(struct.fields()), baseSchema);
        schema = TypeUtil.reassignDoc(schema, baseSchema);
        Schema fixedSchema = FlinkFixupTypes.fixup(schema, baseSchema);
        if (flinkSchema.getPrimaryKey().isPresent()) {
            return FlinkSchemaUtil.freshIdentifierFieldIds(fixedSchema, ((org.apache.flink.table.api.constraints.UniqueConstraint)flinkSchema.getPrimaryKey().get()).getColumns());
        }
        return fixedSchema;
    }

    public static Schema convert(Schema baseSchema, ResolvedSchema flinkSchema) {
        Types.StructType struct = FlinkSchemaUtil.convert(flinkSchema).asStruct();
        Schema schema = TypeUtil.reassignIds(new Schema(struct.fields()), baseSchema);
        schema = TypeUtil.reassignDoc(schema, baseSchema);
        Schema fixedSchema = FlinkFixupTypes.fixup(schema, baseSchema);
        return flinkSchema.getPrimaryKey().map(pk -> FlinkSchemaUtil.freshIdentifierFieldIds(fixedSchema, pk.getColumns())).orElse(fixedSchema);
    }

    public static RowType convert(Schema schema) {
        return (RowType)TypeUtil.visit(schema, new TypeToFlinkType());
    }

    public static LogicalType convert(Type type) {
        return TypeUtil.visit(type, new TypeToFlinkType());
    }

    public static Type convert(LogicalType flinkType) {
        return (Type)flinkType.accept((LogicalTypeVisitor)new FlinkTypeToType());
    }

    @Deprecated
    public static TableSchema toSchema(RowType rowType) {
        TableSchema.Builder builder = TableSchema.builder();
        for (RowType.RowField field : rowType.getFields()) {
            builder.field(field.getName(), TypeConversions.fromLogicalToDataType((LogicalType)field.getType()));
        }
        return builder.build();
    }

    public static ResolvedSchema toResolvedSchema(RowType rowType) {
        ArrayList<Column.PhysicalColumn> columns = Lists.newArrayListWithExpectedSize(rowType.getFieldCount());
        for (RowType.RowField field : rowType.getFields()) {
            columns.add(Column.physical((String)field.getName(), (DataType)TypeConversions.fromLogicalToDataType((LogicalType)field.getType())));
        }
        return ResolvedSchema.of(columns);
    }

    @Deprecated
    public static TableSchema toSchema(Schema schema) {
        TableSchema.Builder builder = TableSchema.builder();
        for (RowType.RowField field : FlinkSchemaUtil.convert(schema).getFields()) {
            builder.field(field.getName(), TypeConversions.fromLogicalToDataType((LogicalType)field.getType()));
        }
        Set<Integer> identifierFieldIds = schema.identifierFieldIds();
        if (!identifierFieldIds.isEmpty()) {
            ArrayList<String> columns = Lists.newArrayListWithExpectedSize(identifierFieldIds.size());
            for (Integer identifierFieldId : identifierFieldIds) {
                String columnName = schema.findColumnName(identifierFieldId);
                Preconditions.checkNotNull(columnName, "Cannot find field with id %s in schema %s", (Object)identifierFieldId, (Object)schema);
                columns.add(columnName);
            }
            builder.primaryKey(columns.toArray(new String[0]));
        }
        return builder.build();
    }

    public static ResolvedSchema toResolvedSchema(Schema schema) {
        RowType rowType = FlinkSchemaUtil.convert(schema);
        ArrayList<Column> columns = Lists.newArrayListWithExpectedSize(rowType.getFieldCount());
        for (RowType.RowField field : rowType.getFields()) {
            columns.add((Column)Column.physical((String)field.getName(), (DataType)TypeConversions.fromLogicalToDataType((LogicalType)field.getType())));
        }
        Set<Integer> identifierFieldIds = schema.identifierFieldIds();
        UniqueConstraint uniqueConstraint = null;
        if (!identifierFieldIds.isEmpty()) {
            ArrayList<String> primaryKeyColumns = Lists.newArrayListWithExpectedSize(identifierFieldIds.size());
            for (Integer identifierFieldId : identifierFieldIds) {
                String columnName = schema.findColumnName(identifierFieldId);
                Preconditions.checkNotNull(columnName, "Cannot find field with id %s in schema %s", (Object)identifierFieldId, (Object)schema);
                primaryKeyColumns.add(columnName);
            }
            uniqueConstraint = UniqueConstraint.primaryKey((String)UUID.randomUUID().toString(), primaryKeyColumns);
            FlinkSchemaUtil.validatePrimaryKey(uniqueConstraint, columns);
        }
        return new ResolvedSchema(columns, Collections.emptyList(), uniqueConstraint);
    }

    private static void validatePrimaryKey(UniqueConstraint primaryKey, List<Column> columns) {
        Map columnsByNameLookup = columns.stream().collect(Collectors.toMap(Column::getName, Function.identity()));
        Set duplicateColumns = primaryKey.getColumns().stream().filter(name -> Collections.frequency(primaryKey.getColumns(), name) > 1).collect(Collectors.toSet());
        if (!duplicateColumns.isEmpty()) {
            throw new ValidationException(String.format("Invalid primary key '%s'. A primary key must not contain duplicate columns. Found: %s", primaryKey.getName(), duplicateColumns));
        }
        for (String columnName : primaryKey.getColumns()) {
            Column column = (Column)columnsByNameLookup.get(columnName);
            if (column == null) {
                throw new ValidationException(String.format("Invalid primary key '%s'. Column '%s' does not exist.", primaryKey.getName(), columnName));
            }
            if (!column.isPhysical()) {
                throw new ValidationException(String.format("Invalid primary key '%s'. Column '%s' is not a physical column.", primaryKey.getName(), columnName));
            }
            LogicalType columnType = column.getDataType().getLogicalType();
            if (!columnType.isNullable()) continue;
            throw new ValidationException(String.format("Invalid primary key '%s'. Column '%s' is nullable.", primaryKey.getName(), columnName));
        }
    }
}

