/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.FieldMetrics;
import org.apache.iceberg.avro.MetricsAwareDatumWriter;
import org.apache.iceberg.avro.ValueWriter;
import org.apache.iceberg.avro.ValueWriters;
import org.apache.iceberg.flink.data.AvroWithFlinkSchemaVisitor;
import org.apache.iceberg.flink.data.FlinkValueWriters;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.org.apache.avro.LogicalType;
import org.apache.iceberg.shaded.org.apache.avro.LogicalTypes;
import org.apache.iceberg.shaded.org.apache.avro.Schema;
import org.apache.iceberg.shaded.org.apache.avro.io.Encoder;

public class FlinkAvroWriter
implements MetricsAwareDatumWriter<RowData> {
    private final RowType rowType;
    private ValueWriter<RowData> writer = null;

    public FlinkAvroWriter(RowType rowType) {
        this.rowType = rowType;
    }

    @Override
    public void setSchema(Schema schema) {
        this.writer = (ValueWriter)AvroWithFlinkSchemaVisitor.visit(this.rowType, schema, new WriteBuilder());
    }

    @Override
    public void write(RowData datum, Encoder out) throws IOException {
        this.writer.write(datum, out);
    }

    @Override
    public Stream<FieldMetrics> metrics() {
        return this.writer.metrics();
    }

    private static class WriteBuilder
    extends AvroWithFlinkSchemaVisitor<ValueWriter<?>> {
        private WriteBuilder() {
        }

        @Override
        public ValueWriter<?> record(org.apache.flink.table.types.logical.LogicalType struct, Schema record, List<String> names, List<ValueWriter<?>> fields) {
            return FlinkValueWriters.row(fields, IntStream.range(0, names.size()).mapToObj(i -> this.fieldNameAndType(struct, i).second()).collect(Collectors.toList()));
        }

        @Override
        public ValueWriter<?> union(org.apache.flink.table.types.logical.LogicalType type, Schema union, List<ValueWriter<?>> options) {
            Preconditions.checkArgument(options.contains(ValueWriters.nulls()), "Cannot create writer for non-option union: %s", (Object)union);
            Preconditions.checkArgument(options.size() == 2, "Cannot create writer for non-option union: %s", (Object)union);
            if (union.getTypes().get(0).getType() == Schema.Type.NULL) {
                return ValueWriters.option(0, options.get(1));
            }
            return ValueWriters.option(1, options.get(0));
        }

        @Override
        public ValueWriter<?> array(org.apache.flink.table.types.logical.LogicalType sArray, Schema array, ValueWriter<?> elementWriter) {
            return FlinkValueWriters.array(elementWriter, this.arrayElementType(sArray));
        }

        @Override
        public ValueWriter<?> map(org.apache.flink.table.types.logical.LogicalType sMap, Schema map, ValueWriter<?> valueReader) {
            return FlinkValueWriters.map(FlinkValueWriters.strings(), this.mapKeyType(sMap), valueReader, this.mapValueType(sMap));
        }

        @Override
        public ValueWriter<?> map(org.apache.flink.table.types.logical.LogicalType sMap, Schema map, ValueWriter<?> keyWriter, ValueWriter<?> valueWriter) {
            return FlinkValueWriters.arrayMap(keyWriter, this.mapKeyType(sMap), valueWriter, this.mapValueType(sMap));
        }

        @Override
        public ValueWriter<?> primitive(org.apache.flink.table.types.logical.LogicalType type, Schema primitive) {
            LogicalType logicalType = primitive.getLogicalType();
            if (logicalType != null) {
                switch (logicalType.getName()) {
                    case "date": {
                        return ValueWriters.ints();
                    }
                    case "time-micros": {
                        return FlinkValueWriters.timeMicros();
                    }
                    case "timestamp-micros": {
                        return FlinkValueWriters.timestampMicros();
                    }
                    case "timestamp-nanos": {
                        return FlinkValueWriters.timestampNanos();
                    }
                    case "decimal": {
                        LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                        return FlinkValueWriters.decimal(decimal.getPrecision(), decimal.getScale());
                    }
                    case "uuid": {
                        return ValueWriters.uuids();
                    }
                }
                throw new IllegalArgumentException("Unsupported logical type: " + String.valueOf(logicalType));
            }
            switch (primitive.getType()) {
                case NULL: {
                    return ValueWriters.nulls();
                }
                case BOOLEAN: {
                    return ValueWriters.booleans();
                }
                case INT: {
                    switch (type.getTypeRoot()) {
                        case TINYINT: {
                            return ValueWriters.tinyints();
                        }
                        case SMALLINT: {
                            return ValueWriters.shorts();
                        }
                    }
                    return ValueWriters.ints();
                }
                case LONG: {
                    return ValueWriters.longs();
                }
                case FLOAT: {
                    return ValueWriters.floats();
                }
                case DOUBLE: {
                    return ValueWriters.doubles();
                }
                case STRING: {
                    return FlinkValueWriters.strings();
                }
                case FIXED: {
                    return ValueWriters.fixed(primitive.getFixedSize());
                }
                case BYTES: {
                    return ValueWriters.bytes();
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + String.valueOf(primitive));
        }
    }
}

