/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.maintenance.operator;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.Internal;
import org.apache.iceberg.flink.maintenance.api.JdbcLockFactory;
import org.apache.iceberg.flink.maintenance.api.LockConfig;
import org.apache.iceberg.flink.maintenance.api.TriggerLockFactory;
import org.apache.iceberg.flink.maintenance.api.ZkLockFactory;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

@Internal
public class LockFactoryBuilder {
    private LockFactoryBuilder() {
    }

    public static TriggerLockFactory build(LockConfig lockConfig, String tableName) {
        String lockType = lockConfig.lockType();
        Preconditions.checkArgument(StringUtils.isNotEmpty((CharSequence)lockType), "Configuration must contain key: %s", (Object)LockConfig.LOCK_TYPE_OPTION.key());
        switch (lockType) {
            case "jdbc": {
                return LockFactoryBuilder.createJdbcLockFactory(lockConfig, tableName);
            }
            case "zookeeper": {
                return LockFactoryBuilder.createZkLockFactory(lockConfig, tableName);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported lock type: %s ", lockType));
    }

    private static TriggerLockFactory createJdbcLockFactory(LockConfig lockConfig, String tableName) {
        String jdbcUri = lockConfig.jdbcUri();
        String lockId = lockConfig.lockId(tableName);
        Map<String, String> properties = lockConfig.properties();
        Preconditions.checkArgument(StringUtils.isNotEmpty((CharSequence)jdbcUri), "JDBC lock requires %s parameter", (Object)LockConfig.JdbcLockConfig.JDBC_URI_OPTION.key());
        properties.put("flink-maintenance.lock.jdbc.init-lock-tables", lockConfig.jdbcInitTable());
        return new JdbcLockFactory(jdbcUri, lockId, properties);
    }

    private static TriggerLockFactory createZkLockFactory(LockConfig lockConfig, String tableName) {
        String zkUri = lockConfig.zkUri();
        String lockId = lockConfig.lockId(tableName);
        Preconditions.checkArgument(StringUtils.isNotEmpty((CharSequence)zkUri), "Zk lock requires %s parameter", (Object)LockConfig.ZkLockConfig.ZK_URI_OPTION.key());
        return new ZkLockFactory(zkUri, lockId, lockConfig.zkSessionTimeoutMs(), lockConfig.zkConnectionTimeoutMs(), lockConfig.zkBaseSleepMs(), lockConfig.zkMaxRetries());
    }
}

