/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.maintenance.operator;

import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;

@Internal
public class TableChange {
    private int dataFileCount;
    private long dataFileSizeInBytes;
    private int posDeleteFileCount;
    private long posDeleteRecordCount;
    private int eqDeleteFileCount;
    private long eqDeleteRecordCount;
    private int commitCount;

    private TableChange(int dataFileCount, long dataFileSizeInBytes, int posDeleteFileCount, long posDeleteRecordCount, int eqDeleteFileCount, long eqDeleteRecordCount, int commitCount) {
        this.dataFileCount = dataFileCount;
        this.dataFileSizeInBytes = dataFileSizeInBytes;
        this.posDeleteFileCount = posDeleteFileCount;
        this.posDeleteRecordCount = posDeleteRecordCount;
        this.eqDeleteFileCount = eqDeleteFileCount;
        this.eqDeleteRecordCount = eqDeleteRecordCount;
        this.commitCount = commitCount;
    }

    TableChange(Snapshot snapshot, FileIO io) {
        this(snapshot.addedDataFiles(io), snapshot.addedDeleteFiles(io));
    }

    public TableChange(Iterable<DataFile> dataFiles, Iterable<DeleteFile> deleteFiles) {
        dataFiles.forEach(dataFile -> {
            ++this.dataFileCount;
            this.dataFileSizeInBytes += dataFile.fileSizeInBytes();
        });
        deleteFiles.forEach(deleteFile -> {
            switch (deleteFile.content()) {
                case POSITION_DELETES: {
                    ++this.posDeleteFileCount;
                    this.posDeleteRecordCount += deleteFile.recordCount();
                    break;
                }
                case EQUALITY_DELETES: {
                    ++this.eqDeleteFileCount;
                    this.eqDeleteRecordCount += deleteFile.recordCount();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected delete file content: " + String.valueOf(deleteFile));
                }
            }
        });
        this.commitCount = 1;
    }

    static TableChange empty() {
        return new TableChange(0, 0L, 0, 0L, 0, 0L, 0);
    }

    public static Builder builder() {
        return new Builder();
    }

    int dataFileCount() {
        return this.dataFileCount;
    }

    long dataFileSizeInBytes() {
        return this.dataFileSizeInBytes;
    }

    int posDeleteFileCount() {
        return this.posDeleteFileCount;
    }

    long posDeleteRecordCount() {
        return this.posDeleteRecordCount;
    }

    int eqDeleteFileCount() {
        return this.eqDeleteFileCount;
    }

    long eqDeleteRecordCount() {
        return this.eqDeleteRecordCount;
    }

    int commitCount() {
        return this.commitCount;
    }

    public void merge(TableChange other) {
        this.dataFileCount += other.dataFileCount;
        this.dataFileSizeInBytes += other.dataFileSizeInBytes;
        this.posDeleteFileCount += other.posDeleteFileCount;
        this.posDeleteRecordCount += other.posDeleteRecordCount;
        this.eqDeleteFileCount += other.eqDeleteFileCount;
        this.eqDeleteRecordCount += other.eqDeleteRecordCount;
        this.commitCount += other.commitCount;
    }

    TableChange copy() {
        return new TableChange(this.dataFileCount, this.dataFileSizeInBytes, this.posDeleteFileCount, this.posDeleteRecordCount, this.eqDeleteFileCount, this.eqDeleteRecordCount, this.commitCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("dataFileCount", this.dataFileCount).add("dataFileSizeInBytes", this.dataFileSizeInBytes).add("posDeleteFileCount", this.posDeleteFileCount).add("posDeleteRecordCount", this.posDeleteRecordCount).add("eqDeleteFileCount", this.eqDeleteFileCount).add("eqDeleteRecordCount", this.eqDeleteRecordCount).add("commitCount", this.commitCount).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TableChange that = (TableChange)other;
        return this.dataFileCount == that.dataFileCount && this.dataFileSizeInBytes == that.dataFileSizeInBytes && this.posDeleteFileCount == that.posDeleteFileCount && this.posDeleteRecordCount == that.posDeleteRecordCount && this.eqDeleteFileCount == that.eqDeleteFileCount && this.eqDeleteRecordCount == that.eqDeleteRecordCount && this.commitCount == that.commitCount;
    }

    public int hashCode() {
        return Objects.hash(this.dataFileCount, this.dataFileSizeInBytes, this.posDeleteFileCount, this.posDeleteRecordCount, this.eqDeleteFileCount, this.eqDeleteRecordCount, this.commitCount);
    }

    public static class Builder {
        private int dataFileCount = 0;
        private long dataFileSizeInBytes = 0L;
        private int posDeleteFileCount = 0;
        private long posDeleteRecordCount = 0L;
        private int eqDeleteFileCount = 0;
        private long eqDeleteRecordCount = 0L;
        private int commitCount = 0;

        private Builder() {
        }

        public Builder dataFileCount(int newDataFileCount) {
            this.dataFileCount = newDataFileCount;
            return this;
        }

        public Builder dataFileSizeInBytes(long newDataFileSizeInBytes) {
            this.dataFileSizeInBytes = newDataFileSizeInBytes;
            return this;
        }

        public Builder posDeleteFileCount(int newPosDeleteFileCount) {
            this.posDeleteFileCount = newPosDeleteFileCount;
            return this;
        }

        public Builder posDeleteRecordCount(long newPosDeleteRecordCount) {
            this.posDeleteRecordCount = newPosDeleteRecordCount;
            return this;
        }

        public Builder eqDeleteFileCount(int newEqDeleteFileCount) {
            this.eqDeleteFileCount = newEqDeleteFileCount;
            return this;
        }

        public Builder eqDeleteRecordCount(long newEqDeleteRecordCount) {
            this.eqDeleteRecordCount = newEqDeleteRecordCount;
            return this;
        }

        public Builder commitCount(int newCommitCount) {
            this.commitCount = newCommitCount;
            return this;
        }

        public TableChange build() {
            return new TableChange(this.dataFileCount, this.dataFileSizeInBytes, this.posDeleteFileCount, this.posDeleteRecordCount, this.eqDeleteFileCount, this.eqDeleteRecordCount, this.commitCount);
        }
    }
}

