/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.maintenance.operator;

import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.metrics.Counter;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.Collector;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.flink.maintenance.api.DeleteOrphanFiles;
import org.apache.iceberg.flink.maintenance.operator.MetadataTablePlanner;
import org.apache.iceberg.flink.maintenance.operator.TableMaintenanceMetrics;
import org.apache.iceberg.flink.source.DataIterator;
import org.apache.iceberg.flink.source.ScanContext;
import org.apache.iceberg.flink.source.reader.MetaDataReaderFunction;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;
import org.apache.iceberg.flink.source.split.IcebergSourceSplitSerializer;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class TableReader<R>
extends ProcessFunction<MetadataTablePlanner.SplitInfo, R> {
    private static final Logger LOG = LoggerFactory.getLogger(TableReader.class);
    private final TableLoader tableLoader;
    private final String taskName;
    private final int taskIndex;
    private final Schema projectedSchema;
    private IcebergSourceSplitSerializer splitSerializer;
    private final ScanContext scanContext;
    private final MetadataTableType metadataTableType;
    private transient MetaDataReaderFunction rowDataReaderFunction;
    private transient Counter errorCounter;

    TableReader(String taskName, int taskIndex, TableLoader tableLoader, Schema projectedSchema, ScanContext scanContext, MetadataTableType metadataTableType) {
        Preconditions.checkNotNull(taskName, "Task name should no be null");
        Preconditions.checkNotNull(tableLoader, "Table should no be null");
        Preconditions.checkNotNull(projectedSchema, "The projected schema should no be null");
        this.tableLoader = tableLoader;
        this.taskName = taskName;
        this.taskIndex = taskIndex;
        this.projectedSchema = projectedSchema;
        this.scanContext = scanContext;
        this.metadataTableType = metadataTableType;
    }

    public void open(OpenContext openContext) throws Exception {
        this.tableLoader.open();
        Table table = this.tableLoader.loadTable();
        Table metaTable = MetadataTableUtils.createMetadataTableInstance(table, this.metadataTableType);
        this.errorCounter = TableMaintenanceMetrics.groupFor(this.getRuntimeContext(), table.name(), this.taskName, this.taskIndex).counter("error");
        this.rowDataReaderFunction = new MetaDataReaderFunction((ReadableConfig)new Configuration(), metaTable.schema(), this.projectedSchema, metaTable.io(), metaTable.encryption());
        this.splitSerializer = new IcebergSourceSplitSerializer(this.scanContext.caseSensitive());
    }

    public void processElement(MetadataTablePlanner.SplitInfo splitInfo, ProcessFunction.Context ctx, Collector<R> out) throws Exception {
        IcebergSourceSplit split = this.splitSerializer.deserialize(splitInfo.version(), splitInfo.split());
        try (DataIterator<RowData> iterator = this.rowDataReaderFunction.createDataIterator(split);){
            iterator.forEachRemaining(rowData -> this.extract((RowData)rowData, out));
        }
        catch (Exception e) {
            LOG.warn("Exception processing split {} at {}", new Object[]{split, ctx.timestamp(), e});
            ctx.output(DeleteOrphanFiles.ERROR_STREAM, (Object)e);
            this.errorCounter.inc();
        }
    }

    public void close() throws Exception {
        super.close();
        this.tableLoader.close();
    }

    abstract void extract(RowData var1, Collector<R> var2);
}

