/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.util.Arrays;
import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.annotation.Internal;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.util.ScanTaskUtil;

@Internal
public class CommitSummary {
    private final AtomicLong dataFilesCount = new AtomicLong();
    private final AtomicLong dataFilesRecordCount = new AtomicLong();
    private final AtomicLong dataFilesByteCount = new AtomicLong();
    private final AtomicLong deleteFilesCount = new AtomicLong();
    private final AtomicLong deleteFilesRecordCount = new AtomicLong();
    private final AtomicLong deleteFilesByteCount = new AtomicLong();

    public CommitSummary() {
    }

    public CommitSummary(NavigableMap<Long, WriteResult> pendingResults) {
        pendingResults.values().forEach(this::addWriteResult);
    }

    public void addAll(NavigableMap<Long, List<WriteResult>> pendingResults) {
        pendingResults.values().forEach(writeResults -> writeResults.forEach(this::addWriteResult));
    }

    private void addWriteResult(WriteResult writeResult) {
        this.dataFilesCount.addAndGet(writeResult.dataFiles().length);
        Arrays.stream(writeResult.dataFiles()).forEach(dataFile -> {
            this.dataFilesRecordCount.addAndGet(dataFile.recordCount());
            this.dataFilesByteCount.addAndGet(dataFile.fileSizeInBytes());
        });
        this.deleteFilesCount.addAndGet(writeResult.deleteFiles().length);
        Arrays.stream(writeResult.deleteFiles()).forEach(deleteFile -> {
            this.deleteFilesRecordCount.addAndGet(deleteFile.recordCount());
            long deleteBytes = ScanTaskUtil.contentSizeInBytes(deleteFile);
            this.deleteFilesByteCount.addAndGet(deleteBytes);
        });
    }

    public long dataFilesCount() {
        return this.dataFilesCount.get();
    }

    long dataFilesRecordCount() {
        return this.dataFilesRecordCount.get();
    }

    long dataFilesByteCount() {
        return this.dataFilesByteCount.get();
    }

    public long deleteFilesCount() {
        return this.deleteFilesCount.get();
    }

    long deleteFilesRecordCount() {
        return this.deleteFilesRecordCount.get();
    }

    long deleteFilesByteCount() {
        return this.deleteFilesByteCount.get();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("dataFilesCount", this.dataFilesCount).add("dataFilesRecordCount", this.dataFilesRecordCount).add("dataFilesByteCount", this.dataFilesByteCount).add("deleteFilesCount", this.deleteFilesCount).add("deleteFilesRecordCount", this.deleteFilesRecordCount).add("deleteFilesByteCount", this.deleteFilesByteCount).toString();
    }
}

