/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

@Internal
public class DeltaManifests {
    private static final CharSequence[] EMPTY_REF_DATA_FILES = new CharSequence[0];
    private final ManifestFile dataManifest;
    private final ManifestFile deleteManifest;
    private final CharSequence[] referencedDataFiles;

    DeltaManifests(ManifestFile dataManifest, ManifestFile deleteManifest) {
        this(dataManifest, deleteManifest, EMPTY_REF_DATA_FILES);
    }

    DeltaManifests(ManifestFile dataManifest, ManifestFile deleteManifest, CharSequence[] referencedDataFiles) {
        Preconditions.checkNotNull(referencedDataFiles, "Referenced data files shouldn't be null.");
        this.dataManifest = dataManifest;
        this.deleteManifest = deleteManifest;
        this.referencedDataFiles = referencedDataFiles;
    }

    ManifestFile dataManifest() {
        return this.dataManifest;
    }

    ManifestFile deleteManifest() {
        return this.deleteManifest;
    }

    CharSequence[] referencedDataFiles() {
        return this.referencedDataFiles;
    }

    public List<ManifestFile> manifests() {
        ArrayList<ManifestFile> manifests = Lists.newArrayListWithCapacity(2);
        if (this.dataManifest != null) {
            manifests.add(this.dataManifest);
        }
        if (this.deleteManifest != null) {
            manifests.add(this.deleteManifest);
        }
        return manifests;
    }
}

