/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.dynamic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.iceberg.flink.sink.WriteResultSerializer;
import org.apache.iceberg.flink.sink.dynamic.DynamicWriteResult;
import org.apache.iceberg.flink.sink.dynamic.WriteTarget;
import org.apache.iceberg.io.WriteResult;

class DynamicWriteResultSerializer
implements SimpleVersionedSerializer<DynamicWriteResult> {
    private static final int VERSION = 1;
    private static final WriteResultSerializer WRITE_RESULT_SERIALIZER = new WriteResultSerializer();

    DynamicWriteResultSerializer() {
    }

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(DynamicWriteResult writeResult) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper((OutputStream)out);
        writeResult.key().serializeTo((DataOutputView)view);
        byte[] result = WRITE_RESULT_SERIALIZER.serialize(writeResult.writeResult());
        view.write(result);
        return out.toByteArray();
    }

    public DynamicWriteResult deserialize(int version, byte[] serialized) throws IOException {
        if (version == 1) {
            DataInputDeserializer view = new DataInputDeserializer(serialized);
            WriteTarget key = WriteTarget.deserializeFrom((DataInputView)view);
            byte[] resultBuf = new byte[view.available()];
            view.read(resultBuf);
            WriteResult writeResult = WRITE_RESULT_SERIALIZER.deserialize(version, resultBuf);
            return new DynamicWriteResult(key, writeResult);
        }
        throw new IOException("Unrecognized version or corrupt state: " + version);
    }
}

