/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.dynamic;

import java.util.List;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

public class PartitionSpecEvolution {
    private PartitionSpecEvolution() {
    }

    public static boolean checkCompatibility(PartitionSpec spec1, PartitionSpec spec2) {
        if (spec1.equals(spec2)) {
            return true;
        }
        if (spec1.fields().size() != spec2.fields().size()) {
            return false;
        }
        for (int i = 0; i < spec1.fields().size(); ++i) {
            PartitionField field1 = spec1.fields().get(i);
            PartitionField field2 = spec2.fields().get(i);
            if (PartitionSpecEvolution.specFieldsAreCompatible(field1, spec1.schema(), field2, spec2.schema())) continue;
            return false;
        }
        return true;
    }

    static PartitionSpecChanges evolve(PartitionSpec currentSpec, PartitionSpec targetSpec) {
        if (currentSpec.compatibleWith(targetSpec)) {
            return new PartitionSpecChanges();
        }
        PartitionSpecChanges result = new PartitionSpecChanges();
        int maxNumFields = Math.max(currentSpec.fields().size(), targetSpec.fields().size());
        for (int i = 0; i < maxNumFields; ++i) {
            PartitionField currentField = Iterables.get(currentSpec.fields(), i, null);
            PartitionField targetField = Iterables.get(targetSpec.fields(), i, null);
            if (PartitionSpecEvolution.specFieldsAreCompatible(currentField, currentSpec.schema(), targetField, targetSpec.schema())) continue;
            if (currentField != null) {
                result.remove(PartitionSpecEvolution.toTerm(currentField, currentSpec.schema()));
            }
            if (targetField == null) continue;
            result.add(PartitionSpecEvolution.toTerm(targetField, targetSpec.schema()));
        }
        return result;
    }

    private static Term toTerm(PartitionField field, Schema schema) {
        String sourceName = schema.idToName().get(field.sourceId());
        return Expressions.transform(sourceName, field.transform());
    }

    private static boolean specFieldsAreCompatible(PartitionField field1, Schema schemaField1, PartitionField field2, Schema schemaField2) {
        String secondFieldSourceName;
        if (field1 == null || field2 == null) {
            return false;
        }
        String firstFieldSourceName = schemaField1.idToName().get(field1.sourceId());
        return firstFieldSourceName.equals(secondFieldSourceName = schemaField2.idToName().get(field2.sourceId())) && field1.transform().toString().equals(field2.transform().toString());
    }

    static class PartitionSpecChanges {
        private final List<Term> termsToAdd = Lists.newArrayList();
        private final List<Term> termsToRemove = Lists.newArrayList();

        PartitionSpecChanges() {
        }

        public void add(Term term) {
            this.termsToAdd.add(term);
        }

        public void remove(Term term) {
            this.termsToRemove.add(term);
        }

        public List<Term> termsToAdd() {
            return this.termsToAdd;
        }

        public List<Term> termsToRemove() {
            return this.termsToRemove;
        }

        public boolean isEmpty() {
            return this.termsToAdd.isEmpty() && this.termsToRemove.isEmpty();
        }

        public String toString() {
            return MoreObjects.toStringHelper(PartitionSpecEvolution.class).add("termsToAdd", this.termsToAdd).add("termsToRemove", this.termsToRemove).toString();
        }
    }
}

