/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.table.data.RowData;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.flink.sink.shuffle.GlobalStatistics;
import org.apache.iceberg.flink.sink.shuffle.MapRangePartitioner;
import org.apache.iceberg.flink.sink.shuffle.SketchRangePartitioner;
import org.apache.iceberg.flink.sink.shuffle.StatisticsOrRecord;
import org.apache.iceberg.flink.sink.shuffle.StatisticsType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class RangePartitioner
implements Partitioner<StatisticsOrRecord> {
    private static final Logger LOG = LoggerFactory.getLogger(RangePartitioner.class);
    private final Schema schema;
    private final SortOrder sortOrder;
    private transient AtomicLong roundRobinCounter;
    private transient Partitioner<RowData> delegatePartitioner;

    public RangePartitioner(Schema schema, SortOrder sortOrder) {
        this.schema = schema;
        this.sortOrder = sortOrder;
    }

    public int partition(StatisticsOrRecord wrapper, int numPartitions) {
        if (wrapper.hasStatistics()) {
            this.delegatePartitioner = this.delegatePartitioner(wrapper.statistics());
            return (int)(this.roundRobinCounter(numPartitions).getAndIncrement() % (long)numPartitions);
        }
        if (this.delegatePartitioner != null) {
            return this.delegatePartitioner.partition((Object)wrapper.record(), numPartitions);
        }
        int partition = (int)(this.roundRobinCounter(numPartitions).getAndIncrement() % (long)numPartitions);
        LOG.trace("Statistics not available. Round robin to partition {}", (Object)partition);
        return partition;
    }

    private AtomicLong roundRobinCounter(int numPartitions) {
        if (this.roundRobinCounter == null) {
            this.roundRobinCounter = new AtomicLong(new Random().nextInt(numPartitions));
        }
        return this.roundRobinCounter;
    }

    private Partitioner<RowData> delegatePartitioner(GlobalStatistics statistics) {
        if (statistics.type() == StatisticsType.Map) {
            return new MapRangePartitioner(this.schema, this.sortOrder, statistics.mapAssignment());
        }
        if (statistics.type() == StatisticsType.Sketch) {
            return new SketchRangePartitioner(this.schema, this.sortOrder, statistics.rangeBounds());
        }
        throw new IllegalArgumentException(String.format("Invalid statistics type: %s. Should be Map or Sketch", new Object[]{statistics.type()}));
    }

    static int adjustPartitionWithRescale(int partition, int numPartitionsStatsCalculation, int numPartitions) {
        if (numPartitionsStatsCalculation <= numPartitions) {
            return partition;
        }
        return partition % numPartitions;
    }
}

