/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.util.Comparator;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.table.data.RowData;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortKey;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.RowDataWrapper;
import org.apache.iceberg.flink.sink.shuffle.SketchUtil;
import org.apache.iceberg.flink.sink.shuffle.SortKeyUtil;
import org.apache.iceberg.types.Comparators;

class SketchRangePartitioner
implements Partitioner<RowData> {
    private final SortKey sortKey;
    private final Comparator<StructLike> comparator;
    private final SortKey[] rangeBounds;
    private final RowDataWrapper rowDataWrapper;

    SketchRangePartitioner(Schema schema, SortOrder sortOrder, SortKey[] rangeBounds) {
        this.sortKey = new SortKey(schema, sortOrder);
        this.comparator = Comparators.forType(SortKeyUtil.sortKeySchema(schema, sortOrder).asStruct());
        this.rangeBounds = rangeBounds;
        this.rowDataWrapper = new RowDataWrapper(FlinkSchemaUtil.convert(schema), schema.asStruct());
    }

    public int partition(RowData row, int numPartitions) {
        this.sortKey.wrap(this.rowDataWrapper.wrap(row));
        return SketchUtil.partition(this.sortKey, numPartitions, this.rangeBounds, this.comparator);
    }
}

