/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.gcp.gcs;

import com.google.api.client.util.Lists;
import com.google.api.client.util.Maps;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.gcp.GCPProperties;
import org.apache.iceberg.gcp.gcs.GCSInputFile;
import org.apache.iceberg.gcp.gcs.GCSLocation;
import org.apache.iceberg.gcp.gcs.GCSOutputFile;
import org.apache.iceberg.gcp.gcs.PrefixedStorage;
import org.apache.iceberg.io.BulkDeletionFailureException;
import org.apache.iceberg.io.DelegateFileIO;
import org.apache.iceberg.io.FileInfo;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.StorageCredential;
import org.apache.iceberg.io.SupportsStorageCredentials;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterators;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.apache.iceberg.util.SerializableMap;
import org.apache.iceberg.util.SerializableSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCSFileIO
implements DelegateFileIO,
SupportsStorageCredentials {
    private static final Logger LOG = LoggerFactory.getLogger(GCSFileIO.class);
    private static final String DEFAULT_METRICS_IMPL = "org.apache.iceberg.hadoop.HadoopMetricsContext";
    private static final String ROOT_STORAGE_PREFIX = "gs";
    private SerializableSupplier<Storage> storageSupplier;
    private MetricsContext metrics = MetricsContext.nullMetrics();
    private final AtomicBoolean isResourceClosed = new AtomicBoolean(false);
    private SerializableMap<String, String> properties = null;
    private List<StorageCredential> storageCredentials = Lists.newArrayList();
    private volatile transient Map<String, PrefixedStorage> storageByPrefix;

    public GCSFileIO() {
    }

    public GCSFileIO(SerializableSupplier<Storage> storageSupplier) {
        this.storageSupplier = storageSupplier;
        this.properties = SerializableMap.copyOf(Maps.newHashMap());
    }

    @Deprecated
    public GCSFileIO(SerializableSupplier<Storage> storageSupplier, GCPProperties gcpProperties) {
        this.storageSupplier = storageSupplier;
        this.properties = SerializableMap.copyOf(gcpProperties.properties());
    }

    @Override
    public InputFile newInputFile(String path) {
        return GCSInputFile.fromLocation(path, this.clientForStoragePath(path), this.metrics);
    }

    @Override
    public InputFile newInputFile(String path, long length) {
        return GCSInputFile.fromLocation(path, length, this.clientForStoragePath(path), this.metrics);
    }

    @Override
    public OutputFile newOutputFile(String path) {
        return GCSOutputFile.fromLocation(path, this.clientForStoragePath(path), this.metrics);
    }

    @Override
    public void deleteFile(String path) {
        if (!this.clientForStoragePath(path).storage().delete(BlobId.fromGsUtilUri((String)path))) {
            LOG.warn("Failed to delete path: {}", (Object)path);
        }
    }

    @Override
    public Map<String, String> properties() {
        return this.properties.immutableMap();
    }

    public Storage client() {
        return this.client(ROOT_STORAGE_PREFIX);
    }

    public Storage client(String storagePath) {
        return this.clientForStoragePath(storagePath).storage();
    }

    private PrefixedStorage clientForStoragePath(String storagePath) {
        String matchingPrefix = ROOT_STORAGE_PREFIX;
        for (String storagePrefix : this.storageByPrefix().keySet()) {
            if (!storagePath.startsWith(storagePrefix) || storagePrefix.length() <= matchingPrefix.length()) continue;
            matchingPrefix = storagePrefix;
        }
        PrefixedStorage client = this.storageByPrefix().getOrDefault(matchingPrefix, null);
        Preconditions.checkState(null != client, "[BUG] GCS client for storage path not available: %s", (Object)storagePath);
        return client;
    }

    @Override
    public void initialize(Map<String, String> props) {
        this.properties = SerializableMap.copyOf(props);
        this.initMetrics(this.properties);
    }

    private void initMetrics(Map<String, String> props) {
        try {
            DynConstructors.Ctor ctor = DynConstructors.builder(MetricsContext.class).hiddenImpl(DEFAULT_METRICS_IMPL, String.class).buildChecked();
            MetricsContext context = (MetricsContext)ctor.newInstance("gcs");
            context.initialize(props);
            this.metrics = context;
        }
        catch (ClassCastException | NoClassDefFoundError | NoSuchMethodException e) {
            LOG.warn("Unable to load metrics class: '{}', falling back to null metrics", (Object)DEFAULT_METRICS_IMPL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, PrefixedStorage> storageByPrefix() {
        if (null == this.storageByPrefix) {
            GCSFileIO gCSFileIO = this;
            synchronized (gCSFileIO) {
                if (null == this.storageByPrefix) {
                    HashMap localStorageByPrefix = Maps.newHashMap();
                    localStorageByPrefix.put(ROOT_STORAGE_PREFIX, new PrefixedStorage(ROOT_STORAGE_PREFIX, this.properties, this.storageSupplier));
                    this.storageCredentials.stream().filter(c -> c.prefix().startsWith(ROOT_STORAGE_PREFIX)).collect(Collectors.toList()).forEach(storageCredential -> {
                        ImmutableMap<String, String> propertiesWithCredentials = ImmutableMap.builder().putAll(this.properties).putAll(storageCredential.config()).buildKeepingLast();
                        localStorageByPrefix.put(storageCredential.prefix(), new PrefixedStorage(storageCredential.prefix(), propertiesWithCredentials, this.storageSupplier));
                    });
                    this.storageByPrefix = localStorageByPrefix;
                }
            }
        }
        return this.storageByPrefix;
    }

    @Override
    public void close() {
        if (this.isResourceClosed.compareAndSet(false, true) && this.storageByPrefix != null) {
            this.storageByPrefix.values().forEach(PrefixedStorage::close);
            this.storageByPrefix = null;
        }
    }

    @Override
    public Iterable<FileInfo> listPrefix(String prefix) {
        GCSLocation location = new GCSLocation(prefix);
        return () -> this.clientForStoragePath(prefix).storage().list(location.bucket(), new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)location.prefix())}).streamAll().map(blob -> new FileInfo(String.format("gs://%s/%s", blob.getBucket(), blob.getName()), blob.getSize(), this.createTimeMillis((Blob)blob))).iterator();
    }

    private long createTimeMillis(Blob blob) {
        if (blob.getCreateTimeOffsetDateTime() == null) {
            return 0L;
        }
        return blob.getCreateTimeOffsetDateTime().toInstant().toEpochMilli();
    }

    @Override
    public void deletePrefix(String prefix) {
        this.internalDeleteFiles(Streams.stream(this.listPrefix(prefix)).map(fileInfo -> BlobId.fromGsUtilUri((String)fileInfo.location())));
    }

    @Override
    public void deleteFiles(Iterable<String> pathsToDelete) throws BulkDeletionFailureException {
        this.internalDeleteFiles(Streams.stream(pathsToDelete).map(BlobId::fromGsUtilUri));
    }

    private void internalDeleteFiles(Stream<BlobId> blobIdsToDelete) {
        Streams.stream(Iterators.partition(blobIdsToDelete.iterator(), this.clientForStoragePath(ROOT_STORAGE_PREFIX).gcpProperties().deleteBatchSize())).forEach(batch -> {
            if (!batch.isEmpty()) {
                this.clientForStoragePath(((BlobId)batch.get(0)).toGsUtilUri()).storage().delete((Iterable)batch);
            }
        });
    }

    @Override
    public void setCredentials(List<StorageCredential> credentials) {
        Preconditions.checkArgument(credentials != null, "Invalid storage credentials: null");
        this.storageCredentials = Lists.newArrayList(credentials);
    }

    @Override
    public List<StorageCredential> credentials() {
        return ImmutableList.copyOf(this.storageCredentials);
    }
}

