/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.gcp.gcs;

import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.apache.iceberg.EnvironmentContext;
import org.apache.iceberg.gcp.GCPAuthUtils;
import org.apache.iceberg.gcp.GCPProperties;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Strings;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.util.SerializableSupplier;

class PrefixedStorage
implements AutoCloseable {
    private static final String GCS_FILE_IO_USER_AGENT = "gcsfileio/" + String.valueOf(EnvironmentContext.get());
    private final String storagePrefix;
    private final GCPProperties gcpProperties;
    private SerializableSupplier<Storage> storage;
    private CloseableGroup closeableGroup;
    private volatile transient Storage storageClient;

    PrefixedStorage(String storagePrefix, Map<String, String> properties, SerializableSupplier<Storage> storage) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(storagePrefix), "Invalid storage prefix: null or empty");
        Preconditions.checkArgument(null != properties, "Invalid properties: null");
        this.storagePrefix = storagePrefix;
        this.storage = storage;
        this.gcpProperties = new GCPProperties(properties);
        if (null == storage) {
            this.storage = () -> {
                StorageOptions.Builder builder = (StorageOptions.Builder)StorageOptions.newBuilder().setHeaderProvider((HeaderProvider)FixedHeaderProvider.create(ImmutableMap.of("User-agent", GCS_FILE_IO_USER_AGENT)));
                this.gcpProperties.projectId().ifPresent(arg_0 -> ((StorageOptions.Builder)builder).setProjectId(arg_0));
                this.gcpProperties.clientLibToken().ifPresent(arg_0 -> ((StorageOptions.Builder)builder).setClientLibToken(arg_0));
                this.gcpProperties.serviceHost().ifPresent(arg_0 -> ((StorageOptions.Builder)builder).setHost(arg_0));
                if (this.gcpProperties.noAuth()) {
                    builder.setCredentials((Credentials)NoCredentials.getInstance());
                }
                if (this.gcpProperties.oauth2Token().isPresent()) {
                    this.closeableGroup = new CloseableGroup();
                    builder.setCredentials((Credentials)GCPAuthUtils.oauth2CredentialsFromGcpProperties(this.gcpProperties, this.closeableGroup));
                }
                return (Storage)builder.build().getService();
            };
        }
    }

    public String storagePrefix() {
        return this.storagePrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Storage storage() {
        if (null == this.storageClient) {
            PrefixedStorage prefixedStorage = this;
            synchronized (prefixedStorage) {
                if (null == this.storageClient) {
                    this.storageClient = (Storage)this.storage.get();
                }
            }
        }
        return this.storageClient;
    }

    public GCPProperties gcpProperties() {
        return this.gcpProperties;
    }

    @Override
    public void close() {
        if (null != this.closeableGroup) {
            try {
                this.closeableGroup.close();
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        }
        if (null != this.storage) {
            this.storage = null;
        }
    }
}

