/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SortOrderParser;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.iceberg.util.JsonUtil;
import org.apache.iceberg.view.ViewMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HMSTablePropertyHelper {
    private static final Logger LOG = LoggerFactory.getLogger(HMSTablePropertyHelper.class);
    private static final String HIVE_ICEBERG_STORAGE_HANDLER = "org.apache.iceberg.mr.hive.HiveIcebergStorageHandler";
    private static final Map<String, String> ICEBERG_TO_HMS_TRANSLATION = ImmutableMap.of("gc.enabled", "external.table.purge");

    private HMSTablePropertyHelper() {
    }

    public static void updateHmsTableForIcebergTable(String newMetadataLocation, Table tbl, TableMetadata metadata, Set<String> obsoleteProps, boolean hiveEngineEnabled, long maxHiveTablePropertySize, String currentLocation) {
        Map parameters = Optional.ofNullable(tbl.getParameters()).orElseGet(Maps::newHashMap);
        Map summary = Optional.ofNullable(metadata.currentSnapshot()).map(Snapshot::summary).orElseGet(ImmutableMap::of);
        metadata.properties().entrySet().stream().filter(entry -> !((String)entry.getKey()).equalsIgnoreCase("hive.metastore.table.owner")).forEach(entry -> {
            String key = (String)entry.getKey();
            String hmsKey = ICEBERG_TO_HMS_TRANSLATION.getOrDefault(key, key);
            parameters.put(hmsKey, (String)entry.getValue());
        });
        HMSTablePropertyHelper.setCommonParameters(newMetadataLocation, metadata.uuid(), obsoleteProps, currentLocation, parameters, "iceberg".toUpperCase(Locale.ENGLISH), metadata.schema(), maxHiveTablePropertySize);
        HMSTablePropertyHelper.setStorageHandler(parameters, hiveEngineEnabled);
        if (summary.get("total-data-files") != null) {
            parameters.put("numFiles", (String)summary.get("total-data-files"));
        }
        if (summary.get("total-records") != null) {
            parameters.put("numRows", (String)summary.get("total-records"));
        }
        if (summary.get("total-files-size") != null) {
            parameters.put("totalSize", (String)summary.get("total-files-size"));
        }
        HMSTablePropertyHelper.setSnapshotStats(metadata, parameters, maxHiveTablePropertySize);
        HMSTablePropertyHelper.setPartitionSpec(metadata, parameters, maxHiveTablePropertySize);
        HMSTablePropertyHelper.setSortOrder(metadata, parameters, maxHiveTablePropertySize);
        tbl.setParameters(parameters);
    }

    public static void updateHmsTableForIcebergView(String newMetadataLocation, Table tbl, ViewMetadata metadata, Set<String> obsoleteProps, long maxHiveTablePropertySize, String currentLocation) {
        Map parameters = Optional.ofNullable(tbl.getParameters()).orElseGet(Maps::newHashMap);
        metadata.properties().entrySet().stream().filter(entry -> !((String)entry.getKey()).equalsIgnoreCase("hive.metastore.table.owner")).forEach(entry -> parameters.put((String)entry.getKey(), (String)entry.getValue()));
        HMSTablePropertyHelper.setCommonParameters(newMetadataLocation, metadata.uuid(), obsoleteProps, currentLocation, parameters, "iceberg-view".toUpperCase(Locale.ENGLISH), metadata.schema(), maxHiveTablePropertySize);
        tbl.setParameters(parameters);
    }

    private static void setCommonParameters(String newMetadataLocation, String uuid, Set<String> obsoleteProps, String currentLocation, Map<String, String> parameters, String tableType, Schema schema, long maxHiveTablePropertySize) {
        if (uuid != null) {
            parameters.put("uuid", uuid);
        }
        obsoleteProps.forEach(parameters::remove);
        parameters.put("table_type", tableType);
        parameters.put("metadata_location", newMetadataLocation);
        if (currentLocation != null && !currentLocation.isEmpty()) {
            parameters.put("previous_metadata_location", currentLocation);
        }
        HMSTablePropertyHelper.setSchema(schema, parameters, maxHiveTablePropertySize);
    }

    private static void setStorageHandler(Map<String, String> parameters, boolean hiveEngineEnabled) {
        if (hiveEngineEnabled) {
            parameters.put("storage_handler", HIVE_ICEBERG_STORAGE_HANDLER);
        } else {
            parameters.remove("storage_handler");
        }
    }

    @VisibleForTesting
    static void setSnapshotStats(TableMetadata metadata, Map<String, String> parameters, long maxHiveTablePropertySize) {
        parameters.remove("current-snapshot-id");
        parameters.remove("current-snapshot-timestamp-ms");
        parameters.remove("current-snapshot-summary");
        Snapshot currentSnapshot = metadata.currentSnapshot();
        if (HMSTablePropertyHelper.exposeInHmsProperties(maxHiveTablePropertySize) && currentSnapshot != null) {
            parameters.put("current-snapshot-id", String.valueOf(currentSnapshot.snapshotId()));
            parameters.put("current-snapshot-timestamp-ms", String.valueOf(currentSnapshot.timestampMillis()));
            HMSTablePropertyHelper.setSnapshotSummary(parameters, currentSnapshot, maxHiveTablePropertySize);
        }
        parameters.put("snapshot-count", String.valueOf(metadata.snapshots().size()));
    }

    @VisibleForTesting
    static void setSnapshotSummary(Map<String, String> parameters, Snapshot currentSnapshot, long maxHiveTablePropertySize) {
        try {
            String summary = JsonUtil.mapper().writeValueAsString(currentSnapshot.summary());
            if ((long)summary.length() <= maxHiveTablePropertySize) {
                parameters.put("current-snapshot-summary", summary);
            } else {
                LOG.warn("Not exposing the current snapshot({}) summary in HMS since it exceeds {} characters", (Object)currentSnapshot.snapshotId(), (Object)maxHiveTablePropertySize);
            }
        }
        catch (JsonProcessingException e) {
            LOG.warn("Failed to convert current snapshot({}) summary to a json string", (Object)currentSnapshot.snapshotId(), (Object)e);
        }
    }

    @VisibleForTesting
    static void setPartitionSpec(TableMetadata metadata, Map<String, String> parameters, long maxHiveTablePropertySize) {
        parameters.remove("default-partition-spec");
        if (HMSTablePropertyHelper.exposeInHmsProperties(maxHiveTablePropertySize) && metadata.spec() != null && metadata.spec().isPartitioned()) {
            String spec = PartitionSpecParser.toJson(metadata.spec());
            HMSTablePropertyHelper.setField(parameters, "default-partition-spec", spec, maxHiveTablePropertySize);
        }
    }

    @VisibleForTesting
    static void setSortOrder(TableMetadata metadata, Map<String, String> parameters, long maxHiveTablePropertySize) {
        parameters.remove("default-sort-order");
        if (HMSTablePropertyHelper.exposeInHmsProperties(maxHiveTablePropertySize) && metadata.sortOrder() != null && metadata.sortOrder().isSorted()) {
            String sortOrder = SortOrderParser.toJson(metadata.sortOrder());
            HMSTablePropertyHelper.setField(parameters, "default-sort-order", sortOrder, maxHiveTablePropertySize);
        }
    }

    @VisibleForTesting
    static void setSchema(Schema schema, Map<String, String> parameters, long maxHiveTablePropertySize) {
        parameters.remove("current-schema");
        if (HMSTablePropertyHelper.exposeInHmsProperties(maxHiveTablePropertySize) && schema != null) {
            String jsonSchema = SchemaParser.toJson(schema);
            HMSTablePropertyHelper.setField(parameters, "current-schema", jsonSchema, maxHiveTablePropertySize);
        }
    }

    private static void setField(Map<String, String> parameters, String key, String value, long maxHiveTablePropertySize) {
        if ((long)value.length() <= maxHiveTablePropertySize) {
            parameters.put(key, value);
        } else {
            LOG.warn("Not exposing {} in HMS since it exceeds {} characters", (Object)key, (Object)maxHiveTablePropertySize);
        }
    }

    private static boolean exposeInHmsProperties(long maxHiveTablePropertySize) {
        return maxHiveTablePropertySize > 0L;
    }
}

