/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.hive.CachedClientPool;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CachedClientPool.Key", generator="Immutables")
@Immutable
final class ImmutableKey
extends CachedClientPool.Key {
    private final List<Object> elements;

    private ImmutableKey(List<Object> elements) {
        this.elements = elements;
    }

    @Override
    List<Object> elements() {
        return this.elements;
    }

    public final ImmutableKey withElements(Object ... elements) {
        List<Object> newValue = ImmutableKey.createUnmodifiableList(false, ImmutableKey.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableKey(newValue);
    }

    public final ImmutableKey withElements(Iterable<? extends Object> elements) {
        if (this.elements == elements) {
            return this;
        }
        List<Object> newValue = ImmutableKey.createUnmodifiableList(false, ImmutableKey.createSafeList(elements, true, false));
        return new ImmutableKey(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKey && this.equalsByValue((ImmutableKey)another);
    }

    private boolean equalsByValue(ImmutableKey another) {
        return this.elements.equals(another.elements);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.elements.hashCode();
        return h2;
    }

    public String toString() {
        return "Key{elements=" + String.valueOf(this.elements) + "}";
    }

    public static ImmutableKey copyOf(CachedClientPool.Key instance) {
        if (instance instanceof ImmutableKey) {
            return (ImmutableKey)instance;
        }
        return ImmutableKey.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="CachedClientPool.Key", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<Object> elements = new ArrayList<Object>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CachedClientPool.Key instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllElements(instance.elements());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addElements(Object element) {
            this.elements.add(Objects.requireNonNull(element, "elements element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addElements(Object ... elements) {
            for (Object element : elements) {
                this.elements.add(Objects.requireNonNull(element, "elements element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder elements(Iterable<? extends Object> elements) {
            this.elements.clear();
            return this.addAllElements(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllElements(Iterable<? extends Object> elements) {
            for (Object object : elements) {
                this.elements.add(Objects.requireNonNull(object, "elements element"));
            }
            return this;
        }

        public ImmutableKey build() {
            return new ImmutableKey(ImmutableKey.createUnmodifiableList(true, this.elements));
        }
    }
}

