/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.inmemory;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.UUID;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.inmemory.InMemoryFileIO;
import org.apache.iceberg.inmemory.InMemoryInputFile;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class InMemoryOutputFile
implements OutputFile {
    private final String location;
    private final InMemoryFileIO parentFileIO;
    private boolean exists = false;
    private ByteArrayOutputStream contents;

    public InMemoryOutputFile() {
        this("memory:" + String.valueOf(UUID.randomUUID()));
    }

    public InMemoryOutputFile(String location) {
        this(location, null);
    }

    public InMemoryOutputFile(String location, InMemoryFileIO parentFileIO) {
        Preconditions.checkNotNull(location, "location is null");
        this.location = location;
        this.parentFileIO = parentFileIO;
    }

    @Override
    public PositionOutputStream create() {
        if (this.exists || this.parentFileIO != null && this.parentFileIO.fileExists(this.location)) {
            throw new AlreadyExistsException("Already exists", new Object[0]);
        }
        return this.createOrOverwrite();
    }

    @Override
    public PositionOutputStream createOrOverwrite() {
        this.exists = true;
        this.contents = new ByteArrayOutputStream();
        return new InMemoryPositionOutputStream(this.contents);
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    public InputFile toInputFile() {
        Preconditions.checkState(this.exists, "Cannot convert a file that has not been written yet");
        return new InMemoryInputFile(this.location(), this.toByteArray());
    }

    public byte[] toByteArray() {
        return this.contents.toByteArray();
    }

    private class InMemoryPositionOutputStream
    extends PositionOutputStream {
        private final ByteArrayOutputStream delegate;
        private boolean closed = false;

        InMemoryPositionOutputStream(ByteArrayOutputStream delegate) {
            Preconditions.checkNotNull(delegate, "delegate is null");
            this.delegate = delegate;
        }

        @Override
        public long getPos() {
            return this.delegate.size();
        }

        @Override
        public void write(int b) {
            this.checkOpen();
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.checkOpen();
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.checkOpen();
            this.delegate.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.checkOpen();
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
            this.closed = true;
            if (InMemoryOutputFile.this.parentFileIO != null) {
                InMemoryOutputFile.this.parentFileIO.addFile(InMemoryOutputFile.this.location(), InMemoryOutputFile.this.toByteArray());
            }
        }

        private void checkOpen() {
            Preconditions.checkState(!this.closed, "Stream is closed");
        }
    }
}

