/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.iceberg.shaded.org.apache.parquet.io.api.Binary;
import org.apache.iceberg.shaded.org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.iceberg.shaded.org.apache.parquet.schema.PrimitiveType;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.util.UUIDUtil;

class ParquetConversions {
    private ParquetConversions() {
    }

    static <T> T convertValue(Type type, PrimitiveType parquetType, Object value) {
        switch (type.typeId()) {
            case BOOLEAN: 
            case INTEGER: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case TIMESTAMP_NANO: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return (T)value;
            }
            case STRING: {
                return (T)((Binary)value).toStringUsingUTF8();
            }
            case UUID: {
                return (T)UUIDUtil.convert(((Binary)value).toByteBuffer());
            }
            case FIXED: 
            case BINARY: {
                return (T)((Binary)value).toByteBuffer();
            }
            case DECIMAL: {
                int scale = ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)parquetType.getLogicalTypeAnnotation()).getScale();
                switch (parquetType.getPrimitiveTypeName()) {
                    case INT32: 
                    case INT64: {
                        return (T)BigDecimal.valueOf(((Number)value).longValue(), scale);
                    }
                    case FIXED_LEN_BYTE_ARRAY: 
                    case BINARY: {
                        return (T)new BigDecimal(new BigInteger(((Binary)value).getBytes()), scale);
                    }
                }
                throw new IllegalArgumentException("Unsupported primitive type for decimal: " + String.valueOf((Object)parquetType.getPrimitiveTypeName()));
            }
        }
        throw new IllegalArgumentException("Unsupported primitive type: " + String.valueOf(type));
    }

    static Function<Object, Object> converterFromParquet(PrimitiveType parquetType, Type icebergType) {
        Function<Object, Object> fromParquet = ParquetConversions.converterFromParquet(parquetType);
        if (icebergType != null) {
            if (icebergType.typeId() == Type.TypeID.LONG && parquetType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT32) {
                return value -> ((Integer)fromParquet.apply(value)).longValue();
            }
            if (icebergType.typeId() == Type.TypeID.DOUBLE && parquetType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.FLOAT) {
                return value -> ((Float)fromParquet.apply(value)).doubleValue();
            }
        }
        return fromParquet;
    }

    static Function<Object, Object> converterFromParquet(PrimitiveType type) {
        if (type.getOriginalType() != null) {
            switch (type.getOriginalType()) {
                case UTF8: {
                    return binary -> StandardCharsets.UTF_8.decode(((Binary)binary).toByteBuffer());
                }
                case DECIMAL: {
                    LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimal = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)type.getLogicalTypeAnnotation();
                    int scale = decimal.getScale();
                    switch (type.getPrimitiveTypeName()) {
                        case INT32: 
                        case INT64: {
                            return num -> BigDecimal.valueOf(((Number)num).longValue(), scale);
                        }
                        case FIXED_LEN_BYTE_ARRAY: 
                        case BINARY: {
                            return bin -> new BigDecimal(new BigInteger(((Binary)bin).getBytes()), scale);
                        }
                    }
                    throw new IllegalArgumentException("Unsupported primitive type for decimal: " + String.valueOf((Object)type.getPrimitiveTypeName()));
                }
            }
        }
        switch (type.getPrimitiveTypeName()) {
            case FIXED_LEN_BYTE_ARRAY: 
            case BINARY: {
                return binary -> ByteBuffer.wrap(((Binary)binary).getBytes());
            }
            case INT96: {
                return binary -> ParquetUtil.extractTimestampInt96(ByteBuffer.wrap(((Binary)binary).getBytes()).order(ByteOrder.LITTLE_ENDIAN));
            }
        }
        return obj -> obj;
    }
}

