/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.parquet.ParquetVariantVisitor;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.org.apache.parquet.schema.GroupType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.iceberg.shaded.org.apache.parquet.schema.MessageType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.PrimitiveType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.Type;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class TypeWithSchemaVisitor<T> {
    protected ArrayDeque<String> fieldNames = new ArrayDeque();

    public static <T> T visit(org.apache.iceberg.types.Type iType, Type type, TypeWithSchemaVisitor<T> visitor) {
        if (type instanceof MessageType) {
            Types.StructType struct = iType != null ? iType.asStructType() : null;
            return visitor.message(struct, (MessageType)type, TypeWithSchemaVisitor.visitFields(struct, type.asGroupType(), visitor));
        }
        if (type.isPrimitive()) {
            Type.PrimitiveType iPrimitive = iType != null ? iType.asPrimitiveType() : null;
            return visitor.primitive(iPrimitive, type.asPrimitiveType());
        }
        GroupType group = type.asGroupType();
        LogicalTypeAnnotation annotation = group.getLogicalTypeAnnotation();
        if (annotation instanceof LogicalTypeAnnotation.ListLogicalTypeAnnotation) {
            return TypeWithSchemaVisitor.visitList(iType, group, visitor);
        }
        if (annotation instanceof LogicalTypeAnnotation.MapLogicalTypeAnnotation) {
            return TypeWithSchemaVisitor.visitMap(iType, group, visitor);
        }
        if (annotation instanceof LogicalTypeAnnotation.VariantLogicalTypeAnnotation || iType != null && iType.isVariantType()) {
            return TypeWithSchemaVisitor.visitVariant(iType.asVariantType(), group, visitor);
        }
        Types.StructType struct = iType != null ? iType.asStructType() : null;
        return visitor.struct(struct, group, TypeWithSchemaVisitor.visitFields(struct, group, visitor));
    }

    private static <T> T visitList(org.apache.iceberg.types.Type iType, GroupType group, TypeWithSchemaVisitor<T> visitor) {
        Preconditions.checkArgument(group.getFieldCount() == 1, "Invalid list: does not contain single repeated field: %s", (Object)group);
        Type repeatedElement = group.getFields().get(0);
        Preconditions.checkArgument(repeatedElement.isRepetition(Type.Repetition.REPEATED), "Invalid list: inner group is not repeated");
        Type listElement = ParquetSchemaUtil.determineListElementType(group);
        Types.ListType list = null;
        Types.NestedField element = null;
        if (iType != null) {
            list = iType.asListType();
            element = list.fields().get(0);
        }
        if (listElement.isRepetition(Type.Repetition.REPEATED)) {
            return TypeWithSchemaVisitor.visitTwoLevelList(list, element, group, listElement, visitor);
        }
        return TypeWithSchemaVisitor.visitThreeLevelList(list, element, group, listElement, visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T visitMap(org.apache.iceberg.types.Type iType, GroupType group, TypeWithSchemaVisitor<T> visitor) {
        Preconditions.checkArgument(!group.isRepetition(Type.Repetition.REPEATED), "Invalid map: top-level group is repeated: %s", (Object)group);
        Preconditions.checkArgument(group.getFieldCount() == 1, "Invalid map: does not contain single repeated field: %s", (Object)group);
        GroupType repeatedKeyValue = group.getType(0).asGroupType();
        Preconditions.checkArgument(repeatedKeyValue.isRepetition(Type.Repetition.REPEATED), "Invalid map: inner group is not repeated");
        Preconditions.checkArgument(repeatedKeyValue.getFieldCount() <= 2, "Invalid map: repeated group does not have 2 fields");
        Types.MapType map = null;
        Types.NestedField keyField = null;
        Types.NestedField valueField = null;
        if (iType != null) {
            map = iType.asMapType();
            keyField = map.fields().get(0);
            valueField = map.fields().get(1);
        }
        visitor.fieldNames.push(repeatedKeyValue.getName());
        try {
            T keyResult = null;
            T valueResult = null;
            switch (repeatedKeyValue.getFieldCount()) {
                case 2: {
                    keyResult = TypeWithSchemaVisitor.visitField(keyField, repeatedKeyValue.getType(0), visitor);
                    valueResult = TypeWithSchemaVisitor.visitField(valueField, repeatedKeyValue.getType(1), visitor);
                    break;
                }
                case 1: {
                    Type keyOrValue = repeatedKeyValue.getType(0);
                    if (keyOrValue.getName().equalsIgnoreCase("key")) {
                        keyResult = TypeWithSchemaVisitor.visitField(keyField, keyOrValue, visitor);
                        break;
                    }
                    valueResult = TypeWithSchemaVisitor.visitField(valueField, keyOrValue, visitor);
                    break;
                }
            }
            T t2 = visitor.map(map, group, keyResult, valueResult);
            return t2;
        }
        finally {
            visitor.fieldNames.pop();
        }
    }

    private static <T> T visitTwoLevelList(Types.ListType iListType, Types.NestedField iListElement, GroupType pListType, Type pListElement, TypeWithSchemaVisitor<T> visitor) {
        T elementResult = TypeWithSchemaVisitor.visitField(iListElement, pListElement, visitor);
        return visitor.list(iListType, pListType, elementResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T visitThreeLevelList(Types.ListType iListType, Types.NestedField iListElement, GroupType pListType, Type pListElement, TypeWithSchemaVisitor<T> visitor) {
        visitor.fieldNames.push(pListType.getFieldName(0));
        try {
            T elementResult = TypeWithSchemaVisitor.visitField(iListElement, pListElement, visitor);
            T t2 = visitor.list(iListType, pListType, elementResult);
            return t2;
        }
        finally {
            visitor.fieldNames.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T visitField(Types.NestedField iField, Type field, TypeWithSchemaVisitor<T> visitor) {
        visitor.fieldNames.push(field.getName());
        try {
            T t2 = TypeWithSchemaVisitor.visit(iField != null ? iField.type() : null, field, visitor);
            return t2;
        }
        finally {
            visitor.fieldNames.pop();
        }
    }

    private static <T> List<T> visitFields(Types.StructType struct, GroupType group, TypeWithSchemaVisitor<T> visitor) {
        ArrayList<T> results = Lists.newArrayListWithExpectedSize(group.getFieldCount());
        for (Type field : group.getFields()) {
            int id = -1;
            if (field.getId() != null) {
                id = field.getId().intValue();
            }
            Types.NestedField iField = struct != null && id >= 0 ? struct.field(id) : null;
            results.add(TypeWithSchemaVisitor.visitField(iField, field, visitor));
        }
        return results;
    }

    private static <T> T visitVariant(Types.VariantType variant, GroupType variantGroup, TypeWithSchemaVisitor<T> visitor) {
        ParquetVariantVisitor<T> variantVisitor = visitor.variantVisitor();
        if (variantVisitor != null) {
            T variantResult = ParquetVariantVisitor.visit(variantGroup, variantVisitor);
            return visitor.variant(variant, variantGroup, variantResult);
        }
        return visitor.variant(variant, variantGroup, null);
    }

    public T message(Types.StructType iStruct, MessageType message, List<T> fields) {
        return null;
    }

    public T struct(Types.StructType iStruct, GroupType struct, List<T> fields) {
        return null;
    }

    public T list(Types.ListType iList, GroupType array, T element) {
        return null;
    }

    public T map(Types.MapType iMap, GroupType map, T key, T value) {
        return null;
    }

    public T variant(Types.VariantType iVariant, GroupType variant, T result) {
        throw new UnsupportedOperationException("Not implemented for variant");
    }

    public T primitive(Type.PrimitiveType iPrimitive, PrimitiveType primitive) {
        return null;
    }

    public ParquetVariantVisitor<T> variantVisitor() {
        return null;
    }

    protected String[] currentPath() {
        return Lists.newArrayList(this.fieldNames.descendingIterator()).toArray(new String[0]);
    }

    protected String[] path(String name) {
        ArrayList<String> list = Lists.newArrayList(this.fieldNames.descendingIterator());
        list.add(name);
        return list.toArray(new String[0]);
    }
}

