/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.parquet.ReadConf;
import org.apache.iceberg.parquet.VectorizedReader;
import org.apache.iceberg.shaded.org.apache.parquet.ParquetReadOptions;
import org.apache.iceberg.shaded.org.apache.parquet.column.page.PageReadStore;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.iceberg.shaded.org.apache.parquet.schema.MessageType;

public class VectorizedParquetReader<T>
extends CloseableGroup
implements CloseableIterable<T> {
    private final InputFile input;
    private final Schema expectedSchema;
    private final ParquetReadOptions options;
    private final Function<MessageType, VectorizedReader<?>> batchReaderFunc;
    private final Expression filter;
    private final boolean reuseContainers;
    private final boolean caseSensitive;
    private final int batchSize;
    private final NameMapping nameMapping;
    private ReadConf conf = null;

    public VectorizedParquetReader(InputFile input, Schema expectedSchema, ParquetReadOptions options, Function<MessageType, VectorizedReader<?>> readerFunc, NameMapping nameMapping, Expression filter, boolean reuseContainers, boolean caseSensitive, int maxRecordsPerBatch) {
        this.input = input;
        this.expectedSchema = expectedSchema;
        this.options = options;
        this.batchReaderFunc = readerFunc;
        this.filter = filter == Expressions.alwaysTrue() ? null : filter;
        this.reuseContainers = reuseContainers;
        this.caseSensitive = caseSensitive;
        this.batchSize = maxRecordsPerBatch;
        this.nameMapping = nameMapping;
    }

    private ReadConf init() {
        if (this.conf == null) {
            ReadConf readConf = new ReadConf(this.input, this.options, this.expectedSchema, this.filter, null, this.batchReaderFunc, this.nameMapping, this.reuseContainers, this.caseSensitive, this.batchSize);
            this.conf = readConf.copy();
            return readConf;
        }
        return this.conf;
    }

    @Override
    public CloseableIterator<T> iterator() {
        FileIterator iter = new FileIterator(this.init());
        this.addCloseable(iter);
        return iter;
    }

    private static class FileIterator<T>
    implements CloseableIterator<T> {
        private final ParquetFileReader reader;
        private final boolean[] shouldSkip;
        private final VectorizedReader<T> model;
        private final long totalValues;
        private final int batchSize;
        private final List<Map<ColumnPath, ColumnChunkMetaData>> columnChunkMetadata;
        private final boolean reuseContainers;
        private int nextRowGroup = 0;
        private long nextRowGroupStart = 0L;
        private long valuesRead = 0L;
        private T last = null;

        FileIterator(ReadConf conf) {
            this.reader = conf.reader();
            this.shouldSkip = conf.shouldSkip();
            this.totalValues = conf.totalValues();
            this.reuseContainers = conf.reuseContainers();
            this.model = conf.vectorizedModel();
            this.batchSize = conf.batchSize();
            this.model.setBatchSize(this.batchSize);
            this.columnChunkMetadata = conf.columnChunkMetadataForRowGroups();
        }

        @Override
        public boolean hasNext() {
            return this.valuesRead < this.totalValues;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.valuesRead >= this.nextRowGroupStart) {
                this.advance();
            }
            int numValuesToRead = (int)Math.min(this.nextRowGroupStart - this.valuesRead, (long)this.batchSize);
            this.last = this.reuseContainers ? this.model.read(this.last, numValuesToRead) : this.model.read(null, numValuesToRead);
            this.valuesRead += (long)numValuesToRead;
            return this.last;
        }

        private void advance() {
            PageReadStore pages;
            while (this.shouldSkip[this.nextRowGroup]) {
                ++this.nextRowGroup;
                this.reader.skipNextRowGroup();
            }
            try {
                pages = this.reader.readNextRowGroup();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            this.model.setRowGroupInfo(pages, this.columnChunkMetadata.get(this.nextRowGroup));
            this.nextRowGroupStart += pages.getRowCount();
            ++this.nextRowGroup;
        }

        @Override
        public void close() throws IOException {
            this.model.close();
            this.reader.close();
        }
    }
}

