/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.rest.responses.LoadViewResponse;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.apache.iceberg.view.ViewMetadata;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LoadViewResponse", generator="Immutables")
@Immutable
public final class ImmutableLoadViewResponse
implements LoadViewResponse {
    private final String metadataLocation;
    private final ViewMetadata metadata;
    private final Map<String, String> config;

    private ImmutableLoadViewResponse(String metadataLocation, ViewMetadata metadata, Map<String, String> config) {
        this.metadataLocation = metadataLocation;
        this.metadata = metadata;
        this.config = config;
    }

    @Override
    public String metadataLocation() {
        return this.metadataLocation;
    }

    @Override
    public ViewMetadata metadata() {
        return this.metadata;
    }

    @Override
    public Map<String, String> config() {
        return this.config;
    }

    public final ImmutableLoadViewResponse withMetadataLocation(String value) {
        String newValue = Objects.requireNonNull(value, "metadataLocation");
        if (this.metadataLocation.equals(newValue)) {
            return this;
        }
        return new ImmutableLoadViewResponse(newValue, this.metadata, this.config);
    }

    public final ImmutableLoadViewResponse withMetadata(ViewMetadata value) {
        if (this.metadata == value) {
            return this;
        }
        ViewMetadata newValue = Objects.requireNonNull(value, "metadata");
        return new ImmutableLoadViewResponse(this.metadataLocation, newValue, this.config);
    }

    public final ImmutableLoadViewResponse withConfig(Map<String, ? extends String> entries) {
        if (this.config == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableLoadViewResponse.createUnmodifiableMap(true, false, entries);
        return new ImmutableLoadViewResponse(this.metadataLocation, this.metadata, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLoadViewResponse && this.equalsByValue((ImmutableLoadViewResponse)another);
    }

    private boolean equalsByValue(ImmutableLoadViewResponse another) {
        return this.metadataLocation.equals(another.metadataLocation) && this.metadata.equals(another.metadata) && this.config.equals(another.config);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.metadataLocation.hashCode();
        h2 += (h2 << 5) + this.metadata.hashCode();
        h2 += (h2 << 5) + this.config.hashCode();
        return h2;
    }

    public String toString() {
        return "LoadViewResponse{metadataLocation=" + this.metadataLocation + ", metadata=" + String.valueOf(this.metadata) + ", config=" + String.valueOf(this.config) + "}";
    }

    public static ImmutableLoadViewResponse copyOf(LoadViewResponse instance) {
        if (instance instanceof ImmutableLoadViewResponse) {
            return (ImmutableLoadViewResponse)instance;
        }
        return ImmutableLoadViewResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="LoadViewResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_METADATA_LOCATION = 1L;
        private static final long INIT_BIT_METADATA = 2L;
        private long initBits = 3L;
        @Nullable
        private String metadataLocation;
        @Nullable
        private ViewMetadata metadata;
        private Map<String, String> config = new LinkedHashMap<String, String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(LoadViewResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.metadataLocation(instance.metadataLocation());
            this.metadata(instance.metadata());
            this.putAllConfig(instance.config());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metadataLocation(String metadataLocation) {
            this.metadataLocation = Objects.requireNonNull(metadataLocation, "metadataLocation");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metadata(ViewMetadata metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putConfig(String key, String value) {
            this.config.put(Objects.requireNonNull(key, "config key"), Objects.requireNonNull(value, value == null ? "config value for key: " + key : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putConfig(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.config.put(Objects.requireNonNull(k, "config key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "config value for key: " + k : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder config(Map<String, ? extends String> entries) {
            this.config.clear();
            return this.putAllConfig(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllConfig(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.config.put(Objects.requireNonNull(k, "config key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "config value for key: " + k : null));
            }
            return this;
        }

        public ImmutableLoadViewResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLoadViewResponse(this.metadataLocation, this.metadata, ImmutableLoadViewResponse.createUnmodifiableMap(false, false, this.config));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("metadataLocation");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("metadata");
            }
            return "Cannot build LoadViewResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

