/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.PlanStatus;
import org.apache.iceberg.rest.responses.BaseScanTaskResponse;

public class PlanTableScanResponse
extends BaseScanTaskResponse {
    private final PlanStatus planStatus;
    private final String planId;

    private PlanTableScanResponse(PlanStatus planStatus, String planId, List<String> planTasks, List<FileScanTask> fileScanTasks, List<DeleteFile> deleteFiles, Map<Integer, PartitionSpec> specsById) {
        super(planTasks, fileScanTasks, deleteFiles, specsById);
        this.planStatus = planStatus;
        this.planId = planId;
        this.validate();
    }

    public PlanStatus planStatus() {
        return this.planStatus;
    }

    public String planId() {
        return this.planId;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("planStatus", (Object)this.planStatus()).add("planId", this.planId()).toString();
    }

    @Override
    public void validate() {
        Preconditions.checkArgument(this.planStatus() != null, "Invalid response: plan status must be defined");
        Preconditions.checkArgument(this.planStatus() != PlanStatus.SUBMITTED || this.planId() != null, "Invalid response: plan id should be defined when status is 'submitted'");
        Preconditions.checkArgument(this.planStatus() != PlanStatus.CANCELLED, "Invalid response: 'cancelled' is not a valid status for planTableScan");
        Preconditions.checkArgument(this.planStatus() == PlanStatus.COMPLETED || this.planTasks() == null && this.fileScanTasks() == null, "Invalid response: tasks can only be defined when status is 'completed'");
        Preconditions.checkArgument(this.planStatus() == PlanStatus.SUBMITTED || this.planId() == null, "Invalid response: plan id can only be defined when status is 'submitted'");
        if (this.fileScanTasks() == null || this.fileScanTasks().isEmpty()) {
            Preconditions.checkArgument(this.deleteFiles() == null || this.deleteFiles().isEmpty(), "Invalid response: deleteFiles should only be returned with fileScanTasks that reference them");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends BaseScanTaskResponse.Builder<Builder, PlanTableScanResponse> {
        private PlanStatus planStatus;
        private String planId;

        public Builder withPlanStatus(PlanStatus status) {
            this.planStatus = status;
            return this;
        }

        public Builder withPlanId(String id) {
            this.planId = id;
            return this;
        }

        @Override
        public PlanTableScanResponse build() {
            return new PlanTableScanResponse(this.planStatus, this.planId, this.planTasks(), this.fileScanTasks(), this.deleteFiles(), this.specsById());
        }
    }
}

