/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.hc.client5.http;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.shaded.org.apache.hc.core5.annotation.Contract;
import org.apache.iceberg.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;

@Contract(threading=ThreadingBehavior.STATELESS)
public interface DnsResolver {
    public InetAddress[] resolve(String var1) throws UnknownHostException;

    public String resolveCanonicalHostname(String var1) throws UnknownHostException;

    default public List<InetSocketAddress> resolve(String host, int port) throws UnknownHostException {
        InetAddress[] inetAddresses = this.resolve(host);
        if (inetAddresses == null) {
            return Collections.singletonList(InetSocketAddress.createUnresolved(host, port));
        }
        return Arrays.stream(inetAddresses).map(e -> new InetSocketAddress((InetAddress)e, port)).collect(Collectors.toList());
    }
}

