/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.hc.client5.http.impl;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iceberg.shaded.org.apache.hc.core5.annotation.Internal;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.FormattedHeader;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.Header;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.HttpMessage;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.HttpVersion;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.ParseException;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.ProtocolException;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.ProtocolVersion;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.ProtocolVersionParser;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.message.ParserCursor;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.ssl.TLS;
import org.apache.iceberg.shaded.org.apache.hc.core5.util.Args;
import org.apache.iceberg.shaded.org.apache.hc.core5.util.CharArrayBuffer;
import org.apache.iceberg.shaded.org.apache.hc.core5.util.Tokenizer;

@Internal
public final class ProtocolSwitchStrategy {
    private static final ProtocolVersionParser PROTOCOL_VERSION_PARSER = ProtocolVersionParser.INSTANCE;
    private static final Tokenizer TOKENIZER = Tokenizer.INSTANCE;
    private static final Tokenizer.Delimiter UPGRADE_TOKEN_DELIMITER = Tokenizer.delimiters(',');
    private static final Tokenizer.Delimiter LAX_PROTO_DELIMITER = Tokenizer.delimiters('/', ',');

    public ProtocolVersion switchProtocol(HttpMessage response) throws ProtocolException {
        AtomicReference tlsUpgrade = new AtomicReference();
        this.parseHeaders(response, "Upgrade", (buffer, cursor) -> {
            ProtocolVersion protocolVersion = this.parseProtocolVersion(buffer, cursor);
            if (protocolVersion != null) {
                if ("TLS".equalsIgnoreCase(protocolVersion.getProtocol())) {
                    tlsUpgrade.set(protocolVersion);
                } else if (!protocolVersion.equals(HttpVersion.HTTP_1_1)) {
                    throw new ProtocolException("Unsupported protocol or HTTP version: " + protocolVersion);
                }
            }
        });
        ProtocolVersion result = (ProtocolVersion)tlsUpgrade.get();
        if (result != null) {
            return result;
        }
        throw new ProtocolException("Invalid protocol switch response: no TLS version found");
    }

    private ProtocolVersion parseProtocolVersion(CharSequence buffer, ParserCursor cursor) throws ProtocolException {
        char ch;
        TOKENIZER.skipWhiteSpace(buffer, cursor);
        String proto = TOKENIZER.parseToken(buffer, (Tokenizer.Cursor)cursor, LAX_PROTO_DELIMITER);
        if (!cursor.atEnd() && (ch = buffer.charAt(cursor.getPos())) == '/') {
            if (proto.isEmpty()) {
                throw new ParseException("Invalid protocol", buffer, cursor.getLowerBound(), cursor.getUpperBound(), cursor.getPos());
            }
            cursor.updatePos(cursor.getPos() + 1);
            return PROTOCOL_VERSION_PARSER.parse(proto, null, buffer, cursor, UPGRADE_TOKEN_DELIMITER);
        }
        if (proto.isEmpty()) {
            return null;
        }
        if (proto.equalsIgnoreCase("TLS")) {
            return TLS.V_1_2.getVersion();
        }
        throw new ProtocolException("Unsupported or invalid protocol: " + proto);
    }

    private void parseHeaders(HttpMessage message, String name, HeaderConsumer consumer) throws ProtocolException {
        Iterator<Header> it = message.headerIterator(name);
        while (it.hasNext()) {
            this.parseHeader(it.next(), consumer);
        }
    }

    private void parseHeader(Header header, HeaderConsumer consumer) throws ProtocolException {
        Args.notNull(header, "Header");
        if (header instanceof FormattedHeader) {
            CharArrayBuffer buf = ((FormattedHeader)header).getBuffer();
            ParserCursor cursor = new ParserCursor(0, buf.length());
            cursor.updatePos(((FormattedHeader)header).getValuePos());
            this.parseHeaderElements(buf, cursor, consumer);
        } else {
            String value = header.getValue();
            if (value == null) {
                return;
            }
            ParserCursor cursor = new ParserCursor(0, value.length());
            this.parseHeaderElements(value, cursor, consumer);
        }
    }

    private void parseHeaderElements(CharSequence buffer, ParserCursor cursor, HeaderConsumer consumer) throws ProtocolException {
        while (!cursor.atEnd()) {
            char ch;
            consumer.accept(buffer, cursor);
            if (cursor.atEnd() || (ch = buffer.charAt(cursor.getPos())) != ',') continue;
            cursor.updatePos(cursor.getPos() + 1);
        }
    }

    @FunctionalInterface
    private static interface HeaderConsumer {
        public void accept(CharSequence var1, ParserCursor var2) throws ProtocolException;
    }
}

