/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.orc.impl.mask;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.iceberg.shaded.org.apache.orc.DataMask;
import org.apache.iceberg.shaded.org.apache.orc.TypeDescription;
import org.apache.iceberg.shaded.org.apache.orc.impl.mask.MaskFactory;
import org.apache.iceberg.shaded.org.apache.orc.impl.mask.NullifyMask;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.ColumnVector;

public class SHA256MaskFactory
extends MaskFactory {
    private final MessageDigest md;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    SHA256MaskFactory() {
        try {
            this.md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String printHexBinary(byte[] data) {
        char[] out = new char[data.length << 1];
        int j = 0;
        for (int i = 0; i < data.length; ++i) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
        }
        return new String(out);
    }

    void maskString(BytesColumnVector source, int row, BytesColumnVector target, TypeDescription schema) {
        this.md.update(source.vector[row], source.start[row], source.length[row]);
        byte[] hash = SHA256MaskFactory.printHexBinary(this.md.digest()).getBytes(StandardCharsets.UTF_8);
        int targetLength = hash.length;
        switch (schema.getCategory()) {
            case VARCHAR: {
                if (schema.getMaxLength() >= hash.length) break;
                targetLength = schema.getMaxLength();
                break;
            }
            case CHAR: {
                targetLength = schema.getMaxLength();
                if (targetLength <= hash.length) break;
                byte[] tmp = Arrays.copyOf(hash, targetLength);
                Arrays.fill(tmp, hash.length, tmp.length - 1, (byte)32);
                hash = tmp;
                break;
            }
        }
        target.vector[row] = hash;
        target.start[row] = 0;
        target.length[row] = targetLength;
    }

    void maskBinary(BytesColumnVector source, int row, BytesColumnVector target) {
        ByteBuffer sourceBytes = ByteBuffer.wrap(source.vector[row], source.start[row], source.length[row]);
        byte[] hash = this.md.digest(sourceBytes.array());
        int targetLength = hash.length;
        target.vector[row] = hash;
        target.start[row] = 0;
        target.length[row] = targetLength;
    }

    @Override
    protected DataMask buildBinaryMask(TypeDescription schema) {
        return new BinaryMask();
    }

    @Override
    protected DataMask buildBooleanMask(TypeDescription schema) {
        return new NullifyMask();
    }

    @Override
    protected DataMask buildLongMask(TypeDescription schema) {
        return new NullifyMask();
    }

    @Override
    protected DataMask buildDecimalMask(TypeDescription schema) {
        return new NullifyMask();
    }

    @Override
    protected DataMask buildDoubleMask(TypeDescription schema) {
        return new NullifyMask();
    }

    @Override
    protected DataMask buildStringMask(TypeDescription schema) {
        return new StringMask(schema);
    }

    @Override
    protected DataMask buildDateMask(TypeDescription schema) {
        return new NullifyMask();
    }

    @Override
    protected DataMask buildTimestampMask(TypeDescription schema) {
        return new NullifyMask();
    }

    class BinaryMask
    implements DataMask {
        BinaryMask() {
        }

        @Override
        public void maskData(ColumnVector original, ColumnVector masked, int start, int length) {
            BytesColumnVector target = (BytesColumnVector)masked;
            BytesColumnVector source = (BytesColumnVector)original;
            target.noNulls = original.noNulls;
            target.isRepeating = original.isRepeating;
            if (original.isRepeating) {
                target.isNull[0] = source.isNull[0];
                if (target.noNulls || !target.isNull[0]) {
                    SHA256MaskFactory.this.maskBinary(source, 0, target);
                }
            } else {
                for (int r = start; r < start + length; ++r) {
                    target.isNull[r] = source.isNull[r];
                    if (!target.noNulls && target.isNull[r]) continue;
                    SHA256MaskFactory.this.maskBinary(source, r, target);
                }
            }
        }
    }

    class StringMask
    implements DataMask {
        final TypeDescription schema;

        StringMask(TypeDescription schema) {
            this.schema = schema;
        }

        @Override
        public void maskData(ColumnVector original, ColumnVector masked, int start, int length) {
            BytesColumnVector target = (BytesColumnVector)masked;
            BytesColumnVector source = (BytesColumnVector)original;
            target.noNulls = original.noNulls;
            target.isRepeating = original.isRepeating;
            if (original.isRepeating) {
                target.isNull[0] = source.isNull[0];
                if (target.noNulls || !target.isNull[0]) {
                    SHA256MaskFactory.this.maskString(source, 0, target, this.schema);
                }
            } else {
                for (int r = start; r < start + length; ++r) {
                    target.isNull[r] = source.isNull[r];
                    if (!target.noNulls && target.isNull[r]) continue;
                    SHA256MaskFactory.this.maskString(source, r, target, this.schema);
                }
            }
        }
    }
}

