/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.column.statistics.geospatial;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;

public class GeospatialTypes {
    private static final int UNKNOWN_TYPE_ID = -1;
    private Set<Integer> types = new HashSet<Integer>();
    private boolean valid = true;

    public GeospatialTypes(Set<Integer> types) {
        this.types = types;
        this.valid = true;
    }

    public GeospatialTypes(Set<Integer> types, boolean valid) {
        this.types = types;
        this.valid = valid;
    }

    public GeospatialTypes() {
    }

    public Set<Integer> getTypes() {
        return this.types;
    }

    public void update(Geometry geometry) {
        if (!this.valid) {
            return;
        }
        if (geometry == null || geometry.isEmpty()) {
            return;
        }
        int code = this.getGeometryTypeCode(geometry);
        if (code != -1) {
            this.types.add(code);
        } else {
            this.valid = false;
            this.types.clear();
        }
    }

    public void merge(GeospatialTypes other) {
        if (!this.valid) {
            return;
        }
        if (other == null || !other.valid) {
            this.valid = false;
            this.types.clear();
            return;
        }
        this.types.addAll(other.types);
    }

    public void reset() {
        this.types.clear();
        this.valid = true;
    }

    public void abort() {
        this.valid = false;
        this.types.clear();
    }

    public boolean isValid() {
        return this.valid;
    }

    public GeospatialTypes copy() {
        return new GeospatialTypes(new HashSet<Integer>(this.types), this.valid);
    }

    private int getBaseTypeCode(int typeId) {
        return typeId % 1000;
    }

    private int getDimensionPrefix(int typeId) {
        return typeId / 1000 * 1000;
    }

    public String toString() {
        return "GeospatialTypes{types=" + this.types.stream().map(this::typeIdToString).collect(Collectors.toSet()) + '}';
    }

    private int getGeometryTypeId(Geometry geometry) {
        switch (geometry.getGeometryType()) {
            case "Point": {
                return 1;
            }
            case "LineString": {
                return 2;
            }
            case "Polygon": {
                return 3;
            }
            case "MultiPoint": {
                return 4;
            }
            case "MultiLineString": {
                return 5;
            }
            case "MultiPolygon": {
                return 6;
            }
            case "GeometryCollection": {
                return 7;
            }
        }
        return -1;
    }

    private int getGeometryTypeCode(Geometry geometry) {
        int typeId = this.getGeometryTypeId(geometry);
        if (typeId == -1) {
            return -1;
        }
        Coordinate[] coordinates = geometry.getCoordinates();
        boolean hasZ = false;
        boolean hasM = false;
        if (coordinates.length > 0) {
            Coordinate firstCoord = coordinates[0];
            hasZ = !Double.isNaN(firstCoord.getZ());
            boolean bl = hasM = !Double.isNaN(firstCoord.getM());
        }
        if (hasZ) {
            typeId += 1000;
        }
        if (hasM) {
            typeId += 2000;
        }
        return typeId;
    }

    private String typeIdToString(int typeId) {
        String typeString;
        switch (typeId % 1000) {
            case 1: {
                typeString = "Point";
                break;
            }
            case 2: {
                typeString = "LineString";
                break;
            }
            case 3: {
                typeString = "Polygon";
                break;
            }
            case 4: {
                typeString = "MultiPoint";
                break;
            }
            case 5: {
                typeString = "MultiLineString";
                break;
            }
            case 6: {
                typeString = "MultiPolygon";
                break;
            }
            case 7: {
                typeString = "GeometryCollection";
                break;
            }
            default: {
                return "Unknown";
            }
        }
        typeString = typeId >= 3000 ? typeString + " (XYZM)" : (typeId >= 2000 ? typeString + " (XYM)" : (typeId >= 1000 ? typeString + " (XYZ)" : typeString + " (XY)"));
        return typeString;
    }
}

